<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- generation -->
	
	<!-- generated algorithm -->
	
	<xsl:template match="method | constructor | destructor | operator | function | test-procedure | static | thread | set-property | get-property" mode="algorithm">
		<xsl:choose>
			<xsl:when test="algorithm">
				<xsl:apply-templates select="algorithm" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="aspects or sequences">
					<h4 onclick="toggleAlgorithm('{generate-id(.)}-function')">Algorithm</h4>
					<ol id="{generate-id(.)}-function" state="collapsed" class="algorithm">
						<xsl:apply-templates select="aspects" mode="generating">
                            <xsl:with-param name="level" select="'function'" />
                        </xsl:apply-templates>
						<xsl:apply-templates select="sequences" mode="generating">
                            <xsl:with-param name="level" select="'function'" />
                        </xsl:apply-templates>
					</ol>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

    <xsl:template match="application" mode="algorithm">
        <xsl:choose>
            <xsl:when test="algorithm">
                <xsl:apply-templates select="algorithm" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="aspects or sequences">
                    <h4 onclick="toggleAlgorithm('{generate-id(.)}-application')">Algorithm</h4>
                    <ol id="{generate-id(.)}-application" state="collapsed" class="algorithm">
                        <xsl:apply-templates select="aspects" mode="generating">
                            <xsl:with-param name="level" select="'application'" />
                        </xsl:apply-templates>
                        <xsl:apply-templates select="sequences" mode="generating">
                            <xsl:with-param name="level" select="'application'" />
                        </xsl:apply-templates>
                    </ol>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

	<!-- generation from sequence -->
	
	<xsl:template match="sequences" mode="generating">
        <xsl:param name="level" required="yes" as="xs:string" />
		<xsl:apply-templates select="sequence" mode="generating">
            <xsl:with-param name="level" select="$level" />
        </xsl:apply-templates>
	</xsl:template>
	
	<xsl:template match="sequence" mode="generating">
        <xsl:param name="level" required="yes" as="xs:string" />
		<xsl:apply-templates select="application" mode="generating">
            <xsl:with-param name="level" select="$level" />
        </xsl:apply-templates>
	</xsl:template>
	
	<xsl:template match="application" mode="generating">
        <xsl:param name="level" required="yes" as="xs:string" />
		<xsl:choose>
			<xsl:when test="algorithm"><xsl:apply-templates select="algorithm" mode="content" /></xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="aspects" mode="generating">
                    <xsl:with-param name="level" select="$level" />
                </xsl:apply-templates>
				<xsl:apply-templates select="sequences" mode="generating">
                    <xsl:with-param name="level" select="$level" />
                </xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- generation from aspects -->
	
	<xsl:template match="aspects" mode="generating">
        <xsl:param name="level" required="yes" as="xs:string" />
		<xsl:variable name="countOfPrecedents" select="count(precedent)" as="xs:integer" />
		<xsl:variable name="countOfReactions" select="count(reaction)" as="xs:integer" />
		<xsl:variable name="countOfAspects" select="count(aspect)" as="xs:integer" />
		<xsl:variable name="count" select="$countOfPrecedents + $countOfReactions + $countOfAspects" as="xs:integer" />
		<xsl:variable name="isParallel" select="$count > 1" as="xs:boolean" />
		<xsl:choose>
			<xsl:when test="$isParallel">
				<li> do in parrallel
					<ol>
						<xsl:apply-templates mode="generating">
                            <xsl:with-param name="level" select="$level" />
							<xsl:with-param name="isParallel" select="$isParallel" />
						</xsl:apply-templates>
					</ol>
				</li>
				<li> end do in parallel </li>			
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="generating">
                    <xsl:with-param name="level" select="$level" />
					<xsl:with-param name="isParallel" select="$isParallel" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="precedent | reaction | aspect" mode="generating">
        <xsl:param name="level" required="yes" as="xs:string" />
		<xsl:param name="isParallel" required="yes" as="xs:boolean" />
		<xsl:choose>
			<xsl:when test="$isParallel">
				<li> do 
					<ol>
                        <xsl:apply-templates select="." mode="content">
                            <xsl:with-param name="level" select="$level" />
                        </xsl:apply-templates>
                    </ol>
				</li>
				<li> end do </li>	
			</xsl:when>
			<xsl:otherwise>
                <xsl:apply-templates select="." mode="content">
                    <xsl:with-param name="level" select="$level" />
                </xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- content -->
	
	<xsl:template match="precedent" mode="content">
        <xsl:param name="level" required="yes" as="xs:string" />
		<xsl:choose>
			<xsl:when test="action">
				<li>
					<span id="{generate-id(.)}{$level}-action"><a href="javascript:expandStep('{generate-id(.)}{$level}')"><xsl:apply-templates select="action" mode="content" /></a></span>
					<ol id="{generate-id(.)}{$level}-detailing" style="display:none">
						<li> if <xsl:apply-templates select="precondition" mode="content" /> then 
							<ol><xsl:apply-templates select="algorithm" mode="content" /></ol>
						</li>
						<li>end if</li>
					</ol>
				</li>			
			</xsl:when>
			<xsl:otherwise>
				<li> if <xsl:apply-templates select="precondition" mode="content" /> then 
					<ol><xsl:apply-templates select="algorithm" mode="content" /></ol>
				</li>
				<li>end if</li>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>
	
	<xsl:template match="reaction" mode="content">
        <xsl:param name="level" required="yes" as="xs:string" />
		<xsl:choose>
			<xsl:when test="action">
				<li>
					<span id="{generate-id(.)}{$level}-action"><a href="javascript:expandStep('{generate-id(.)}{$level}')"><xsl:apply-templates select="action" mode="content" /></a></span>
					<ol id="{generate-id(.)}{$level}-detailing" style="display:none">
						<li> if <xsl:apply-templates select="state" mode="content" /> then 
							<ol><xsl:apply-templates select="algorithm" mode="content" /></ol>
						</li>
						<li>end if</li>	
					</ol>
				</li>			
			</xsl:when>
			<xsl:otherwise>
				<li> if <xsl:apply-templates select="state" mode="content" /> then 
					<ol><xsl:apply-templates select="algorithm" mode="content" /></ol>
				</li>
				<li>end if</li>	
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="aspect" mode="content">
        <xsl:param name="level" required="yes" as="xs:string" />
		<xsl:choose>
			<xsl:when test="action">
				<li>
					<span id="{generate-id(.)}{$level}-action"><a href="javascript:expandStep('{generate-id(.)}{$level}')"><xsl:apply-templates select="action" mode="content" /></a></span>
					<ol id="{generate-id(.)}{$level}-detailing" style="display:none">
						<xsl:apply-templates select="algorithm" mode="content" />
					</ol>
				</li>			
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="algorithm" mode="content" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>