<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>
    <xsl:include href="common/htmlSubset.xslt" />
    <xsl:include href="common/testScenarios.xslt" />
    <xsl:include href="domain/testScenarios.xslt" />
    <xsl:include href="common/declarations/specification.xslt" />
    <xsl:include href="domain/specification.xslt" />
    <xsl:include href="domain/diagrams.xslt" />
    <xsl:include href="domain/packages.xslt" />
    <xsl:include href="domain/overview/actor.xslt" />
    <xsl:include href="domain/overview/entity.xslt" />
    <xsl:include href="domain/overview/overview.xslt" />
    <xsl:include href="domain/overview/package.xslt" />
    <xsl:include href="domain/overview/useCase.xslt" />
    <xsl:include href="domain/overview/worker.xslt" />
    <xsl:include href="domain/classes/classes.xslt" />
    <xsl:include href="domain/classes/actors.xslt" />
    <xsl:include href="common/attributes/relationships/associations.xslt" />
    <xsl:include href="common/attributes/relationships/participation.xslt" />
    <xsl:include href="common/attributes/relationships/communicateAssociations.xslt" />
    <xsl:include href="common/pseudocode/conditions.xslt" />
    <xsl:include href="common/pseudocode/algorithm.xslt" />
    <xsl:include href="common/pseudocode/cycles.xslt" />
    <xsl:include href="common/pseudocode/branches.xslt" />
    <xsl:include href="common/pseudocode/narrative.xslt" />
    <xsl:include href="domain/attributes.xslt" />
    <xsl:include href="domain/relationships/association.xslt" />
    <xsl:include href="domain/relationships/communicateAssociation.xslt" />
    <xsl:include href="domain/classes/operations.xslt" />
    <xsl:include href="domain/classes/workers.xslt" />
    <xsl:include href="domain/classes/entities.xslt" />
    <xsl:include href="domain/useCases/actors.xslt" />
    <xsl:include href="domain/useCases/alternatives.xslt" />
    <xsl:include href="domain/useCases/concretization.xslt" />
    <xsl:include href="domain/useCases/segments.xslt" />
    <xsl:include href="domain/useCases/useCases.xslt" />
    <xsl:include href="domain/useCases/scenario.xslt" />
    <xsl:include href="domain/useCases/artifacts.xslt" />
    <xsl:include href="domain/contract.xslt" />

    <xsl:param name="out" as="xs:string" select="'memory'" />
  
  <xsl:template match="domain">
<html>
    <head>
        <xsl:choose>
            <xsl:when test="@name"><title>Domain : <xsl:value-of select="@name" /></title></xsl:when>
            <xsl:otherwise><title>Domain</title></xsl:otherwise>
        </xsl:choose>
        <link rel="stylesheet" type="text/css" href=".blueprint/css/domain.css" />
        <xsl:for-each select="stylesheet-link">
            <link rel="stylesheet" type="text/css" href="{@href}" />
        </xsl:for-each>
        <script type="text/javascript" src=".blueprint/js/domain.js"></script>
    </head>
    <body onload="goToHash()">
        <xsl:choose>
          <xsl:when test="@name"><h1>Domain : <xsl:value-of select="@name" /></h1></xsl:when>
          <xsl:otherwise><h1>Domain</h1></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="description" />
        <xsl:apply-templates select="." mode="table_of_contents" />
        <xsl:apply-templates select="." mode="overview" />
        <xsl:apply-templates select="specification" />
        <xsl:apply-templates select="package" />
        <xsl:apply-templates select="diagram" />
        <xsl:apply-templates select="actor" />
        <xsl:apply-templates select="worker" />
        <xsl:apply-templates select="entity" />
        <xsl:apply-templates select="use-case" />
        <xsl:apply-templates select="test-scenarios" />
    </body>
</html>
  </xsl:template>

    <xsl:template match="domain" mode="table_of_contents">
        <xsl:if test="specification or package or diagram or actor or worker or entity or use-case">
            <h2>Table of contents</h2>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_specification" />
                <xsl:apply-templates select="." mode="table_of_contents_packages" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                <xsl:apply-templates select="." mode="table_of_contents_actors" />
                <xsl:apply-templates select="." mode="table_of_contents_workers" />
                <xsl:apply-templates select="." mode="table_of_contents_entities" />
                <xsl:apply-templates select="." mode="table_of_contents_use_cases" />
                <xsl:apply-templates select="." mode="table_of_contents_test_scenarios" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="domain/description">
        <h2>Description</h2>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

</xsl:stylesheet>
