<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- diagrams -->

    <xsl:template match="domain | package | use-case | segment" mode="table_of_contents_diagrams">
        <xsl:if test="diagram">
            <li>Diagrams
                <ul>
                    <xsl:for-each select="diagram">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="domain/diagram">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h2></xsl:otherwise>
        </xsl:choose>
        <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
    </xsl:template>

    <xsl:template match="diagram">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
    </xsl:template>

</xsl:stylesheet>