<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- iterations -->

    <xsl:template match="evolution | package | iteration" mode="table_of_contents_iterations">
        <xsl:if test="iteration">
            <li>Iterations
                <ul>
                    <xsl:for-each select="iteration">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')">
                                    <xsl:choose>
                                        <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
                                        <xsl:otherwise>iteration # <xsl:value-of select="position()" /></xsl:otherwise>
                                    </xsl:choose>
                                </a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">
                                    <xsl:choose>
                                        <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
                                        <xsl:otherwise>iteration # <xsl:value-of select="position()" /></xsl:otherwise>
                                    </xsl:choose>
                                </a></xsl:otherwise>
                            </xsl:choose>
                            <xsl:if test="iteration">
                                <ul>
                                    <xsl:apply-templates select="." mode="table_of_contents_iterations" />
                                </ul>
                            </xsl:if>
                            <xsl:if test="emotion">
                                <ul>
                                    <xsl:apply-templates select="." mode="table_of_contents_emotions" />
                                </ul>
                            </xsl:if>
                            <xsl:apply-templates select="." mode="table_of_contents_estimates" />
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="evolution/iteration">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">
                <xsl:choose>
                    <xsl:when test="@name">Iteration : <xsl:value-of select="@name" /></xsl:when>
                    <xsl:otherwise>Iteration # <xsl:value-of select="position()" /></xsl:otherwise>
                </xsl:choose>
            </h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">
                <xsl:choose>
                    <xsl:when test="@name">Iteration : <xsl:value-of select="@name" /></xsl:when>
                    <xsl:otherwise>Iteration # <xsl:value-of select="position()" /></xsl:otherwise>
                </xsl:choose>
            </h2></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="iteration">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">
                <xsl:choose>
                    <xsl:when test="@name">Iteration : <xsl:value-of select="@name" /></xsl:when>
                    <xsl:otherwise>Iteration # <xsl:value-of select="position()" /></xsl:otherwise>
                </xsl:choose>
            </h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">
                <xsl:choose>
                    <xsl:when test="@name">Iteration : <xsl:value-of select="@name" /></xsl:when>
                    <xsl:otherwise>Iteration # <xsl:value-of select="position()" /></xsl:otherwise>
                </xsl:choose>
            </h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="iteration" mode="content">
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(vision) and not(goal) and not(resource) and not(result) and not(iteration) and not(emotion)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="vision" />
                    <xsl:apply-templates select="." mode="goals" />
                    <xsl:apply-templates select="." mode="resources" />
                    <xsl:apply-templates select="." mode="results" />
                    <xsl:apply-templates select="iteration" />
                    <xsl:apply-templates select="emotion" />
                    <xsl:apply-templates select="." mode="estimates" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="iteration/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="iteration/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="iteration/vision">
        <h3>Vision</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="iteration" mode="goals">
        <xsl:if test="goal">
            <xsl:choose>
                <xsl:when test="count(goal) = 1"><h3>Goal</h3></xsl:when>
                <xsl:otherwise><h3>Goals</h3></xsl:otherwise>
            </xsl:choose>
            <ul class="goals">
                <xsl:apply-templates select="goal" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="iteration/goal">
        <xsl:choose>
            <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates /></li></xsl:when>
            <xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="iteration" mode="resources">
        <xsl:if test="resource">
            <xsl:choose>
                <xsl:when test="count(resource) = 1"><h3>Resource</h3></xsl:when>
                <xsl:otherwise><h3>Resources</h3></xsl:otherwise>
            </xsl:choose>
            <ul class="resources">
                <xsl:apply-templates select="resource" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="iteration/resource">
        <xsl:choose>
            <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates /></li></xsl:when>
            <xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="iteration" mode="results">
        <xsl:if test="result">
            <xsl:choose>
                <xsl:when test="count(result) = 1"><h3>Result</h3></xsl:when>
                <xsl:otherwise><h3>Results</h3></xsl:otherwise>
            </xsl:choose>
            <ul class="results">
                <xsl:apply-templates select="result" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="iteration/result">
        <xsl:choose>
            <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates /></li></xsl:when>
            <xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>