// Copyright (C) 2013 Oleh Radvanskyj

function goToHash() {
    expandAncestors(location.hash.substring(1));
    location.hash = location.hash;
}

function expandAncestors(id) {
	var element = document.getElementById(id);
    if (element) {
        expandParent(element);
        expandNextSibling(element);
    }
}

function expandParent(element) {
	var parent = element.parentNode;
	if (parent.nodeName == 'BODY') return;
	if ((parent.nodeName == 'DIV' || parent.nodeName == 'OL') && parent.style.display == 'none') {
		parent.style.display = 'block';
	}
	expandParent(parent);
}

function expandNextSibling(element) {
    if (element.nodeName != 'H1' && element.nodeName != 'H2' && element.nodeName != 'H3' && element.nodeName != 'H4' && element.nodeName != 'SPAN') return;
	if (element.nodeName == 'BODY') return;
	var parent = element.parentNode;
	var node;
    for (var i = 0; i < parent.childNodes.length; i++) {
        if (parent.childNodes.item(i) == element) {
            node = parent.childNodes.item(i + 1);
            break;
        }
    }
    if (node && node.style.display == 'none') {
        node.style.display = 'block';
    }
}
