<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- artifacts -->

    <xsl:template match="model/use-case/artifacts">
        <h3 onclick="toggleTag('{generate-id(.)}')">Artifacts</h3>
        <ul id="{generate-id(.)}" class="artifacts"><xsl:apply-templates /></ul>
    </xsl:template>

    <xsl:template match="artifacts">
        <h4 onclick="toggleTag('{generate-id(.)}')">Artifacts</h4>
        <ul id="{generate-id(.)}" class="artifacts"><xsl:apply-templates /></ul>
    </xsl:template>

    <xsl:template match="artifact">
        <xsl:choose>
            <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates select="." mode="content" /></li></xsl:when>
            <xsl:otherwise><li><xsl:apply-templates select="." mode="content" /></li></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="artifact" mode="content">
        <xsl:choose>
            <xsl:when test="artifact">
                <a class="artifact" onclick="toggleTag('{generate-id(.)}')">
                    <xsl:value-of select="@stereotype" /><xsl:value-of select="' '" /><xsl:value-of select="@name" />
                    <xsl:if test="@description"> - <xsl:value-of select="@description" /></xsl:if>
                </a>
                <ul id="{generate-id(.)}" class="artifacts"><xsl:apply-templates /></ul>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="@stereotype" /><xsl:value-of select="' '" /><xsl:value-of select="@name" />
                <xsl:if test="@description"> - <xsl:value-of select="@description" /></xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
