<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- declaration -->

    <xsl:template match="declaration" mode="table_of_contents_declaration">
        <li>Declaration
            <xsl:if test="specification or concretization or communicate-associations or scenario or alternarive or diagrams or gui or test-scenarios">
                <ul>
                    <xsl:apply-templates select="." mode="table_of_contents_specification" />
                    <xsl:apply-templates select="." mode="table_of_contents_concretization" />
                    <xsl:apply-templates select="." mode="table_of_contents_communicate_associations" />
                    <xsl:apply-templates select="." mode="table_of_contents_scenario" />
                    <xsl:apply-templates select="." mode="table_of_contents_alternatives" />
                    <xsl:apply-templates select="." mode="table_of_contents_gui" />
                    <xsl:apply-templates select="." mode="table_of_contents_test_scenarios" />
                    <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="use-case | segment" mode="declaration">
        <xsl:apply-templates select="declaration/description" />
        <xsl:apply-templates select="." mode="overview" />
        <xsl:apply-templates select="declaration/specification" />
        <xsl:apply-templates select="declaration/concretization" />
        <xsl:apply-templates select="declaration/communicate-associations" />
        <xsl:apply-templates select="declaration/scenario" />
        <xsl:apply-templates select="declaration/alternative" />
        <xsl:apply-templates select="declaration/gui" />
        <xsl:apply-templates select="declaration/test-scenarios" />
        <xsl:apply-templates select="declaration/diagrams" />
    </xsl:template>

    <xsl:template match="model/use-case/declaration/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates/></div>
    </xsl:template>

    <xsl:template match="package/use-case/declaration/description | use-case/use-case/declaration/description | segment/use-case/declaration/description | use-case/segment/declaration/description | segment/segment/declaration/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

</xsl:stylesheet>