<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- realization -->

    <xsl:template match="realization" mode="table_of_contents_realization">
        <li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Realization</a>
            <xsl:if test="specification or diagrams or types or capsules or classes or functions or threads or test-procedures">
                <ul>
                    <xsl:apply-templates select="." mode="table_of_contents_overview" />
                    <xsl:apply-templates select="." mode="table_of_contents_specification" />
                    <xsl:apply-templates select="." mode="table_of_contents_capsules" />
                    <xsl:apply-templates select="." mode="table_of_contents_interfaces" />
                    <xsl:apply-templates select="." mode="table_of_contents_classes" />
                    <xsl:apply-templates select="." mode="table_of_contents_types" />
                    <xsl:apply-templates select="." mode="table_of_contents_functions" />
                    <xsl:apply-templates select="." mode="table_of_contents_threads" />
                    <xsl:apply-templates select="." mode="table_of_contents_test_procedures" />
                    <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="model/use-case/realization">
        <h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Realization</h3>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="realization">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Realization</h4>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="realization" mode="content">
        <xsl:apply-templates select="description" />
        <xsl:apply-templates select="." mode="overview" />
        <xsl:apply-templates select="specification" />
        <xsl:apply-templates select="capsules" />
        <xsl:apply-templates select="classes" />
        <xsl:apply-templates select="types" />
        <xsl:apply-templates select="functions" />
        <xsl:apply-templates select="threads" />
        <xsl:apply-templates select="test-procedures" />
        <xsl:apply-templates select="artifacts" />
        <xsl:apply-templates select="diagrams" />
    </xsl:template>

    <xsl:template match="realization/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates/></div>
    </xsl:template>

</xsl:stylesheet>