<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
 	<!-- components -->

    <xsl:template match="component">
        <xsl:variable name="id" select="generate-id(.)" />
        <xsl:variable name="reference" select="@reference" />
        <xsl:for-each select="//implementation/classes/interface[@id = $reference]">
            <h4 id="{$id}-header" onclick="toggleTag('{$id}')"><xsl:apply-templates select="." mode="interface_header" /></h4>
            <div id="{$id}" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:for-each>
        <xsl:for-each select="//package/classes/interface[@id = $reference]">
            <h4 id="{$id}-header" onclick="toggleTag('{$id}')"><xsl:apply-templates select="." mode="interface_header" /></h4>
            <div id="{$id}" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:for-each>
        <xsl:for-each select="//capsule/classes/interface[@id = $reference]">
            <h4 id="{$id}-header" onclick="toggleTag('{$id}')"><xsl:apply-templates select="." mode="interface_header" /></h4>
            <div id="{$id}" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:for-each>
        <xsl:for-each select="//implementation/classes/class[@id = $reference]">
            <h4 id="{$id}-header" onclick="toggleTag('{$id}')"><xsl:apply-templates select="." mode="class_header" /></h4>
            <div id="{$id}" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:for-each>
        <xsl:for-each select="//package/classes/class[@id = $reference]">
            <h4 id="{$id}-header" onclick="toggleTag('{$id}')"><xsl:apply-templates select="." mode="class_header" /></h4>
            <div id="{$id}" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:for-each>
        <xsl:for-each select="//capsule/classes/class[@id = $reference]">
            <h4 id="{$id}-header" onclick="toggleTag('{$id}')"><xsl:apply-templates select="." mode="class_header" /></h4>
            <div id="{$id}" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:for-each>
    </xsl:template>

    <!-- component package -->

    <xsl:template match="component-package">
        <xsl:variable name="reference" select="@reference" />
        <xsl:variable name="id" select="generate-id(.)" />
        <xsl:apply-templates select="//package[@id = $reference]" mode="component_package">
            <xsl:with-param name="id" select="$id" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="package" mode="component_package">
        <xsl:param name="id" required="yes" />
        <h4 id="{$id}{generate-id(.)}-header-component-package" onclick="toggleTag('{$id}{generate-id(.)}-component-package')">Package : <xsl:value-of select="@name" /></h4>
        <div id="{$id}{generate-id(.)}-component-package" style="display:none" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents_component_package">
                <xsl:with-param name="id" select="$id" />
            </xsl:apply-templates>
            <xsl:apply-templates select="." mode="overview_component_package">
                <xsl:with-param name="id" select="$id" />
            </xsl:apply-templates>
            <xsl:apply-templates select="specification" mode="component_package">
                <xsl:with-param name="id" select="$id" />
            </xsl:apply-templates>
            <xsl:apply-templates select="packages/package" mode="component_package">
                <xsl:with-param name="id" select="$id" />
            </xsl:apply-templates>
            <xsl:apply-templates select="diagrams/diagram" mode="component_package">
                <xsl:with-param name="id" select="$id" />
            </xsl:apply-templates>
            <xsl:apply-templates select="classes" mode="component_package">
                <xsl:with-param name="id" select="$id" />
            </xsl:apply-templates>
        </div>
    </xsl:template>

    <xsl:template match="package" mode="table_of_contents_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:if test="specification or packages or diagrams or classes">
            <h4>Table of contents</h4>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_overview_component_package">
                    <xsl:with-param name="id" select="$id" />
                </xsl:apply-templates>
                <xsl:apply-templates select="." mode="table_of_contents_specification_component_package">
                    <xsl:with-param name="id" select="$id" />
                </xsl:apply-templates>
                <xsl:apply-templates select="." mode="table_of_contents_packages_component_package">
                    <xsl:with-param name="id" select="$id" />
                </xsl:apply-templates>
                <xsl:apply-templates select="." mode="table_of_contents_diagrams_component_package">
                    <xsl:with-param name="id" select="$id" />
                </xsl:apply-templates>
                <xsl:apply-templates select="." mode="table_of_contents_components_component_package">
                    <xsl:with-param name="id" select="$id" />
                </xsl:apply-templates>
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="package" mode="table_of_contents_specification_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:if test="specification">
            <li><a href="#{$id}{generate-id(specification)}-header-component-package" onclick="expandAncestors('{$id}{generate-id(specification)}-header-component-package')">Specification</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="specification" mode="component_package">
        <xsl:param name="id" required="yes" />
        <h4 id="{$id}{generate-id(.)}-header-component-package" onclick="toggleSpecification('{$id}{generate-id(.)}-component-package')">Specification</h4>
        <ol id="{$id}{generate-id(.)}-component-package" state="hidden" class="specification" style="display:none">
            <xsl:apply-templates />
        </ol>
    </xsl:template>

    <xsl:template match="package" mode="table_of_contents_packages_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:if test="packages">
            <li>Packages
                <ul>
                    <xsl:for-each select="packages/package">
                        <li><a href="#{$id}{generate-id(.)}-header-component-package" onclick="expandAncestors('{$id}{generate-id(.)}-header-component-package')"><xsl:value-of select="@name" /></a></li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="package" mode="table_of_contents_diagrams_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:if test="diagrams">
            <li>Diagrams
                <ul>
                    <xsl:for-each select="diagrams/diagram">
                        <li><a href="#{$id}{generate-id(.)}-header-component-package" onclick="expandAncestors('{$id}{generate-id(.)}-header-component-package')"><xsl:value-of select="@name" /></a></li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="package/diagrams/diagram" mode="component_package">
        <xsl:param name="id" required="yes" />
        <h4 id="{$id}{generate-id(.)}-header-component-package" onclick="toggleTag('{$id}{generate-id(.)}-component-package')">Diagram : <xsl:value-of select="@name" /></h4>
        <img id="{$id}{generate-id(.)}-component-package" alt="{@name}" src="{@image}" />
    </xsl:template>

    <xsl:template match="package/classes" mode="component_package">
        <xsl:param name="id" required="yes" />
        <xsl:apply-templates mode="component_package">
            <xsl:with-param name="id" select="$id" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="package/classes/interface" mode="component_package">
        <xsl:param name="id" required="yes" />
        <h4 id="{$id}{generate-id(.)}-header-component-package" onclick="toggleTag('{$id}{generate-id(.)}-component-package')"><xsl:apply-templates select="." mode="interface_header" /></h4>
        <div id="{$id}{generate-id(.)}-component-package" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="overview_content" />
        </div>
    </xsl:template>

    <xsl:template match="package/classes/class" mode="component_package">
        <xsl:param name="id" required="yes" />
        <h4 id="{$id}{generate-id(.)}-header-component-package" onclick="toggleTag('{$id}{generate-id(.)}-component-package')"><xsl:apply-templates select="." mode="class_header" /></h4>
        <div id="{$id}{generate-id(.)}-component-package" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="overview_content" />
        </div>
    </xsl:template>

    <xsl:template match="package" mode="table_of_contents_components_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:if test="classes">
            <li>Components
                <ul>
                    <xsl:apply-templates select="classes" mode="table_of_contents_components_component_package">
                        <xsl:with-param name="id" select="$id" />
                    </xsl:apply-templates>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="package/classes" mode="table_of_contents_components_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:apply-templates mode="table_of_contents_components_component_package">
            <xsl:with-param name="id" select="$id" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="package/classes/interface | package/classes/class" mode="table_of_contents_components_component_package">
        <xsl:param name="id" required="yes" />
        <li><a href="#{$id}{generate-id(.)}-header-component-package" onclick="expandAncestors('{$id}{generate-id(.)}-header-component-package')"><xsl:value-of select="@name" /></a></li>
    </xsl:template>

</xsl:stylesheet>