<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>
    <xsl:include href="common/htmlSubset.xslt" />
    <xsl:include href="process/diagrams.xslt" />
    <xsl:include href="process/packages.xslt" />
    <xsl:include href="process/overview/artifact.xslt" />
    <xsl:include href="process/overview/group.xslt" />
    <xsl:include href="process/overview/overview.xslt" />
    <xsl:include href="process/overview/package.xslt" />
    <xsl:include href="process/overview/worker.xslt" />
    <xsl:include href="process/overview/workflow.xslt" />
    <xsl:include href="process/testStrategies.xslt" />
    <xsl:include href="process/activities.xslt" />
    <xsl:include href="process/artifacts.xslt" />
    <xsl:include href="process/workers.xslt" />
    <xsl:include href="process/groups.xslt" />
    <xsl:include href="process/workflows.xslt" />

    <xsl:param name="out" as="xs:string" select="'memory'" />
  
  <xsl:template match="process">
<html>
    <head>
        <xsl:choose>
            <xsl:when test="@name"><title>Process : <xsl:value-of select="@name" /></title></xsl:when>
            <xsl:otherwise><title>Process</title></xsl:otherwise>
        </xsl:choose>
        <link rel="stylesheet" type="text/css" href=".blueprint/css/process.css" />
        <xsl:for-each select="stylesheet-link">
            <link rel="stylesheet" type="text/css" href="{@href}" />
        </xsl:for-each>
        <script type="text/javascript" src=".blueprint/js/process.js"></script>
    </head>
    <body onload="goToHash()">
        <xsl:choose>
          <xsl:when test="@name"><h1>Process : <xsl:value-of select="@name" /></h1></xsl:when>
          <xsl:otherwise><h1>Process</h1></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="description" />
        <xsl:apply-templates select="." mode="table_of_contents" />
        <xsl:apply-templates select="." mode="overview" />
        <xsl:apply-templates select="package" />
        <xsl:apply-templates select="diagram" />
        <xsl:apply-templates select="group" />
        <xsl:apply-templates select="worker" />
        <xsl:apply-templates select="artifact" />
        <xsl:apply-templates select="workflow" />
        <xsl:apply-templates select="test-strategy" />
    </body>
</html>
  </xsl:template>

    <xsl:template match="process" mode="table_of_contents">
        <xsl:if test="package or diagram or group or artifact or worker or workflow or test-strategy">
            <h2>Table of contents</h2>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_packages" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                <xsl:apply-templates select="." mode="table_of_contents_groups" />
                <xsl:apply-templates select="." mode="table_of_contents_workers" />
                <xsl:apply-templates select="." mode="table_of_contents_artifacts" />
                <xsl:apply-templates select="." mode="table_of_contents_workflows" />
                <xsl:apply-templates select="." mode="table_of_contents_test_strategies" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="process/description">
        <h2>Description</h2>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

</xsl:stylesheet>
