<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- activities -->

    <xsl:template match="activity">
        <xsl:choose>
            <xsl:when test="parent::using or parent::activity or parent::worker or parent::workflow">
                <li>
                    <xsl:apply-templates select="." mode="header" />
                    <xsl:apply-templates select="." mode="content" />
                </li>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="header" />
                <xsl:apply-templates select="." mode="content" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="activity" mode="header">
        <xsl:if test="@activity">
            <xsl:choose>
                <xsl:when test="@reference-to-workflow"><a href="#{@reference-to-workflow}" onclick="expandAncestors('{@reference-to-workflow}')"><xsl:value-of select="@activity" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@activity" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="@goal">
            The goal is <xsl:value-of select="@goal" /><xsl:value-of select="'.'" />
        </xsl:if>
        <xsl:if test="@result">
            The result is
            <xsl:choose>
                <xsl:when test="@reference-to-result"><a href="#{@reference-to-result}" onclick="expandAncestors('{@reference-to-result}')"><xsl:value-of select="@result" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@result" /></xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="'.'" />
        </xsl:if>
        <xsl:if test="@description">
            The description is <xsl:value-of select="@description" /><xsl:value-of select="'.'" />
        </xsl:if>
    </xsl:template>

    <xsl:template match="activity" mode="content">
        <xsl:choose>
            <xsl:when test="child::activity"> The activity includes the next steps : <ul class="activities"><xsl:apply-templates /></ul></xsl:when>
            <xsl:otherwise><xsl:apply-templates /></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>