<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- packages -->

    <xsl:template match="process | package" mode="table_of_contents_packages">
        <xsl:if test="package">
            <li>Packages
                <ul>
                    <xsl:for-each select="package">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="process/package">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h2></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="package" />
            <xsl:apply-templates select="diagram" />
            <xsl:apply-templates select="group" />
            <xsl:apply-templates select="worker" />
            <xsl:apply-templates select="artifact" />
            <xsl:apply-templates select="workflow" />
            <xsl:apply-templates select="test-strategy" />
        </div>
    </xsl:template>


    <xsl:template match="package/package">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="package" />
            <xsl:apply-templates select="diagram" />
            <xsl:apply-templates select="group" />
            <xsl:apply-templates select="worker" />
            <xsl:apply-templates select="artifact" />
            <xsl:apply-templates select="workflow" />
            <xsl:apply-templates select="test-strategy" />
        </div>
    </xsl:template>

    <xsl:template match="package/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="package" mode="table_of_contents">
        <xsl:if test="package or diagram or group or worker or artifact or test-strategy or workflow">
            <h3>Table of contents</h3>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_packages" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                <xsl:apply-templates select="." mode="table_of_contents_groups" />
                <xsl:apply-templates select="." mode="table_of_contents_workers" />
                <xsl:apply-templates select="." mode="table_of_contents_artifacts" />
                <xsl:apply-templates select="." mode="table_of_contents_workflows" />
                <xsl:apply-templates select="." mode="table_of_contents_test_strategies" />
            </ul>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>