<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- workflows -->

    <xsl:template match="process | package" mode="table_of_contents_workflows">
        <xsl:if test="workflow">
            <li>Workflows
                <ul>
                    <xsl:for-each select="workflow">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="process/workflow">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Workflow : <xsl:value-of select="@name" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Workflow : <xsl:value-of select="@name" /></h2></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="workflow">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Workflow : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Workflow : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="workflow" mode="content">
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(purpose) and not( workflow) and not(diagram) and not(participant) and not(input) and not(output) and not(artifact) and not(activity) and not(result)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="purpose" />
                    <xsl:apply-templates select="workflow" />
                    <xsl:apply-templates select="diagram" />
                    <xsl:apply-templates select="." mode="participants" />
                    <xsl:apply-templates select="." mode="input" />
                    <xsl:apply-templates select="." mode="output" />
                    <xsl:apply-templates select="artifact" />
                    <xsl:apply-templates select="." mode="process" />
                    <xsl:apply-templates select="." mode="results" />
                </xsl:otherwise>
            </xsl:choose>
        </div>

    </xsl:template>

    <xsl:template match="workflow/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="workflow/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="workflow/purpose">
        <h3>Purpose</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="workflow" mode="participants">
        <xsl:if test="participant">
            <xsl:choose>
                <xsl:when test="count(participant) = 1"><h3>Participant</h3></xsl:when>
                <xsl:otherwise><h3>Participants</h3></xsl:otherwise>
            </xsl:choose>
            <ul class="participants">
                <xsl:apply-templates select="participant" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workflow/participant">
        <li>
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@position" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@position" /></xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="workflow" mode="input">
        <xsl:if test="input">
            <xsl:choose>
                <xsl:when test="count(input) = 1"><h3>Input artifact</h3></xsl:when>
                <xsl:otherwise><h3>Input artifacts</h3></xsl:otherwise>
            </xsl:choose>
            <ul class="artifacts">
                <xsl:apply-templates select="input" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workflow" mode="output">
        <xsl:if test="output">
            <xsl:choose>
                <xsl:when test="count(output) = 1"><h3>Output artifact</h3></xsl:when>
                <xsl:otherwise><h3>Output artifacts</h3></xsl:otherwise>
            </xsl:choose>
            <ul class="artifacts">
                <xsl:apply-templates select="output" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workflow/input | workflow/output">
        <li>
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@artifact" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@artifact" /></xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="workflow" mode="process">
        <xsl:if test="activity">
            <h3>Process</h3>
            <ul class="process">
                <xsl:apply-templates select="activity" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workflow" mode="results">
        <xsl:if test="result">
            <xsl:choose>
                <xsl:when test="count(result) = 1"><h3>Result</h3></xsl:when>
                <xsl:otherwise><h3>Results</h3></xsl:otherwise>
            </xsl:choose>
            <ul class="results">
                <xsl:apply-templates select="result" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workflow/result">
        <xsl:choose>
            <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates /></li></xsl:when>
            <xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>