<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- co-owners -->

    <xsl:template match="co-owners" mode="table_of_contents">
        <li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Co-owners</a>
            <xsl:if test="group">
                <ul>
                    <xsl:apply-templates select="group" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="group" mode="table_of_contents">
        <li>
            <xsl:choose>
                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
            </xsl:choose>
            <xsl:if test="group">
                <ul>
                    <xsl:apply-templates select="group" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="co-owners">
        <h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Co-owners</h2>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="group" />
            <xsl:apply-templates select="." mode="table" />
            <xsl:apply-templates select="co-owner" />
        </div>
    </xsl:template>

    <xsl:template match="group">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Group : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Group : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="group" />
            <xsl:apply-templates select="." mode="table" />
            <xsl:apply-templates select="co-owner" />
        </div>
    </xsl:template>

    <xsl:template match="co-owners | group" mode="table">
        <xsl:if test="co-owner">
            <table class="co-owners">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Role</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:for-each select="co-owner">
                        <tr>
                            <td><xsl:value-of select="position()" /></td>
                            <td><xsl:apply-templates select="role" mode="table" /></td>
                            <td><xsl:apply-templates select="description" mode="table" /></td>
                        </tr>
                    </xsl:for-each>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="co-owner/role" mode="table">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="co-owner/description" mode="table">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>