<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- glossary -->

    <xsl:template match="glossary" mode="table_of_contents">
        <li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Glossary</a></li>
    </xsl:template>

    <xsl:template match="glossary">
        <h2 id="{generate-id}-header">Glossary</h2>
        <table cellspacing="0" border="1" class="glossary">
            <tr>
                <th>Word</th>
                <th>Description</th>
                <xsl:if test="glossary-term/synonyms">
                    <th>Synonyms</th>
                </xsl:if>
                <xsl:if test="glossary-term/homonyms">
                    <th>Homonyms</th>
                </xsl:if>
                <xsl:if test="glossary-term/traced-from-functional-requirement or glossary-term/traced-from-non-functional-requirement or glossary-term/traced-from-issue">
                    <th>Tracing</th>
                </xsl:if>
            </tr>
            <xsl:apply-templates select="glossary-term"/>
        </table>
    </xsl:template>

    <!-- term -->

    <xsl:template match="glossary-term">
        <xsl:choose>
            <xsl:when test="@id"><tr id="{@id}"><xsl:apply-templates select="." mode="content" /></tr></xsl:when>
            <xsl:otherwise><tr><xsl:apply-templates select="." mode="content" /></tr></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="glossary-term" mode="content">
        <td><xsl:value-of select="word"/></td>
        <td><xsl:apply-templates select="description"/></td>
        <xsl:apply-templates select="." mode="synonyms" />
        <xsl:apply-templates select="." mode="homonyms" />
        <xsl:apply-templates select="." mode="tracing" />
    </xsl:template>

    <xsl:template match="glossary-term/description">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="glossary-term" mode="synonyms">
        <xsl:if test="../glossary-term/synonyms">
            <td>
                <xsl:if test="synonyms">
                    <ul class="synonyms">
                        <xsl:for-each select="synonyms/synonym">
                            <li><xsl:value-of select="."/></li>
                        </xsl:for-each>
                    </ul>
                </xsl:if>
            </td>
        </xsl:if>
    </xsl:template>

    <xsl:template match="glossary-term" mode="homonyms">
        <xsl:if test="../glossary-term/homonyms">
            <td>
                <xsl:if test="homonyms">
                    <ul class="homonyms">
                        <xsl:for-each select="homonyms/homonym">
                            <li><xsl:value-of select="."/></li>
                        </xsl:for-each>
                    </ul>
                </xsl:if>
            </td>
        </xsl:if>
    </xsl:template>

    <xsl:template match="glossary-term" mode="tracing">
        <xsl:if test="../glossary-term/traced-from-functional-requirement or ../glossary-term/traced-from-non-functional-requirement or ../glossary-term/traced-from-issue">
            <td>
                <xsl:if test="traced-from-functional-requirement or traced-from-non-functional-requirement or traced-from-issue">
                    <ol class="tracing-table">
                        <xsl:apply-templates select="traced-from-functional-requirement" />
                        <xsl:apply-templates select="traced-from-non-functional-requirement" />
                        <xsl:apply-templates select="traced-from-issue" />
                    </ol>
                </xsl:if>
            </td>
        </xsl:if>
    </xsl:template>

    <xsl:template match="glossary-term/traced-from-functional-requirement">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="glossary-term/traced-from-non-functional-requirement">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="glossary-term/traced-from-issue">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

</xsl:stylesheet>