<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- risk -->

    <xsl:template match="risk">
        <xsl:choose>
            <xsl:when test="@id">
                <li id="{@id}">
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="attributes"/>
                    <xsl:apply-templates select="." mode="tracing"/>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <li id="{generate-id(.)}">
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="attributes"/>
                    <xsl:apply-templates select="." mode="tracing"/>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="risk/description">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="risk" mode="attributes">
        <xsl:if test="@probability or @status or @score or @effort or @strategy or @impact">
            <table class="attributes">
                <thead>
                    <tr>
                        <xsl:if test="@status"><th>status</th></xsl:if>
                        <xsl:if test="@probability"><th>probability</th></xsl:if>
                        <xsl:if test="@impact"><th>impact</th></xsl:if>
                        <xsl:choose>
                            <xsl:when test="@score"><th>score</th></xsl:when>
                            <xsl:when test="@probability and @impact"><th>score</th></xsl:when>
                        </xsl:choose>
                        <xsl:if test="@strategy"><th>strategy</th></xsl:if>
                        <xsl:if test="@effort"><th>effort</th></xsl:if>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <xsl:if test="@status"><td><xsl:value-of select="@status" /></td></xsl:if>
                        <xsl:if test="@probability">
                            <xsl:choose>
                                <xsl:when test="@probability = 'very_likely'">
                                    <td>very likely</td>
                                </xsl:when>
                                <xsl:when test="@probability = 'probably'">
                                    <td>probably</td>
                                </xsl:when>
                                <xsl:when test="@probability = 'may_occur'">
                                    <td>may occur</td>
                                </xsl:when>
                                <xsl:when test="@probability = 'unlikely'">
                                    <td>unlikely</td>
                                </xsl:when>
                                <xsl:when test="@probability = 'very_unlikely'">
                                    <td>very unlikely</td>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:if>
                        <xsl:if test="@impact"><td><xsl:value-of select="@impact" /></td></xsl:if>
                        <xsl:choose>
                            <xsl:when test="@score"><td><xsl:value-of select="@score" /></td></xsl:when>
                            <xsl:when test="@probability and @impact">
                                <td id="{generate-id(.)}-score"></td>
                                <script type="text/javascript">
                                    var probability = 0;
                                    <xsl:choose>
                                        <xsl:when test="@probability = 'very_likely'">
                                            probability = 5;
                                        </xsl:when>
                                        <xsl:when test="@probability = 'probably'">
                                            probability = 4;
                                        </xsl:when>
                                        <xsl:when test="@probability = 'may_occur'">
                                            probability = 3;
                                        </xsl:when>
                                        <xsl:when test="@probability = 'unlikely'">
                                            probability = 2;
                                        </xsl:when>
                                        <xsl:when test="@probability = 'very_unlikely'">
                                            probability = 1;
                                        </xsl:when>
                                    </xsl:choose>
                                    var impact = 0;
                                    <xsl:choose>
                                        <xsl:when test="@impact = 'critical'">
                                            impact = 10;
                                        </xsl:when>
                                        <xsl:when test="@impact = 'serious'">
                                            impact = 8;
                                        </xsl:when>
                                        <xsl:when test="@impact = 'moderate'">
                                            impact = 5;
                                        </xsl:when>
                                        <xsl:when test="@impact = 'minor'">
                                            impact = 3;
                                        </xsl:when>
                                        <xsl:when test="@impact = 'negligible'">
                                            impact = 1;
                                        </xsl:when>
                                    </xsl:choose>
                                    var score = probability * impact;
                                    if (score &gt; 0) {
                                    var id = '<xsl:value-of select="generate-id(.)" />-score';
                                    var text = 'text';
                                    if (score &lt; 20) text = 'low';
                                    if (score &gt;= 20 &amp;&amp; score &lt; 40) text = 'medium';
                                    if (score &gt;= 40 &amp;&amp; score &lt;= 50) text = 'high';
                                    var node = document.getElementById(id);
                                    var textNode = document.createTextNode(text);
                                    node.appendChild(textNode);
                                    }
                                </script>
                            </xsl:when>
                        </xsl:choose>
                        <xsl:if test="@strategy"><td><xsl:value-of select="@strategy" /></td></xsl:if>
                        <xsl:if test="@effort"><td><xsl:value-of select="@effort" /></td></xsl:if>
                    </tr>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="risk" mode="tracing">
        <xsl:if test="traced-from-functional-requirement or traced-from-non-functional-requirement or traced-from-issue or traced-to-task or traced-to-risk">
            <h3 onclick="toggleTag('{generate-id(.)}-tracing')">Tracing</h3>
            <ol id="{generate-id(.)}-tracing" class="tracing">
                <xsl:apply-templates select="traced-from-functional-requirement" />
                <xsl:apply-templates select="traced-from-non-functional-requirement" />
                <xsl:apply-templates select="traced-from-issue" />
                <xsl:apply-templates select="traced-to-task" />
                <xsl:apply-templates select="traced-to-risk" />
            </ol>
        </xsl:if>
    </xsl:template>

    <xsl:template match="risk/traced-from-functional-requirement">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="risk/traced-from-non-functional-requirement">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from non functional requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="risk/traced-from-issue">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from issue
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="risk/traced-to-task">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to task
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to task
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to task
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="risk/traced-to-risk">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to risk
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

</xsl:stylesheet>