<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
  <xsl:output method="html" encoding="UTF-8" indent="yes"/>
    <xsl:include href="common/htmlSubset.xslt" />
    <xsl:include href="common/researches.xslt" />
    <xsl:include href="common/modules.xslt" />
    <xsl:include href="common/testPlan.xslt" />
    <xsl:include href="common/packages.xslt" />
    <xsl:include href="common/diagrams.xslt" />
    <xsl:include href="common/gui.xslt" />
    <xsl:include href="common/testScenarios.xslt" />
    <xsl:include href="common/specification.xslt" />
    <xsl:include href="common/classes/types.xslt" />
    <xsl:include href="common/classes/capsule.xslt" />
    <xsl:include href="common/classes/classes.xslt" />
    <xsl:include href="common/classes/port.xslt" />
    <xsl:include href="common/classes/realizes.xslt" />
    <xsl:include href="common/functions/function.xslt" />
    <xsl:include href="common/functions/testProcedure.xslt" />
    <xsl:include href="common/functions/thread.xslt" />
    <xsl:include href="common/attributes/sharedPools/sharedPools.xslt" />
    <xsl:include href="common/attributes/sharedPools/sharedTypes.xslt" />
    <xsl:include href="common/attributes/sharedPools/sharedData.xslt" />
    <xsl:include href="common/attributes/sharedPools/sharedFunctions.xslt" />
    <xsl:include href="common/attributes/relationships/associations.xslt" />
    <xsl:include href="common/attributes/data.xslt" />
    <xsl:include href="common/attributes/classData.xslt" />
    <xsl:include href="common/attributes/types.xslt" />
    <xsl:include href="common/attributes/parametrizedTypes.xslt" />
    <xsl:include href="common/attributes/contract.xslt" />
    <xsl:include href="common/pseudocode/aspects.xslt" />
    <xsl:include href="common/pseudocode/conditions.xslt" />
    <xsl:include href="common/pseudocode/sequence.xslt" />
    <xsl:include href="common/pseudocode/generation.xslt" />    
    <xsl:include href="common/pseudocode/algorithm.xslt" />
    <xsl:include href="common/pseudocode/cycles.xslt" />
    <xsl:include href="common/pseudocode/branches.xslt" />
    <xsl:include href="common/declarations/specification.xslt" />
    <xsl:include href="common/declarations/annotations.xslt" />
    <xsl:include href="common/declarations/specialFunctions.xslt" />
    <xsl:include href="common/declarations/header.xslt" />
    <xsl:include href="common/declarations/functionsHeader.xslt" />
    <xsl:include href="common/declarations/classesHeader.xslt" />
    <xsl:include href="common/declarations/protocol.xslt" />
    <xsl:include href="common/declarations/innerClasses.xslt" />
    <xsl:include href="common/declarations/innerFunctions.xslt" />
    <xsl:include href="common/overview/package/class.xslt" />
    <xsl:include href="common/overview/package/interface.xslt" />
    <xsl:include href="common/overview/package/classes.xslt" />
    <xsl:include href="common/overview/package/capsule.xslt" />
    <xsl:include href="common/overview/package/crc.xslt" />
    <xsl:include href="common/overview/package/function.xslt" />
    <xsl:include href="common/overview/package/thread.xslt" />
    <xsl:include href="common/overview/package/testProcedure.xslt" />
    <xsl:include href="common/overview/package/package.xslt" />
    <xsl:include href="common/overview/class/class.xslt" />
    <xsl:include href="common/overview/class/classes.xslt" />
    <xsl:include href="common/overview/class/enumeration.xslt" />
    <xsl:include href="common/overview/class/testProcedure.xslt" />
    <xsl:include href="common/overview/class/interface.xslt" />
    <xsl:include href="common/overview/class/capsule.xslt" />
    <xsl:include href="common/overview/class/attributes.xslt" />
    <xsl:include href="common/overview/class/operations.xslt" />
    <xsl:include href="research/overview.xslt" />
    <xsl:include href="research/packages.xslt" />
  
  <xsl:param name="out" as="xs:string" select="'memory'" />
  
  <xsl:template match="research">
<html>
  <head>
    <title>Research : <xsl:value-of select="@name" /></title>
    <link rel="stylesheet" type="text/css" href=".blueprint/css/research.css" />
    <xsl:for-each select="stylesheet-link">
		<link rel="stylesheet" type="text/css" href="{@href}" />
    </xsl:for-each>
    <script type="text/javascript" src=".blueprint/js/research.js"></script>
  </head>
  <body onload="goToHash()">
    <h1>Research : <xsl:value-of select="@name" /></h1>
    <xsl:apply-templates select="problem" />
    <xsl:apply-templates select="solution" />
  </body>
</html>
  </xsl:template>
  
  <xsl:template match="problem">
	  <h3>Problem</h3>
	  <div class="indent"><xsl:apply-templates /></div>
  </xsl:template>
  
  <xsl:template match="solution">
        <h1>Solution</h1>
		<xsl:apply-templates select="description" />
		<xsl:apply-templates select="." mode="table_of_contents" />
		<xsl:apply-templates select="." mode="overview" />
		<xsl:apply-templates select="researches" />
		<xsl:apply-templates select="modules" />
		<xsl:apply-templates select="test-plan" />
		<xsl:apply-templates select="specification" />
		<xsl:apply-templates select="packages" />
		<xsl:apply-templates select="diagrams" />
		<xsl:apply-templates select="gui" />
        <xsl:apply-templates select="capsules" />
		<xsl:apply-templates select="classes" />
        <xsl:apply-templates select="types" />
		<xsl:apply-templates select="functions" />
        <xsl:apply-templates select="threads" />
		<xsl:apply-templates select="test-procedures" />
		<xsl:apply-templates select="test-scenarios" />	  
  </xsl:template>

  <xsl:template match="solution/description">
    <h3>Description</h3>
    <div class="indent"><xsl:apply-templates /></div>
  </xsl:template>
  
  <xsl:template match="solution" mode="table_of_contents">
	<xsl:if test="researches or test-plan or specification or packages or diagrams or gui or capsules or types or classes or functions or threads or test-procedures or test-scenarios">
		<h3>Table of contents</h3>
		<ul class="contents">
			<xsl:apply-templates select="." mode="table_of_contents_overview" />
			<xsl:apply-templates select="." mode="table_of_contents_researches" />
			<xsl:apply-templates select="." mode="table_of_contents_modules" />
			<xsl:apply-templates select="." mode="table_of_contents_test_plan" />
			<xsl:apply-templates select="." mode="table_of_contents_specification" />
			<xsl:apply-templates select="." mode="table_of_contents_packages" />
			<xsl:apply-templates select="." mode="table_of_contents_diagrams" />
			<xsl:apply-templates select="." mode="table_of_contents_gui" />
            <xsl:apply-templates select="." mode="table_of_contents_capsules" />
			<xsl:apply-templates select="." mode="table_of_contents_interfaces" />
			<xsl:apply-templates select="." mode="table_of_contents_classes" />
            <xsl:apply-templates select="." mode="table_of_contents_types" />
			<xsl:apply-templates select="." mode="table_of_contents_functions" />
            <xsl:apply-templates select="." mode="table_of_contents_threads" />
			<xsl:apply-templates select="." mode="table_of_contents_test_procedures" />
			<xsl:apply-templates select="." mode="table_of_contents_test_scenarios" />
		</ul>
	</xsl:if>
  </xsl:template>

</xsl:stylesheet>
