<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- family - description -->

    <xsl:template match="workspace | package" mode="overview_families">
        <xsl:if test="family">
            <table class="overview">
                <caption>Family - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="family" mode="fd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="family" mode="fd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:apply-templates select="description" mode="onlyDescription" />
                <xsl:apply-templates select="project" mode="fd" />
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="family/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="project" mode="fd">
        <xsl:variable name="canPerform" select="description or .//project/description" as="xs:boolean" />
        <xsl:if test="$canPerform">
            <h3>Project :
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </h3>
            <div class="indent">
                <xsl:apply-templates select="description" mode="onlyDescription" />
                <xsl:apply-templates select="project" mode="fd" />
            </div>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>