<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- projects -->

    <xsl:template match="workspace | package | family" mode="table_of_contents_projects">
        <xsl:if test="project">
            <li>Projects
                <ul>
                    <xsl:for-each select="project">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workspace/project">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Project : <xsl:apply-templates select="." mode="name" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Project : <xsl:apply-templates select="." mode="name" /></h2></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="." mode="uses" />
            <xsl:apply-templates select="." mode="used-by" />
            <xsl:apply-templates select="." mode="subsystem" />
            <xsl:apply-templates select="diagram" />
        </div>
    </xsl:template>

    <xsl:template match="package/project | family/project">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Project : <xsl:apply-templates select="." mode="name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Project : <xsl:apply-templates select="." mode="name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="." mode="uses" />
            <xsl:apply-templates select="." mode="used-by" />
            <xsl:apply-templates select="." mode="subsystem" />
            <xsl:apply-templates select="diagram" />
        </div>
    </xsl:template>

    <xsl:template match="project | uses | used-by | subsystem" mode="name">
        <xsl:choose>
            <xsl:when test="$out = 'file'"><a href="{@page}"><xsl:value-of select="@name" /></a></xsl:when>
            <xsl:otherwise><a href="{@document}"><xsl:value-of select="@name" /></a></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="project/description">
        <h3>Description</h3>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

    <xsl:template match="project" mode="uses">
        <xsl:if test="uses">
            <h3>Uses the projects</h3>
            <ol class="projects">
                <xsl:for-each select="uses">
                    <xsl:choose>
                        <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates select="." mode="name" /></li></xsl:when>
                        <xsl:otherwise><li><xsl:apply-templates select="." mode="name" /></li></xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </ol>
        </xsl:if>
    </xsl:template>

    <xsl:template match="project" mode="used-by">
        <xsl:if test="used-by">
            <h3>Is used by the projects</h3>
            <ol class="projects">
                <xsl:for-each select="used-by">
                    <xsl:choose>
                        <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates select="." mode="name" /></li></xsl:when>
                        <xsl:otherwise><li><xsl:apply-templates select="." mode="name" /></li></xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </ol>
        </xsl:if>
    </xsl:template>

    <xsl:template match="project" mode="subsystem">
        <xsl:if test="subsystem">
            <h3>Contains the subsystems</h3>
            <ol class="projects">
                <xsl:for-each select="subsystem">
                    <xsl:choose>
                        <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates select="." mode="name" /></li></xsl:when>
                        <xsl:otherwise><li><xsl:apply-templates select="." mode="name" /></li></xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </ol>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>