package neutrino.autocomplete;


import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

import javax.swing.*;
import javax.swing.text.JTextComponent;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class AttributeCompletion implements Completion {

    private CompletionProvider provider;
    private Icon icon;
    private String replacementText;
    private String shortDesc;
    private String summary;

    public AttributeCompletion(CompletionProvider provider, String replacementText, String shortDesc) {
        this(provider, replacementText, shortDesc, null);
    }

    public AttributeCompletion(CompletionProvider provider, String replacementText, String shortDesc, String summary) {
        this.provider = provider;
        this.replacementText = replacementText;
        if (shortDesc != null && shortDesc.isEmpty()) shortDesc = null;
        this.shortDesc = shortDesc;
        this.summary = summary;
    }


    @Override
    public int compareTo(Completion c2) {
        if (c2==this) {
            return 0;
        }
        else if (c2!=null) {
            return toString().compareToIgnoreCase(c2.toString());
        }
        return -1;
    }

    @Override
    public String getAlreadyEntered(JTextComponent comp) {
        return provider.getAlreadyEnteredText(comp);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String getInputText() {
        return this.replacementText;
    }

    @Override
    public CompletionProvider getProvider() {
        return this.provider;
    }

    @Override
    public int getRelevance() {
        return 0;
    }

    @Override
    public String getReplacementText() {
        return this.replacementText + "=\"\"";
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public String getShortDescription() {
        return shortDesc;
    }

    public void setShortDescription(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    @Override
    public String toString() {
        if (shortDesc==null) {
            return " " + getInputText();
        }
        return " " + getInputText() + " - " + shortDesc;
    }

}
