package neutrino.multitext;

import neutrino.multitext.adapters.plain.*;
import neutrino.multitext.adapters.styled.*;
import neutrino.multitext.adapters.syntax.*;
import neutrino.text.components.plain.PlainTextComponent;
import neutrino.text.components.styled.RTFComponent;
import neutrino.text.components.styled.WebComponent;
import neutrino.text.components.syntax.*;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class EditorAdapterFactory {

    /**
     * Creates appropriate TextEditorAdapter for given EditorType
     * @param type - EditorType
     * @return TextEditorAdapter
     */
    public static TextEditorAdapter createTextEditorAdapterForEditorType(EditorType type) {
        if (type == null) return new PlainTextAreaEditorAdapter();
        switch (type) {
            case PLAIN:
                return new PlainTextAreaEditorAdapter();
            case TEXT:
                return new PlainTextEditorAdapter();
            case WEB:
                return new WebEditorAdapter();
            case RTF:
                return new RTFEditorAdapter();
            case XML:
                return new XMLEditorAdapter();
            case HTML:
                return new HTMLEditorAdapter();
            case SYNTAX:
                return new SyntaxTextEditorAdapter();
            case ACTIONSCRIPT:
                return new ActionScriptEditorAdapter();
            case ASSEMBLER:
                return new AssemblerEditorAdapter();
            case BBCODE:
                return new BBCodeEditorAdapter();
            case C:
                return new CEditorAdapter();
            case CPP:
                return new CPPEditorAdapter();
            case CLOJURE:
                return new ClojureEditorAdapter();
            case CSHARP:
                return new CSharpEditorAdapter();
            case CSS:
                return new CSSEditorAdapter();
            case PASCAL:
                return new PascalEditorAdapter();
            case DTD:
                return new DTDEditorAdapter();
            case MXML:
                return new MXMLEditorAdapter();
            case FORTRAN:
                return new FortranEditorAdapter();
            case GROOVY:
                return new GroovyEditorAdapter();
            case JAVA:
                return new JavaEditorAdapter();
            case JAVASCRIPT:
                return new JavaScriptEditorAdapter();
            case JSON:
                return new JSONEditorAdapter();
            case JSP:
                return new JSPEditorAdapter();
            case LATEX:
                return new LaTeXEditorAdapter();
            case LISP:
                return new LispEditorAdapter();
            case LUA:
                return new LuaEditorAdapter();
            case MAKE:
                return new MakeEditorAdapter();
            case NSIS:
                return new NSISEditorAdapter();
            case PERL:
                return new PerlEditorAdapter();
            case PHP:
                return new PHPEditorAdapter();
            case PROPERTIES:
                return new PropertiesEditorAdapter();
            case PYTHON:
                return new PythonEditorAdapter();
            case RUBY:
                return new RubyEditorAdapter();
            case SAS:
                return new SASEditorAdapter();
            case SCALA:
                return new ScalaEditorAdapter();
            case SQL:
                return new SQLEditorAdapter();
            case TCL:
                return new TclEditorAdapter();
            case SHELL:
                return new ShellEditorAdapter();
            case BASIC:
                return new BasicEditorAdapter();
            case BATCH:
                return new BatchEditorAdapter();
            default:
                return new PlainTextAreaEditorAdapter();
        }
    }

    /**
     * Creates appropriate TextEditorAdapter for given TextComponent class name
     * @param className - String
     * @return TextEditorAdapter
     */
    public static TextEditorAdapter createTextEditorAdapterForTextComponent(String className) {
        if (className == null) {
            return new PlainTextAreaEditorAdapter();
        } if (className.equals(RTFComponent.class.getCanonicalName())) {
            return new RTFEditorAdapter();
        } else if (className.equals(WebComponent.class.getCanonicalName())) {
            return new WebEditorAdapter();
        } else if (className.equals(SyntaxTextComponent.class.getCanonicalName())) {
            return new SyntaxTextEditorAdapter();
        } else if (className.equals(PlainTextComponent.class.getCanonicalName())) {
            return new PlainTextEditorAdapter();
        } else if (className.equals(SyntaxTextComponent.class.getCanonicalName())) {
            return new SyntaxTextEditorAdapter();
        } else if (className.equals(ActionScriptComponent.class.getCanonicalName())) {
            return new ActionScriptEditorAdapter();
        } else if (className.equals(AssemblerComponent.class.getCanonicalName())) {
            return new AssemblerEditorAdapter();
        } else if (className.equals(BasicComponent.class.getCanonicalName())) {
            return new BasicEditorAdapter();
        } else if (className.equals(BatchComponent.class.getCanonicalName())) {
            return new BatchEditorAdapter();
        } else if (className.equals(BBCodeComponent.class.getCanonicalName())) {
            return new BBCodeEditorAdapter();
        } else if (className.equals(CComponent.class.getCanonicalName())) {
            return new CEditorAdapter();
        } else if (className.equals(ClojureComponent.class.getCanonicalName())) {
            return new ClojureEditorAdapter();
        } else if (className.equals(CPPComponent.class.getCanonicalName())) {
            return new CPPEditorAdapter();
        } else if (className.equals(CSharpComponent.class.getCanonicalName())) {
            return new CSharpEditorAdapter();
        } else if (className.equals(CSSComponent.class.getCanonicalName())) {
            return new CSSEditorAdapter();
        } else if (className.equals(DTDComponent.class.getCanonicalName())) {
            return new DTDEditorAdapter();
        } else if (className.equals(FortranComponent.class.getCanonicalName())) {
            return new FortranEditorAdapter();
        } else if (className.equals(GroovyComponent.class.getCanonicalName())) {
            return new GroovyEditorAdapter();
        } else if (className.equals(HTMLComponent.class.getCanonicalName())) {
            return new HTMLEditorAdapter();
        } else if (className.equals(JavaComponent.class.getCanonicalName())) {
            return new JavaEditorAdapter();
        } else if (className.equals(JavaScriptComponent.class.getCanonicalName())) {
            return new JavaScriptEditorAdapter();
        } else if (className.equals(JSONComponent.class.getCanonicalName())) {
            return new JSONEditorAdapter();
        } else if (className.equals(JSPComponent.class.getCanonicalName())) {
            return new JSPEditorAdapter();
        } else if (className.equals(LaTeXComponent.class.getCanonicalName())) {
            return new LaTeXEditorAdapter();
        } else if (className.equals(LispComponent.class.getCanonicalName())) {
            return new LispEditorAdapter();
        } else if (className.equals(LuaComponent.class.getCanonicalName())) {
            return new LuaEditorAdapter();
        } else if (className.equals(MakeComponent.class.getCanonicalName())) {
            return new MakeEditorAdapter();
        } else if (className.equals(MXMLComponent.class.getCanonicalName())) {
            return new MXMLEditorAdapter();
        } else if (className.equals(NSISComponent.class.getCanonicalName())) {
            return new NSISEditorAdapter();
        } else if (className.equals(PascalComponent.class.getCanonicalName())) {
            return new PascalEditorAdapter();
        } else if (className.equals(PerlComponent.class.getCanonicalName())) {
            return new PerlEditorAdapter();
        } else if (className.equals(PHPComponent.class.getCanonicalName())) {
            return new PHPEditorAdapter();
        } else if (className.equals(PropertiesComponent.class.getCanonicalName())) {
            return new PropertiesEditorAdapter();
        } else if (className.equals(PythonComponent.class.getCanonicalName())) {
            return new PythonEditorAdapter();
        } else if (className.equals(RubyComponent.class.getCanonicalName())) {
            return new RubyEditorAdapter();
        } else if (className.equals(SASComponent.class.getCanonicalName())) {
            return new SASEditorAdapter();
        } else if (className.equals(ScalaComponent.class.getCanonicalName())) {
            return new ScalaEditorAdapter();
        } else if (className.equals(ShellComponent.class.getCanonicalName())) {
            return new ShellEditorAdapter();
        } else if (className.equals(SQLComponent.class.getCanonicalName())) {
            return new SQLEditorAdapter();
        } else if (className.equals(TclComponent.class.getCanonicalName())) {
            return new TclEditorAdapter();
        } else if (className.equals(XMLComponent.class.getCanonicalName())) {
            return new XMLEditorAdapter();
        } else {
            return new PlainTextAreaEditorAdapter();
        }
    }

    /**
     * Creates appropriate TextEditorAdapter for given file extension
     * @param extension - String
     * @return TextEditorAdapter
     */
    public static String getTextEditorAdapterClassNameForFileExtension(String extension) {
        if (extension == null) {
            return PlainTextAreaEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("as") || extension.equalsIgnoreCase("asc")) {
            return ActionScriptEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("asm")) {
            return AssemblerEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("vb")) {
            return BasicEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("bat") || extension.equalsIgnoreCase("cmd")) {
            return BatchEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("bbc")) {
            return BBCodeEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("c") || extension.equalsIgnoreCase("h")) {
            return CEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("clj")) {
            return ClojureEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("cpp") || extension.equalsIgnoreCase("cxx") || extension.equalsIgnoreCase("c")) {
            return CPPEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("cs")) {
            return CSharpEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("css")) {
            return CSSEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("dtd")) {
            return DTDEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("f") || extension.equalsIgnoreCase("for")
                || extension.equalsIgnoreCase("fort") || extension.equalsIgnoreCase("f77")
                || extension.equalsIgnoreCase("f90")) {
            return FortranEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("groovy") || extension.equalsIgnoreCase("grv")) {
            return GroovyEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("htm") || extension.equalsIgnoreCase("html")) {
            return HTMLEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("java")) {
            return JavaEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("js")) {
            return JavaScriptEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("json")) {
            return JSONEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("jsp")) {
            return JSPEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("tex") || extension.equalsIgnoreCase("ltx") || extension.equalsIgnoreCase("latex")) {
            return LaTeXEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("cl") || extension.equalsIgnoreCase("clisp")
                || extension.equalsIgnoreCase("el") || extension.equalsIgnoreCase("l")
                || extension.equalsIgnoreCase("lisp") || extension.equalsIgnoreCase("lsp")
                || extension.equalsIgnoreCase("ml")) {
            return LispEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("lua")) {
            return LuaEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("makefile")) {
            return MakeEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("mxml")) {
            return MXMLEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("nsi")) {
            return NSISEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("pas")) {
            return PascalEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("pl") || extension.equalsIgnoreCase("perl") || extension.equalsIgnoreCase("pm")) {
            return PerlEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("php")) {
            return PHPEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("properties")) {
            return PropertiesEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("py")) {
            return PythonEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("rb")) {
            return RubyEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("sas")) {
            return SASEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("scala")) {
            return ScalaEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("sh") || extension.equalsIgnoreCase("bsh")
                || extension.equalsIgnoreCase("csh") || extension.equalsIgnoreCase("ksh")) {
            return ShellEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("sql")) {
            return SQLEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("tcl")) {
            return TclEditorAdapter.class.getCanonicalName();
        } else if (extension.equalsIgnoreCase("xml") || extension.equalsIgnoreCase("xsl")
                || extension.equalsIgnoreCase("xsd") || extension.equalsIgnoreCase("wsdl")
                || extension.equalsIgnoreCase("jnlp") || extension.equalsIgnoreCase("macro")
                || extension.equalsIgnoreCase("manifest")) {
            return XMLEditorAdapter.class.getCanonicalName();
        } else {
            return PlainTextAreaEditorAdapter.class.getCanonicalName();
        }
    }

    /**
     * Returns the appropriate EditorType for the given TextEditorAdapter
     * @param adapter - TextEditorAdapter
     * @return EditorType
     */
    public static EditorType getEditorTypeForTextEditorAdapter(TextEditorAdapter adapter) {
        if (adapter.getClass().equals(PlainTextAreaEditorAdapter.class)) return EditorType.PLAIN;
        if (adapter.getClass().equals(PlainTextEditorAdapter.class)) return EditorType.TEXT;
        if (adapter.getClass().equals(SyntaxTextEditorAdapter.class)) return EditorType.SYNTAX;
        if (adapter.getClass().equals(WebEditorAdapter.class)) return EditorType.WEB;
        if (adapter.getClass().equals(RTFEditorAdapter.class)) return EditorType.RTF;
        if (adapter.getClass().equals(XMLEditorAdapter.class)) return EditorType.XML;
        if (adapter.getClass().equals(HTMLEditorAdapter.class)) return EditorType.HTML;
        if (adapter.getClass().equals(ActionScriptEditorAdapter.class)) return EditorType.ACTIONSCRIPT;
        if (adapter.getClass().equals(AssemblerEditorAdapter.class)) return EditorType.ASSEMBLER;
        if (adapter.getClass().equals(BBCodeEditorAdapter.class)) return EditorType.BBCODE;
        if (adapter.getClass().equals(CEditorAdapter.class)) return EditorType.C;
        if (adapter.getClass().equals(CPPEditorAdapter.class)) return EditorType.CPP;
        if (adapter.getClass().equals(ClojureEditorAdapter.class)) return EditorType.CLOJURE;
        if (adapter.getClass().equals(CSharpEditorAdapter.class)) return EditorType.CSHARP;
        if (adapter.getClass().equals(CSSEditorAdapter.class)) return EditorType.CSS;
        if (adapter.getClass().equals(PascalEditorAdapter.class)) return EditorType.PASCAL;
        if (adapter.getClass().equals(DTDEditorAdapter.class)) return EditorType.DTD;
        if (adapter.getClass().equals(MXMLEditorAdapter.class)) return EditorType.MXML;
        if (adapter.getClass().equals(FortranEditorAdapter.class)) return EditorType.FORTRAN;
        if (adapter.getClass().equals(GroovyEditorAdapter.class)) return EditorType.GROOVY;
        if (adapter.getClass().equals(JavaEditorAdapter.class)) return EditorType.JAVA;
        if (adapter.getClass().equals(JavaScriptEditorAdapter.class)) return EditorType.JAVASCRIPT;
        if (adapter.getClass().equals(JSONEditorAdapter.class)) return EditorType.JSON;
        if (adapter.getClass().equals(JSPEditorAdapter.class)) return EditorType.JSP;
        if (adapter.getClass().equals(LaTeXEditorAdapter.class)) return EditorType.LATEX;
        if (adapter.getClass().equals(LispEditorAdapter.class)) return EditorType.LISP;
        if (adapter.getClass().equals(LuaEditorAdapter.class)) return EditorType.LUA;
        if (adapter.getClass().equals(MakeEditorAdapter.class)) return EditorType.MAKE;
        if (adapter.getClass().equals(NSISEditorAdapter.class)) return EditorType.NSIS;
        if (adapter.getClass().equals(PerlEditorAdapter.class)) return EditorType.PERL;
        if (adapter.getClass().equals(PHPEditorAdapter.class)) return EditorType.PHP;
        if (adapter.getClass().equals(PropertiesEditorAdapter.class)) return EditorType.PROPERTIES;
        if (adapter.getClass().equals(PythonEditorAdapter.class)) return EditorType.PYTHON;
        if (adapter.getClass().equals(RubyEditorAdapter.class)) return EditorType.RUBY;
        if (adapter.getClass().equals(SASEditorAdapter.class)) return EditorType.SAS;
        if (adapter.getClass().equals(ScalaEditorAdapter.class)) return EditorType.SCALA;
        if (adapter.getClass().equals(SQLEditorAdapter.class)) return EditorType.SQL;
        if (adapter.getClass().equals(TclEditorAdapter.class)) return EditorType.TCL;
        if (adapter.getClass().equals(ShellEditorAdapter.class)) return EditorType.SHELL;
        if (adapter.getClass().equals(BasicEditorAdapter.class)) return EditorType.BASIC;
        if (adapter.getClass().equals(BatchEditorAdapter.class)) return EditorType.BATCH;
        return EditorType.PLAIN;
    }

}