package neutrino.multitext;

import com.inet.jortho.SpellChecker;
import neutrino.dialogs.SpellingOptionsChooser;
import neutrino.text.IPlainTextComponent;
import neutrino.text.TextEditor;
import neutrino.text.components.plain.PlainTextComponent;
import neutrino.text.components.syntax.SyntaxTextComponent;
import org.fife.ui.rsyntaxtextarea.Theme;

import javax.swing.*;
import javax.swing.text.JTextComponent;
import java.awt.*;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 11/21/15
 * Time: 10:03 PM
 * To change this template use File | Settings | File Templates.
 */
public class MultiTextOptions {

    protected ArrayList<TextEditorAdapter> m_components = null;
    private MultiTextComponent multiTextComponent = null;
    private boolean autoIndentMode = true;
    private int tabSize = 4;
    private boolean lineWrap = false;
    private boolean wrapStyleWord = false;
    private boolean isPersistBackups = false;
    private Charset encoding = Charset.defaultCharset();
    private int margin = 0;
    private boolean isLineNumbersShowed = true;
    private boolean isBookmarksEnabled = true;
    private boolean isCodeFoldingEnabled = true;
    private boolean isCurrentLineHighlighted = true;
    private boolean isBracketMatchingAnimated = true;
    private boolean isOccurrencesMarked = true;
    private boolean isTabLinesPainted = true;
    private String themeFileName = "neutrino/assets/black.xml";
    private boolean isConfirmReloading = true;
    private boolean isConfirmRemoving = true;
    private boolean isConfirmOverwriting = true;
    private boolean isConfirmClosingSession = true;
    private Font font = null;
    private Color foreground = null;
    private Color background = null;
    private boolean isPersistCurrentFiles = true;

    public MultiTextOptions(MultiTextComponent multiTextComponent, ArrayList<TextEditorAdapter> components) {
        m_components = components;
        this.multiTextComponent = multiTextComponent;
        font = new JTextArea().getFont();
        foreground = multiTextComponent.getForeground();
        background = multiTextComponent.getBackground();
    }

    /**
     * Sets persisting current file option.
     * @param value - boolean
     */
    public void setPersistingCurrentFiles(boolean value) {
        this.isPersistCurrentFiles = value;
    }

    /**
     * Returns the state of persisting current file option
     * @return boolean
     */
    public boolean isPersistCurrentFiles() {
        return this.isPersistCurrentFiles;
    }

    public String getThemeFileName() {
        return this.themeFileName;
    }

    public void setTheme(String themeFileName) {
        if (themeFileName == null) return;
        this.themeFileName = themeFileName;
        InputStream in = getClass().getClassLoader().getResourceAsStream(themeFileName);
        try {
            Theme theme = Theme.load(in);
            for (TextEditor textEditor : multiTextComponent.getTextEditors()) {
                JTextComponent textComponent = textEditor.getTextComponent();
                if (textComponent instanceof SyntaxTextComponent) {
                    theme.apply((SyntaxTextComponent) textComponent);
                    textComponent.setFont(font);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setThemeForTextComponent(JTextComponent textComponent) {
        if (!(textComponent instanceof SyntaxTextComponent)) return;
        InputStream in = getClass().getClassLoader().getResourceAsStream(themeFileName);
        try {
            Theme theme = Theme.load(in);
            theme.apply((SyntaxTextComponent) textComponent);
            textComponent.setFont(font);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enableAutoSpell(boolean value) {
        SpellingOptionsChooser.setAutoSpellingMode(value);
        for (TextEditorAdapter adapter : m_components) {
            JTextComponent textComponent = adapter.getTextEditor().getTextComponent();
            SpellChecker.enableAutoSpell(textComponent, value);
        }
    }

    public boolean isAutoSpellingMode() {
        return SpellingOptionsChooser.isAutoSpellingMode();
    }

    public void setLineNumbersShowed(boolean isShowed) {
        this.isLineNumbersShowed = isShowed;
        for (TextEditorAdapter adapter : m_components) {
            if (adapter instanceof BookmarkSupport) {
                ((BookmarkSupport) adapter).setLineNumbersEnabled(isShowed);
            }
        }
    }

    public boolean isLineNumbersShowed() {
        return this.isLineNumbersShowed;
    }

    public void setBookmarksEnabled(boolean isEnabled) {
        this.isBookmarksEnabled = isEnabled;
        for (TextEditorAdapter adapter : m_components) {
            if (adapter instanceof BookmarkSupport) {
                ((BookmarkSupport) adapter).setBookmarksEnabled(isEnabled);
            }
        }
    }

    public boolean isBookmarksEnabled() {
        return this.isBookmarksEnabled;
    }

    public void setCodeFoldingEnabled(boolean isEnabled) {
        this.isCodeFoldingEnabled = isEnabled;
        for (TextEditorAdapter adapter : m_components) {
            JTextComponent textComponent = adapter.getTextEditor().getTextComponent();
            if (textComponent instanceof SyntaxTextComponent) {
                ((SyntaxTextComponent) textComponent).setCodeFoldingEnabled(isEnabled);
            }
        }
    }

    public boolean isCodeFoldingEnabled() {
        return this.isCodeFoldingEnabled;
    }

    public void setCurrentLineHighlighted(boolean isHighlighted) {
        this.isCurrentLineHighlighted = isHighlighted;
        for (TextEditorAdapter adapter : m_components) {
            JTextComponent textComponent = adapter.getTextEditor().getTextComponent();
            if (textComponent instanceof SyntaxTextComponent) {
                ((SyntaxTextComponent) textComponent).setHighlightCurrentLine(isHighlighted);
            }
        }
    }

    public boolean isCurrentLineHighlighted() {
        return this.isCurrentLineHighlighted;
    }

    public void setBracketMatchingAnimated(boolean isAnimated) {
        this.isBracketMatchingAnimated = isAnimated;
        for (TextEditorAdapter adapter : m_components) {
            JTextComponent textComponent = adapter.getTextEditor().getTextComponent();
            if (textComponent instanceof SyntaxTextComponent) {
                ((SyntaxTextComponent) textComponent).setBracketMatchingEnabled(isAnimated);
            }
        }
    }

    public boolean isBracketMatchingAnimated() {
        return this.isBracketMatchingAnimated;
    }

    public void setOccurrencesMarked(boolean isMarked) {
        this.isOccurrencesMarked = isMarked;
        for (TextEditorAdapter adapter : m_components) {
            JTextComponent textComponent = adapter.getTextEditor().getTextComponent();
            if (textComponent instanceof SyntaxTextComponent) {
                ((SyntaxTextComponent) textComponent).setMarkOccurrences(isMarked);
            }
        }
    }

    public boolean isOccurrencesMarked() {
        return this.isOccurrencesMarked;
    }

    public void setTabLinesPainted(boolean isPainted) {
        this.isTabLinesPainted = isPainted;
        for (TextEditorAdapter adapter : m_components) {
            JTextComponent textComponent = adapter.getTextEditor().getTextComponent();
            if (textComponent instanceof SyntaxTextComponent) {
                ((SyntaxTextComponent) textComponent).setPaintTabLines(isPainted);
            }
        }
    }

    public boolean isTabLinesPainted() {
        return this.isTabLinesPainted;
    }

    public void setFont(Font font) {
        if (font == null) return;
        this.font = font;
        multiTextComponent.setFont(font);
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            JTextComponent textComponent = textEditor.getTextComponent();
            if (textComponent instanceof JTextArea || textComponent instanceof PlainTextComponent) {
                textComponent.setFont(font);
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setForeground(Color color) {
        if (color == null) return;
        this.foreground = color;
        multiTextComponent.setForeground(color);
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            JTextComponent textComponent = textEditor.getTextComponent();
            if (textComponent instanceof JTextArea || textComponent instanceof PlainTextComponent) {
                textComponent.setForeground(color);
                textComponent.setCaretColor(color);
                textComponent.setSelectionColor(color);
            }
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setBackground(Color color) {
        if (color == null) return;
        this.background = color;
        multiTextComponent.setBackground(color);
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            JTextComponent textComponent = textEditor.getTextComponent();
            if (textComponent instanceof JTextArea || textComponent instanceof PlainTextComponent) {
                textComponent.setBackground(color);
                textComponent.setSelectedTextColor(color);
            }
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            if (textEditor.getTextComponent() instanceof JTextArea) {
                ((JTextArea) textEditor.getTextComponent()).setTabSize(tabSize);
            }
        }
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setMargin(int margin) {
        if (margin < 0) return;
        this.margin = margin;
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            textEditor.getTextComponent().setMargin(new Insets(margin, margin, margin, margin));
        }
    }

    public int getMargin() {
        return this.margin;
    }

    public void setLineWrap(boolean lineWrap) {
        this.lineWrap = lineWrap;
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            if (textEditor.getTextComponent() instanceof JTextArea) {
                ((JTextArea) textEditor.getTextComponent()).setLineWrap(lineWrap);
            }
        }
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public void setWrapStyleWord(boolean wrapStyleWord) {
        this.wrapStyleWord = wrapStyleWord;
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            if (textEditor.getTextComponent() instanceof JTextArea) {
                ((JTextArea) textEditor.getTextComponent()).setWrapStyleWord(wrapStyleWord);
            }
        }
    }

    public boolean getWrapStyleWord() {
        return this.wrapStyleWord;
    }

    public void setAutoIndentMode(boolean autoIndentMode) {
        this.autoIndentMode = autoIndentMode;
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            if (textEditor.getTextComponent() instanceof IPlainTextComponent) {
                ((IPlainTextComponent) textEditor.getTextComponent()).setAutoIndentMode(autoIndentMode);
            }
        }
    }

    public boolean isAutoIndentMode() {
        return this.autoIndentMode;
    }

    public boolean isPersistBackups() {
        return this.isPersistBackups;
    }

    public void setPersistBackups(boolean persistBackups) {
        this.isPersistBackups = persistBackups;
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            textEditor.getBackupManager().setEnabled(persistBackups);
        }
    }

    public void setEncoding(Charset encoding) {
        if (encoding == null) return;
        this.encoding = encoding;
        Iterator<TextEditorAdapter> iterator = m_components.iterator();
        while (iterator.hasNext()) {
            TextEditor textEditor = iterator.next().getTextEditor();
            textEditor.setEncoding(encoding);
        }
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    /**
     * Sets confirming until reloading
     * @param value - boolean
     */
    public void setConfirmationReloading(boolean value) {
        this.isConfirmReloading = value;
        for (TextEditorAdapter adapter : m_components) {
            adapter.getTextEditor().setConfirmationReloading(value);
        }
    }

    /**
     * Returns whether to confirm reloading
     * @return boolean
     */
    public boolean isConfirmReloading() {
        return this.isConfirmReloading;
    }

    /**
     * Sets confirming until overwriting
     * @param value - boolean
     */
    public void setConfirmationOverwriting(boolean value) {
        this.isConfirmOverwriting = value;
        for (TextEditorAdapter adapter : m_components) {
            adapter.getTextEditor().setConfirmationOverwriting(value);
        }
    }

    /**
     * Returns whether to confirm overwriting
     * @return boolean
     */
    public boolean isConfirmOverwriting() {
        return this.isConfirmOverwriting;
    }

    /**
     * Sets confirming until removing
     * @param value - boolean
     */
    public void setConfirmationRemoving(boolean value) {
        this.isConfirmRemoving = value;
        for (TextEditorAdapter adapter : m_components) {
            adapter.getTextEditor().setConfirmationRemoving(value);
        }
    }

    /**
     * Returns whether to confirm removing
     * @return boolean
     */
    public boolean isConfirmRemoving() {
        return this.isConfirmRemoving;
    }

    /**
     * Sets confirming of closing session
     * @param value - boolean
     */
    public void setConfirmationClosingSession(boolean value) {
        this.isConfirmClosingSession = value;
    }

    /**
     * Returns true when the closing of session mast be confirmed
     * @return boolean
     */
    public boolean isConfirmClosingSession() {
        return this.isConfirmClosingSession;
    }

}
