package neutrino.multitext;

import java.util.ArrayList;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 11/30/15
 * Time: 4:34 AM
 */
public interface SessionSupport {

    /**
     * Creates a new session
     */
    public void newSession();

    /**
     * Returns true when the current session is a new session
     * @return boolean
     */
    public boolean isNewSession();

    /**
     * Returns true when can create a new session
     * @return boolean
     */
    public boolean canCreateSession();

    /**
     * Saves the session. Asks for a name of session when necessary
     */
    public void saveSession();

    /**
     * Saves the current session with a different name
     */
    public void saveSessionAs();

    /**
     * Returns true when the current session can be renamed
     * @return boolean
     */
    public boolean canRenameSession();

    /**
     * Renames the current session
     */
    public void renameSession();

    /**
     * Returns true when the current session can be closed
     * @return boolean
     */
    public boolean canCloseSession();

    /**
     * Closes all files and the current session
     */
    public void closeSession();

    /**
     * Returns true when there is sessions to open
     * @return boolean
     */
    public boolean hasSessions();

    /**
     * Opens the given session
     * @param session
     */
    public void openSession(Session session);

    /**
     * Returns the current session
     * @return Session
     */
    public Session getCurrentSession();

    /**
     * Sets the current session
     * @param session
     */
    public void setCurrentSession(Session session);

    /**
     * Sets all given sessions
     * @param sessions - ArrayList
     */
    public void setSessions(ArrayList<Session> sessions);

    /**
     * Returns all saved sessions
     * @return array list of session
     */
    public ArrayList<Session> getSessions();

}
