package neutrino.multitext.adapters.plain;

import java.awt.BorderLayout;
import javax.swing.JScrollPane;

import neutrino.multitext.TextEditorAdapter;
import neutrino.text.components.plain.PlainTextArea;
import neutrino.text.TextEditor;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class PlainTextAreaEditorAdapter extends TextEditorAdapter {

	private PlainTextArea textComponent = null;
	private TextEditor textEditor = null;
	private JScrollPane component = null;
	
	public PlainTextAreaEditorAdapter() {
		super();
		textComponent = new PlainTextArea();
		textComponent.setUndoable(true);
		textEditor = new TextEditor(textComponent);
		component = new JScrollPane();
		component.setViewportView(textComponent);
		setLayout(new BorderLayout());
		add(component, BorderLayout.CENTER);
	}

	@Override
	public TextEditor getTextEditor() {
		return textEditor;
	}

}
