package neutrino.options;

import neutrino.multitext.MultiTextComponent;
import neutrino.multitext.MultiTextOptions;
import neutrino.multitext.Session;
import neutrino.multitext.TextInfo;
import neutrino.text.TextEditor;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;

/**
 * Contains xml editing options for persisting using object stream
 * Date: 8/21/15
 * Time: 1:27 PM
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class FileOptions implements Serializable {

    private boolean isConfirmReloading;
    private boolean isConfirmRemoving;
    private boolean isConfirmOverwriting;
    private boolean isConfirmClosingSession;
    private boolean isPersistCurrentFiles;
    private boolean isPersistBackup;
    private String encoding;
    private ArrayList<Session> sessions;
    private Session session;
    private ArrayList<TextInfo> m_currentFiles;
    private File m_currentFile;
    private File m_currentDirectory;

    public FileOptions() {
        isConfirmReloading = true;
        isConfirmRemoving = true;
        isConfirmOverwriting = true;
        isConfirmClosingSession = true;
        isPersistCurrentFiles = true;
        isPersistBackup = true;
        encoding = Charset.defaultCharset().name();
        sessions = new ArrayList<Session>();
        session = new Session();
        m_currentFiles = null;
        m_currentFile = null;
        m_currentDirectory = null;
    }

    /**
     * Build properties from program values.
     * @param textEditor
     */
    public void buildProperties(TextEditor textEditor) {
        isConfirmReloading = textEditor.isConfirmReloading();
        isConfirmRemoving = textEditor.isConfirmRemoving();
        isConfirmOverwriting = textEditor.isConfirmOverwriting();
        isPersistBackup = textEditor.getBackupManager().isEnabled();
        encoding = textEditor.getEncoding().name();
    }

    /**
     * Establish properties for application.
     * @param textEditor
     */
    public void establishProperties(TextEditor textEditor) {
        textEditor.setConfirmationReloading(isConfirmReloading);
        textEditor.setConfirmationRemoving(isConfirmRemoving);
        textEditor.setConfirmationOverwriting(isConfirmOverwriting);
        textEditor.getBackupManager().setEnabled(isPersistBackup);
        textEditor.setEncoding(Charset.forName(encoding));
    }

    /**
     * Build properties from program values.
     * @param multiTextComponent
     */
    public void buildProperties(MultiTextComponent multiTextComponent) {
        MultiTextOptions options = multiTextComponent.getMultiTextOptions();
        TextEditor textEditor = multiTextComponent.getCurrentTextEditor();
        isConfirmReloading = options.isConfirmReloading();
        isConfirmRemoving = options.isConfirmRemoving();
        isConfirmOverwriting = options.isConfirmOverwriting();
        isConfirmClosingSession = options.isConfirmClosingSession();
        isPersistCurrentFiles = options.isPersistCurrentFiles();
        isPersistBackup = options.isPersistBackups();
        encoding = options.getEncoding().name();
        sessions = multiTextComponent.getSessions();
        session = multiTextComponent.getCurrentSession();
        if (options.isPersistCurrentFiles()) {
            m_currentFiles = multiTextComponent.getCurrentFiles();
            if (textEditor.isFileLoaded()) m_currentFile = textEditor.getFile();
        } else {
            m_currentFiles = null;
        }
        m_currentDirectory = textEditor.getCurrentDirectory();
    }

    /**
     * Establish properties for application.
     * @param multiTextComponent
     */
    public void establishProperties(MultiTextComponent multiTextComponent) {
        MultiTextOptions options = multiTextComponent.getMultiTextOptions();
        options.setConfirmationReloading(isConfirmReloading);
        options.setConfirmationRemoving(isConfirmRemoving);
        options.setConfirmationOverwriting(isConfirmOverwriting);
        options.setConfirmationClosingSession(isConfirmClosingSession);
        options.setPersistBackups(isPersistBackup);
        options.setPersistingCurrentFiles(isPersistCurrentFiles);
        options.setEncoding(Charset.forName(encoding));
        multiTextComponent.setSessions(sessions);
        multiTextComponent.setCurrentSession(session);
        if (m_currentFiles != null && options.isPersistCurrentFiles()) {
            multiTextComponent.openFiles(m_currentFiles);
            if (m_currentFile != null) multiTextComponent.activateTab(m_currentFile);
        }
        multiTextComponent.setCurrentDirectory(m_currentDirectory);
    }

}
