package neutrino.options;

import neutrino.multitext.MultiTextComponent;
import neutrino.multitext.MultiTextOptions;
import neutrino.multitext.BookmarkInformation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

/**
 * Contains xml editing options for persisting using object stream
 * Date: 8/21/15
 * Time: 1:27 PM
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class SyntaxOptions implements Serializable {

    private boolean m_isLineNumbersShowed;
    private boolean m_isBookmarksEnabled;
    private boolean m_isCodeFoldingEnabled;
    private boolean m_isCurrentLineHighlighted;
    private boolean m_isBracketMatchingAnimated;
    private boolean m_isOccurrencesMarked;
    private boolean m_isTabLinesPainted;
    private String m_themeFileName;
    private Hashtable<String, ArrayList<BookmarkInformation>> m_bookmarks;

    public SyntaxOptions() {
        m_isLineNumbersShowed = true;
        m_isBookmarksEnabled = true;
        m_isCodeFoldingEnabled = true;
        m_isCurrentLineHighlighted = true;
        m_isBracketMatchingAnimated = true;
        m_isOccurrencesMarked = true;
        m_isTabLinesPainted = true;
        m_themeFileName = "neutrino/assets/black.xml";
        m_bookmarks = new Hashtable<String, ArrayList<BookmarkInformation>>();
    }

    /**
     * Establishes the properties from multi text component.
     */
    public void buildProperties(MultiTextComponent multiTextComponent) {
        MultiTextOptions options = multiTextComponent.getMultiTextOptions();
        m_isLineNumbersShowed = options.isLineNumbersShowed();
        m_isBookmarksEnabled = options.isBookmarksEnabled();
        m_isCodeFoldingEnabled = options.isCodeFoldingEnabled();
        m_isCurrentLineHighlighted = options.isCurrentLineHighlighted();
        m_isBracketMatchingAnimated = options.isBracketMatchingAnimated();
        m_isOccurrencesMarked = options.isOccurrencesMarked();
        m_isTabLinesPainted = options.isTabLinesPainted();
        m_themeFileName = options.getThemeFileName();
        m_bookmarks = multiTextComponent.getBookmarks();
    }

    /**
     * Sets the values of properties for multi text component.
     */
    public void establishProperties(MultiTextComponent multiTextComponent) {
        MultiTextOptions options = multiTextComponent.getMultiTextOptions();
        options.setTheme(m_themeFileName);
        options.setLineNumbersShowed(m_isLineNumbersShowed);
        options.setBookmarksEnabled(m_isBookmarksEnabled);
        options.setCodeFoldingEnabled(m_isCodeFoldingEnabled);
        options.setCurrentLineHighlighted(m_isCurrentLineHighlighted);
        options.setBracketMatchingAnimated(m_isBracketMatchingAnimated);
        options.setOccurrencesMarked(m_isOccurrencesMarked);
        options.setTabLinesPainted(m_isTabLinesPainted);
        multiTextComponent.setBookmarks(m_bookmarks);
    }

}
