package neutrino.options;

import neutrino.multitext.MultiTextComponent;
import neutrino.multitext.MultiTextOptions;
import neutrino.text.components.plain.PlainTextArea;
import java.awt.*;
import java.io.Serializable;

/**
 * Contains text options for persisting using object stream
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class TextOptions implements Serializable {

    private Font m_font;
    private Color m_foreground;
    private Color m_background;
    private int m_tabSize;
    private int m_margin;
    private boolean m_lineWrap;
    private boolean m_wrapStyleWord;
    private boolean m_isAutoIndentMode;
    private boolean m_isReadOnlyMode;
    private boolean[] m_readOnlyModes;

    public TextOptions() {
        m_font = new Font("Courier 10 Pitch", Font.PLAIN, 14);
        m_foreground = new Color(191, 191, 191);
        m_background = Color.BLACK;
        m_tabSize = 4;
        m_margin = 10;
        m_lineWrap = false;
        m_wrapStyleWord = true;
        m_isAutoIndentMode = true;
        m_isReadOnlyMode = false;
        m_readOnlyModes = null;
    }

    /**
     * Establishes the properties from multi text component.
     */
    public void buildProperties(MultiTextComponent multiTextComponent) {
        MultiTextOptions options = multiTextComponent.getMultiTextOptions();
        m_font = options.getFont();
        m_foreground = options.getForeground();
        m_background = options.getBackground();
        m_tabSize = options.getTabSize();
        m_margin = options.getMargin();
        m_lineWrap = options.getLineWrap();
        m_wrapStyleWord = options.getWrapStyleWord();
        m_isAutoIndentMode = options.isAutoIndentMode();
        m_isReadOnlyMode = multiTextComponent.isReadOnlyMode();
        m_readOnlyModes = multiTextComponent.getReadOnlyModes();
    }

    /**
     * Establish the properties from text component
     * @param textComponent - the instance of PlainTextArea
     */
    public void buildProperties(PlainTextArea textComponent) {
        m_font = textComponent.getFont();
        m_foreground = textComponent.getForeground();
        m_background = textComponent.getBackground();
        m_tabSize = textComponent.getTabSize();
        m_margin = textComponent.getMargin().left;
        m_lineWrap = textComponent.getLineWrap();
        m_wrapStyleWord = textComponent.getWrapStyleWord();
        m_isAutoIndentMode = textComponent.isAutoIndentMode();
        m_isReadOnlyMode = textComponent.isReadOnlyMode();
    }

    /**
     * Sets the values of properties for multi text component.
     */
    public void establishProperties(MultiTextComponent multiTextComponent) {
        MultiTextOptions options = multiTextComponent.getMultiTextOptions();
        if (m_foreground != null) options.setForeground(m_foreground);
        if (m_background != null) options.setBackground(m_background);
        if (m_font != null) options.setFont(m_font);
        if (m_tabSize > 0) options.setTabSize(m_tabSize);
        if (m_margin >= 0) options.setMargin(m_margin);
        options.setLineWrap(m_lineWrap);
        options.setWrapStyleWord(m_wrapStyleWord);
        options.setAutoIndentMode(m_isAutoIndentMode);
        multiTextComponent.setReadOnlyMode(m_isReadOnlyMode);
        multiTextComponent.setReadOnlyModes(m_readOnlyModes);
    }

    /**
     * Sets the values of properties for text component
     * @param textComponent - instance of PlainTextArea
     */
    public void establishProperties(PlainTextArea textComponent) {
        if (m_foreground != null) textComponent.setForeground(m_foreground);
        if (m_background != null) textComponent.setBackground(m_background);
        if (m_font != null) textComponent.setFont(m_font);
        if (m_tabSize > 0) textComponent.setTabSize(m_tabSize);
        if (m_margin >= 0) textComponent.setMargin(new Insets(m_margin, m_margin, m_margin, m_margin));
        textComponent.setLineWrap(m_lineWrap);
        textComponent.setWrapStyleWord(m_wrapStyleWord);
        textComponent.setAutoIndentMode(m_isAutoIndentMode);
        textComponent.setReadOnlyMode(m_isReadOnlyMode);
    }

}
