package neutrino.text;

/**
 * Stores the change or read mode in TextComponent
 * @author Oleh Radvanskyj
 * @version 2.0
 * Date: 8/20/16
 * Time: 11:48 PM
 */
public class ReadModeEvent {

    private ITextComponent textComponent = null;

    /**
     * Creates the read mode event with given text component
     * @param textComponent - ITextComponent
     */
    public ReadModeEvent(ITextComponent textComponent) {
        this.textComponent = textComponent;
    }

    /**
     * Returns the text component with changed read only mode
     * @return ITextComponent
     */
    public ITextComponent getSource() {
        return this.textComponent;
    }

}
