/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.AddParameterDialog;
import com.xrefactory.jedit.DelParameterDialog;
import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.MoveDialog;
import com.xrefactory.jedit.MoveParameterDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.RenameDialog;
import com.xrefactory.jedit.TurnDynamicToStaticDialog;
import com.xrefactory.jedit.TurnStaticToDynamicDialog;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.XrefTaskForTagFile;
import com.xrefactory.jedit.XrefactorerTask;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.jEdit;

public abstract class Refactorings {
    String param;
    static boolean running;

    abstract int getCode();

    public abstract String toString();

    void perform() {
        if (s.debug) {
            new Exception().printStackTrace(System.err);
        }
        JOptionPane.showMessageDialog((Component)s.view, "Not yet implemented", "Xrefactory Error", 0);
    }

    static void setMovingTarget() {
        s.targetFile = s.getFileName();
        s.targetLine = s.getTextArea().getCaretLine() + 1;
    }

    public static Refactorings getRefactoringFromCode(int code) {
        Refactorings res = null;
        switch (code) {
            case 0: {
                res = new No_refactoring();
                break;
            }
            case 10: {
                res = new Rename_symbol();
                break;
            }
            case 20: {
                res = new Rename_class();
                break;
            }
            case 30: {
                res = new Rename_package();
                break;
            }
            case 40: {
                res = new Add_parameter();
                break;
            }
            case 50: {
                res = new Del_parameter();
                break;
            }
            case 60: {
                res = new Move_parameter();
                break;
            }
            case 220: {
                res = new Extract_method();
                break;
            }
            case 230: {
                res = new Extract_function();
                break;
            }
            case 240: {
                res = new Extract_macro();
                break;
            }
            case 70: {
                res = new Move_static_field();
                break;
            }
            case 80: {
                res = new Move_static_method();
                break;
            }
            case 90: {
                res = new Move_field();
                break;
            }
            case 120: {
                res = new Pull_up_field();
                break;
            }
            case 130: {
                res = new Pull_up_method();
                break;
            }
            case 140: {
                res = new Push_down_field();
                break;
            }
            case 150: {
                res = new Push_down_method();
                break;
            }
            case 160: {
                res = new Move_class();
                break;
            }
            case 170: {
                res = new Move_class_to_new_file();
                break;
            }
            case 190: {
                res = new Encapsulate_field();
                break;
            }
            case 200: {
                res = new Self_encapsulate_field();
                break;
            }
            case 100: {
                res = new Turn_dynamic_method_to_static();
                break;
            }
            case 110: {
                res = new Turn_static_method_to_dynamic();
                break;
            }
            case 250: {
                res = new Reduce_names();
                break;
            }
            case 260: {
                res = new Expand_names();
                break;
            }
            case 280: {
                res = new Set_move_target();
                break;
            }
            default: {
                res = null;
                JOptionPane.showMessageDialog((Component)s.view, "Unknown refactoring code: " + code, "Xrefactory Internal Error", 0);
            }
        }
        return res;
    }

    public static void renameSymbol(String newname) {
        if (newname != null) {
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-rename");
            xroption.add("-renameto=" + newname);
            Refactorings.mainRefactorerInvocation(xroption, false);
        }
    }

    public static void renameClass(String newname, boolean synchro) {
        if (newname != null) {
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-rename-class");
            xroption.add("-renameto=" + newname);
            Refactorings.mainRefactorerInvocation(xroption, synchro);
        }
    }

    public static void mainRefactorerInvocation(XrefStringArray options, boolean synchronisation) {
        RefactoringsRunnable r = new RefactoringsRunnable(options);
        if (synchronisation) {
            r.run();
        } else {
            r.run();
        }
    }

    static class RefactoringsRunnable
    implements Runnable {
        XrefStringArray runOptions;
        static boolean running;
        static XrefactorerTask activeProcess;

        public static boolean passCheckForRunningProcess() {
            while (running) {
                int res = JOptionPane.showConfirmDialog((Component)s.view, "A refactoring process is running, kill it?", "Xrefactory", 1);
                if (res == 0) {
                    if (activeProcess == null) continue;
                    activeProcess.killThis(false);
                    continue;
                }
                if (res != 2) continue;
                return false;
            }
            return true;
        }

        public void run() {
            if (!RefactoringsRunnable.passCheckForRunningProcess()) {
                return;
            }
            running = true;
            String project = null;
            if (Opt.saveFilesBeforeRefactorings()) {
                s.saveAllBuffers(s.view);
            }
            if (Opt.updateBeforeRefactorings()) {
                boolean panic = s.synchronizedUpdateTagFile((Component)s.view);
                if (panic) {
                    running = false;
                    return;
                }
            } else if (!XrefTaskForTagFile.passCheckForRunningProcess("Tags are currently being created or updated. Can I kill this process?", (Component)s.view)) {
                running = false;
                return;
            }
            if ((project = s.activeProject) != null) {
                XrefStringArray taskOptions = new XrefStringArray();
                DispatchData ndata = new DispatchData((Component)s.view);
                taskOptions.add("-p");
                taskOptions.add(project);
                taskOptions.add(this.runOptions);
                taskOptions.add("-user");
                taskOptions.add(s.getViewParameter(ndata.viewId));
                if (jEdit.getBooleanProperty((String)"xrefactory.refactoring-imports-on-demand", (boolean)true)) {
                    taskOptions.add("-addimportdefault=0");
                } else {
                    taskOptions.add("-addimportdefault=1");
                }
                activeProcess = new XrefactorerTask(taskOptions);
                ndata.xTask = activeProcess;
                ndata.progressMessage = "Computing patches.";
                XrefCharBuffer receipt = activeProcess.getTaskOutput(ndata);
                new ApplyRefactoring(receipt, ndata).run();
            }
            running = false;
        }

        RefactoringsRunnable(XrefStringArray runOptions) {
            this.runOptions = runOptions;
        }
    }

    static class ApplyRefactoring
    implements Runnable {
        XrefCharBuffer receipt;
        DispatchData ndata;

        public void run() {
            Dispatch.dispatch(this.receipt, this.ndata);
            if (!this.ndata.panic && Opt.saveFilesAfterRefactorings()) {
                s.saveAllBuffers(s.view);
            }
        }

        ApplyRefactoring(XrefCharBuffer receipt, DispatchData ndata) {
            this.receipt = receipt;
            this.ndata = ndata;
        }
    }

    public static class Set_move_target
    extends Refactorings {
        int getCode() {
            return 280;
        }

        public String toString() {
            return "Set Target for Next Moving Refactoring";
        }

        void perform() {
            Refactorings.setMovingTarget();
            SwingUtilities.invokeLater(new s.MessageDisplayer("Next moving refactoring will move to " + new File(s.getBuffer().getPath()).getName() + ":" + s.targetLine, false));
        }
    }

    public static class Expand_names
    extends Refactorings {
        int getCode() {
            return 260;
        }

        public String toString() {
            return "Expand Names";
        }

        void perform() {
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-expand");
            Refactorings.mainRefactorerInvocation(xroption, false);
        }
    }

    public static class Reduce_names
    extends Refactorings {
        int getCode() {
            return 250;
        }

        public String toString() {
            return "Reduce Names";
        }

        void perform() {
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-reduce");
            Refactorings.mainRefactorerInvocation(xroption, false);
        }
    }

    public static class Turn_static_method_to_dynamic
    extends Refactorings {
        int getCode() {
            return 110;
        }

        public String toString() {
            return "Turn Static Method to Virtual";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new TurnStaticToDynamicDialog(name);
        }
    }

    public static class Turn_dynamic_method_to_static
    extends Refactorings {
        int getCode() {
            return 100;
        }

        public String toString() {
            return "Turn Virtual Method to Static";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new TurnDynamicToStaticDialog(name);
        }
    }

    public static class Self_encapsulate_field
    extends Refactorings {
        int getCode() {
            return 200;
        }

        public String toString() {
            return "Self Encapsulate Field";
        }

        void perform() {
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-self-encapsulate-field");
            Refactorings.mainRefactorerInvocation(xroption, false);
        }
    }

    public static class Encapsulate_field
    extends Refactorings {
        int getCode() {
            return 190;
        }

        public String toString() {
            return "Encapsulate Field";
        }

        void perform() {
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-encapsulate-field");
            Refactorings.mainRefactorerInvocation(xroption, false);
        }
    }

    public static class Push_down_method
    extends Refactorings {
        int getCode() {
            return 150;
        }

        public String toString() {
            return "Push Down Method";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new MoveDialog("Push down method '" + name + "'", false, "-rfct-push-down-method", "-olcxmmtarget");
        }
    }

    public static class Push_down_field
    extends Refactorings {
        int getCode() {
            return 140;
        }

        public String toString() {
            return "Push Down Field";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new MoveDialog("Push down field '" + name + "'", false, "-rfct-push-down-field", "-olcxmmtarget");
        }
    }

    public static class Pull_up_method
    extends Refactorings {
        int getCode() {
            return 130;
        }

        public String toString() {
            return "Pull Up Method";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new MoveDialog("Pull up method '" + name + "'", false, "-rfct-pull-up-method", "-olcxmmtarget");
        }
    }

    public static class Pull_up_field
    extends Refactorings {
        int getCode() {
            return 120;
        }

        public String toString() {
            return "Pull Up Field";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new MoveDialog("Pull up field '" + name + "'", false, "-rfct-pull-up-field", "-olcxmmtarget");
        }
    }

    public static class Move_field
    extends Refactorings {
        int getCode() {
            return 90;
        }

        public String toString() {
            return "Move Field";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new MoveDialog("Move field '" + name + "'", true, "-rfct-move-field", "-olcxmmtarget");
        }
    }

    public static class Move_class_to_new_file
    extends Refactorings {
        int getCode() {
            return 160;
        }

        public String toString() {
            return "Move Class To New File";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            s.Position cpos = s.getPosition(s.view);
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(new File(s.getBuffer().getPath()).getParentFile().getAbsolutePath() + s.slash + name + ".java"));
            chooser.setDialogTitle("Select file for class moving");
            int returnVal = chooser.showSaveDialog((Component)s.view);
            if (returnVal == 0) {
                File ff = chooser.getSelectedFile();
                if (ff.getAbsolutePath().equals(cpos.file)) {
                    JOptionPane.showMessageDialog((Component)s.view, "The file contains the class to be moved. Can not clear it and then move.", "Xrefactory Error", 0);
                } else {
                    s.moveToPosition(s.view, ff.getAbsolutePath(), 0);
                    if (ff.exists()) {
                        int confirm = 0;
                        confirm = JOptionPane.showConfirmDialog((Component)s.view, "File " + ff + " exists. Can I erase it first?", "Confirmation", 0, 3);
                        if (confirm == 0) {
                            s.getTextArea().setText("");
                        }
                    }
                    Refactorings.setMovingTarget();
                    s.moveToPosition(cpos);
                    s.performMovingRefactoring("-rfct-move-class-to-new-file", null);
                }
            }
        }
    }

    public static class Move_class
    extends Refactorings {
        int getCode() {
            return 160;
        }

        public String toString() {
            return "Move Class";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new MoveDialog("Move class '" + name + "'", false, "-rfct-move-class", "-olcxmctarget");
        }
    }

    public static class Move_static_method
    extends Refactorings {
        MoveDialog d;

        int getCode() {
            return 80;
        }

        public String toString() {
            return "Move Static Method";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new MoveDialog("Move static method '" + name + "'", false, "-rfct-move-static-method", "-olcxmmtarget");
        }
    }

    public static class Move_static_field
    extends Refactorings {
        MoveDialog d;

        int getCode() {
            return 70;
        }

        public String toString() {
            return "Move Static Field";
        }

        void perform() {
            String name = s.getIdentifierOnCaret();
            new MoveDialog("Move static field '" + name + "'", false, "-rfct-move-static-field", "-olcxmmtarget");
        }
    }

    public static class Extract_macro
    extends Refactorings {
        int getCode() {
            return 240;
        }

        public String toString() {
            return "Extract Macro";
        }

        void perform() {
            String def;
            int offset;
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-extract-macro");
            Refactorings.mainRefactorerInvocation(xroption, true);
            if (s.xExtractMethod != null && (offset = (def = s.getBuffer().getLineText(s.xExtractMethod.definitionLine - 1)).indexOf("NEW_MACRO_")) != -1) {
                s.moveToPosition(s.view, s.getFileName(), s.xExtractMethod.definitionLine, offset);
                Refactorings.renameSymbol(s.xExtractMethod.name.getText());
            }
        }
    }

    public static class Extract_function
    extends Refactorings {
        int getCode() {
            return 230;
        }

        public String toString() {
            return "Extract Function";
        }

        void perform() {
            String def;
            int offset;
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-extract-method");
            Refactorings.mainRefactorerInvocation(xroption, true);
            if (s.xExtractMethod != null && (offset = (def = s.getBuffer().getLineText(s.xExtractMethod.definitionLine - 1)).indexOf("newFunction_")) != -1) {
                s.moveToPosition(s.view, s.getFileName(), s.xExtractMethod.definitionLine, offset);
                Refactorings.renameSymbol(s.xExtractMethod.name.getText());
            }
        }
    }

    public static class Extract_method
    extends Refactorings {
        int getCode() {
            return 220;
        }

        public String toString() {
            return "Extract Method";
        }

        void perform() {
            XrefStringArray xroption = new XrefStringArray();
            xroption.add("-rfct-extract-method");
            Refactorings.mainRefactorerInvocation(xroption, true);
            if (s.xExtractMethod != null) {
                String def = s.getBuffer().getLineText(s.xExtractMethod.definitionLine - 1);
                int offset = def.indexOf("newMethod_");
                if (offset != -1) {
                    s.moveToPosition(s.view, s.getFileName(), s.xExtractMethod.definitionLine, offset);
                    Refactorings.renameSymbol(s.xExtractMethod.name.getText());
                } else {
                    offset = def.indexOf("NewClass_");
                    if (offset != -1) {
                        s.moveToPosition(s.view, s.getFileName(), s.xExtractMethod.definitionLine, offset);
                        Refactorings.renameClass(s.upperCaseFirstLetter(s.xExtractMethod.name.getText()), true);
                        String lcdef = s.getBuffer().getLineText(s.xExtractMethod.invocationLine - 1);
                        offset = lcdef.indexOf("newClass_");
                        if (offset != -1) {
                            s.moveToPosition(s.view, s.getFileName(), s.xExtractMethod.invocationLine, offset);
                            Refactorings.renameSymbol(s.lowerCaseFirstLetter(s.xExtractMethod.name.getText()));
                        }
                    }
                }
            }
        }
    }

    public static class Move_parameter
    extends Refactorings {
        int getCode() {
            return 60;
        }

        public String toString() {
            return "Move Parameter";
        }

        void perform() {
            MoveParameterDialog d = new MoveParameterDialog(s.getIdentifierOnCaret());
            int position = Integer.parseInt(d.getPosition());
            int position2 = Integer.parseInt(d.getPosition2());
            if (position > 0 && position2 > 0) {
                XrefStringArray xroption = new XrefStringArray();
                xroption.add("-rfct-move-param");
                xroption.add("-olcxparnum=" + position);
                xroption.add("-olcxparnum2=" + position2);
                Refactorings.mainRefactorerInvocation(xroption, false);
            }
        }
    }

    public static class Del_parameter
    extends Refactorings {
        int getCode() {
            return 50;
        }

        public String toString() {
            return "Delete Parameter";
        }

        void perform() {
            DelParameterDialog d = new DelParameterDialog(s.getIdentifierOnCaret());
            int position = Integer.parseInt(d.getPosition());
            if (position > 0) {
                XrefStringArray xroption = new XrefStringArray();
                xroption.add("-rfct-del-param");
                xroption.add("-olcxparnum=" + position);
                Refactorings.mainRefactorerInvocation(xroption, false);
            }
        }
    }

    public static class Add_parameter
    extends Refactorings {
        int getCode() {
            return 40;
        }

        public String toString() {
            return "Add Parameter";
        }

        void perform() {
            AddParameterDialog d = new AddParameterDialog(s.getIdentifierOnCaret());
            int position = Integer.parseInt(d.getPosition());
            String definition = d.getDefinition();
            String usage = d.getUsage();
            if (position > 0 && !definition.equals("") && !usage.equals("")) {
                XrefStringArray xroption = new XrefStringArray();
                xroption.add("-rfct-add-param");
                xroption.add("-olcxparnum=" + position);
                xroption.add("-rfct-param1=" + definition);
                xroption.add("-rfct-param2=" + usage);
                Refactorings.mainRefactorerInvocation(xroption, false);
            }
        }
    }

    public static class Rename_package
    extends Refactorings {
        int getCode() {
            return 30;
        }

        public String toString() {
            return "Rename Package";
        }

        void perform() {
            RenameDialog dd = new RenameDialog("package", s.dotifyString(this.param));
            String newname = dd.getNewName();
            if (newname != null) {
                XrefStringArray xroption = new XrefStringArray();
                xroption.add("-rfct-rename-package");
                xroption.add("-renameto=" + newname);
                Refactorings.mainRefactorerInvocation(xroption, false);
            }
        }
    }

    public static class Rename_class
    extends Refactorings {
        int getCode() {
            return 20;
        }

        public String toString() {
            return "Rename Class";
        }

        void perform() {
            RenameDialog dd = new RenameDialog("class", s.getIdentifierOnCaret());
            String newname = dd.getNewName();
            Refactorings.renameClass(newname, false);
        }
    }

    public static class Rename_symbol
    extends Refactorings {
        int getCode() {
            return 10;
        }

        public String toString() {
            return "Rename";
        }

        void perform() {
            RenameDialog dd = new RenameDialog("symbol", s.getIdentifierOnCaret());
            String newname = dd.getNewName();
            Refactorings.renameSymbol(newname);
        }
    }

    public static class No_refactoring
    extends Refactorings {
        int getCode() {
            return 0;
        }

        public String toString() {
            return "No Refactoring";
        }

        void perform() {
        }
    }
}

