/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(DOMTree.class);

    public DOMTree() {
        this((Document)null);
    }

    public DOMTree(Document document) {
        super(new Model());
        this.setRootVisible(false);
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        ((Model)this.getModel()).setDocument(document);
        this.expandRow(0);
    }

    public Document getDocument() {
        return ((Model)this.getModel()).getDocument();
    }

    public Node getNode(Object object) {
        return ((Model)this.getModel()).getNode(object);
    }

    public DefaultMutableTreeNode getMutNode(Node node) {
        return ((Model)this.getModel()).getMutNode(node);
    }

    static class Model
    extends DefaultTreeModel {
        private Document document;
        private final HashMap<MutableTreeNode, Node> nodeMap = new HashMap();
        private final HashMap<Node, MutableTreeNode> nodeMapInv = new HashMap();

        public Model() {
            this((Document)null);
        }

        public Model(Document document) {
            super(new DefaultMutableTreeNode());
            this.setDocument(document);
        }

        public synchronized void setDocument(Document document) {
            this.document = document;
            ((DefaultMutableTreeNode)this.getRoot()).removeAllChildren();
            this.nodeMap.clear();
            this.nodeMapInv.clear();
            this.buildTree();
            this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
        }

        public Document getDocument() {
            return this.document;
        }

        public Node getNode(Object object) {
            return this.nodeMap.get(object);
        }

        public DefaultMutableTreeNode getMutNode(Node node) {
            return (DefaultMutableTreeNode)this.nodeMapInv.get(node);
        }

        private void buildTree() {
            if (this.document == null) {
                return;
            }
            NodeList nodeList = this.document.getChildNodes();
            int n = nodeList != null ? nodeList.getLength() : 0;
            MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getRoot();
            block4: for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                switch (node.getNodeType()) {
                    case 9: {
                        mutableTreeNode = this.setDocumentNode(node);
                        continue block4;
                    }
                    case 1: {
                        this.insertElementNode(node, mutableTreeNode);
                        continue block4;
                    }
                }
            }
        }

        private MutableTreeNode insertNode(String string, MutableTreeNode mutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            this.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
            return defaultMutableTreeNode;
        }

        private MutableTreeNode setDocumentNode(Node node) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("<" + node.getNodeName() + '>');
            this.setRoot(defaultMutableTreeNode);
            this.nodeMap.put(defaultMutableTreeNode, node);
            this.nodeMapInv.put(node, defaultMutableTreeNode);
            return defaultMutableTreeNode;
        }

        private MutableTreeNode insertElementNode(Node node, MutableTreeNode mutableTreeNode) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('<');
            String string = node.getNodeName();
            if (string.equals("html")) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
            for (int i = 0; i < n; ++i) {
                object = namedNodeMap.item(i);
                stringBuilder.append(' ');
                stringBuilder.append(object.getNodeName());
                stringBuilder.append("=\"");
                stringBuilder.append(object.getNodeValue());
                stringBuilder.append('\"');
            }
            stringBuilder.append('>');
            MutableTreeNode mutableTreeNode2 = this.insertNode(stringBuilder.toString(), mutableTreeNode);
            this.nodeMap.put(mutableTreeNode2, node);
            this.nodeMapInv.put(node, mutableTreeNode2);
            object = node.getChildNodes();
            int n2 = object != null ? object.getLength() : 0;
            block6: for (int i = 0; i < n2; ++i) {
                Node node2 = object.item(i);
                switch (node2.getNodeType()) {
                    case 4: {
                        this.insertCDataSectionNode(node2, mutableTreeNode2);
                        continue block6;
                    }
                    case 3: {
                        this.insertTextNode(node2, mutableTreeNode2);
                        continue block6;
                    }
                    case 1: {
                        this.insertElementNode(node2, mutableTreeNode2);
                    }
                }
            }
            return mutableTreeNode2;
        }

        private MutableTreeNode insertTextNode(Node node, MutableTreeNode mutableTreeNode) {
            String string = node.getNodeValue().trim();
            if (string.length() > 0) {
                MutableTreeNode mutableTreeNode2 = this.insertNode(string, mutableTreeNode);
                this.nodeMap.put(mutableTreeNode2, node);
                this.nodeMapInv.put(node, mutableTreeNode2);
                return mutableTreeNode2;
            }
            return null;
        }

        private MutableTreeNode insertCDataSectionNode(Node node, MutableTreeNode mutableTreeNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(node.getNodeValue());
            if (stringBuilder.length() > 0) {
                MutableTreeNode mutableTreeNode2 = this.insertNode(stringBuilder.toString(), mutableTreeNode);
                this.nodeMap.put(mutableTreeNode2, node);
                this.nodeMapInv.put(node, mutableTreeNode2);
                return mutableTreeNode2;
            }
            return null;
        }
    }
}

