/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import jaxe.equations.element.MathRootElement;
import org.apache.log4j.Logger;

public class MathBase {
    private static final Logger LOG = Logger.getLogger(MathBase.class);
    private static Font STIXFontRegular = null;
    private static Font STIXFontItalic = null;
    private static Font STIXFontBold = null;
    private int inlinefontsize = 15;
    private int displayfontsize = 16;
    private final int minfontsize = 8;
    private final int maxfontsize = 60;
    private final Font[] fonts = new Font[60];
    private final Font[] italicFonts = new Font[60];
    private final Font[] boldFonts = new Font[60];
    private FontMetrics[] fontmetrics = null;
    private boolean debug = false;
    public static final int INLINE = 0;
    public static final int DISPLAY = 1;
    private final int mode = 0;
    private MathRootElement rootElement;

    public MathBase(MathRootElement mathRootElement, int n, int n2, Graphics graphics) {
        this(n, n2, graphics);
        this.setRootElement(mathRootElement);
    }

    public MathBase(MathRootElement mathRootElement, Graphics graphics) {
        this(mathRootElement, 15, 16, graphics);
    }

    public MathBase(int n, int n2, Graphics graphics) {
        this.inlinefontsize = n;
        this.displayfontsize = n2;
        try {
            InputStream inputStream;
            if (STIXFontRegular == null) {
                inputStream = this.getClass().getResourceAsStream("/jaxe/polices/STIXSubset-Regular.ttf");
                STIXFontRegular = Font.createFont(0, inputStream);
                inputStream.close();
            }
            if (STIXFontItalic == null) {
                inputStream = this.getClass().getResourceAsStream("/jaxe/polices/STIXSubset-Italic.ttf");
                STIXFontItalic = Font.createFont(0, inputStream);
                inputStream.close();
            }
            if (STIXFontBold == null) {
                inputStream = this.getClass().getResourceAsStream("/jaxe/polices/STIXSubset-Bold.ttf");
                STIXFontBold = Font.createFont(0, inputStream);
                inputStream.close();
            }
        }
        catch (FontFormatException fontFormatException) {
            LOG.error("MathBase Font.createFont", fontFormatException);
            return;
        }
        catch (IOException iOException) {
            LOG.error("MathBase Font.createFont", iOException);
            return;
        }
        for (int i = 0; i < 60; ++i) {
            this.fonts[i] = STIXFontRegular.deriveFont(0, i);
            this.italicFonts[i] = STIXFontItalic.deriveFont(2, i);
            this.boldFonts[i] = STIXFontBold.deriveFont(1, i);
        }
        if (graphics != null) {
            this.setupFontMetrics(graphics);
        }
    }

    private void setupFontMetrics(Graphics graphics) {
        this.fontmetrics = new FontMetrics[60];
        for (int i = 0; i < 60; ++i) {
            this.fontmetrics[i] = graphics.getFontMetrics(this.fonts[i]);
        }
    }

    public void setRootElement(MathRootElement mathRootElement) {
        if (mathRootElement == null) {
            return;
        }
        this.rootElement = mathRootElement;
        this.rootElement.setMathBase(this);
        if (mathRootElement.getMode() == 1) {
            this.rootElement.setFontSize(this.displayfontsize);
        } else {
            this.rootElement.setFontSize(this.inlinefontsize);
        }
        this.rootElement.setDebug(this.isDebug());
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        if (this.rootElement != null) {
            this.rootElement.setDebug(bl);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDefaultFontSize(int n) {
        if (n >= 8 || n < 60) {
            this.inlinefontsize = n;
        }
    }

    public int getDefaultInlineFontSize() {
        return this.inlinefontsize;
    }

    public void setDefaultDisplayFontSize(int n) {
        if (n >= 8 || n < 60) {
            this.displayfontsize = n;
        }
    }

    public int getDefaultDisplayFontSize() {
        return this.displayfontsize;
    }

    public Font getFont(int n) {
        if (n < 8) {
            return this.fonts[8];
        }
        if (n > 60) {
            return this.fonts[59];
        }
        return this.fonts[n];
    }

    public Font getItalicFont(int n) {
        if (n < 8) {
            return this.italicFonts[8];
        }
        if (n > 60) {
            return this.italicFonts[59];
        }
        return this.italicFonts[n];
    }

    public Font getBoldFont(int n) {
        if (n < 8) {
            return this.boldFonts[8];
        }
        if (n > 60) {
            return this.boldFonts[59];
        }
        return this.boldFonts[n];
    }

    public Font getBoldItalicFont(int n) {
        return this.getBoldFont(n).deriveFont(AffineTransform.getShearInstance(-0.5, 0.0));
    }

    public FontMetrics getFontMetrics(int n) {
        if (n < 8) {
            return this.fontmetrics[8];
        }
        if (n > 60) {
            return this.fontmetrics[59];
        }
        return this.fontmetrics[n];
    }

    public void paint(Graphics graphics) {
        if (this.fontmetrics == null) {
            this.setupFontMetrics(graphics);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.rootElement != null) {
            this.rootElement.paint(graphics);
        }
    }

    public int getWidth() {
        if (this.rootElement != null) {
            return this.rootElement.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.rootElement != null) {
            return this.rootElement.getHeight();
        }
        return 0;
    }
}

