/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations.element;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import jaxe.equations.element.MathElement;
import jaxe.equations.element.MathOver;
import jaxe.equations.element.MathRow;
import jaxe.equations.element.MathUnder;
import jaxe.equations.element.MathUnderOver;

public class MathOperator
extends MathElement {
    public static final String ELEMENT = "mo";
    public static final String ATTRIBUTE_STRETCHY = "stretchy";
    private boolean stretchy = true;
    private double lspace = 0.0;
    private double rspace = 0.0;

    public void setStretchy(boolean bl) {
        this.stretchy = bl;
    }

    public void setLspace(double d) {
        this.lspace = d;
    }

    public void setRspace(double d) {
        this.rspace = d;
    }

    private void paintDelimiter(Graphics graphics, int n, int n2, char c, char c2, char c3) {
        int n3 = this.getExprHeight();
        int n4 = this.getExprAscentHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        GlyphVector glyphVector = this.getFont().createGlyphVector(graphics2D.getFontRenderContext(), new char[]{c});
        GlyphVector glyphVector2 = this.getFont().createGlyphVector(graphics2D.getFontRenderContext(), new char[]{c2});
        GlyphVector glyphVector3 = this.getFont().createGlyphVector(graphics2D.getFontRenderContext(), new char[]{c3});
        double d = glyphVector.getVisualBounds().getHeight() - 1.0;
        double d2 = glyphVector2.getVisualBounds().getHeight() - 1.0;
        double d3 = glyphVector3.getVisualBounds().getHeight() - 1.0;
        if ((double)n3 - d - d3 > 0.0) {
            double d4 = (double)n3 - d - d3 + 3.0;
            double d5 = d4 / d2;
            AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, d5);
            glyphVector2.setGlyphTransform(0, affineTransform);
            for (int i = 0; i < 2 && glyphVector2.getVisualBounds().getHeight() != d4; ++i) {
                d5 = d5 * d4 / glyphVector2.getVisualBounds().getHeight();
                affineTransform = AffineTransform.getScaleInstance(1.0, d5);
                glyphVector2.setGlyphTransform(0, affineTransform);
            }
            graphics2D.drawGlyphVector(glyphVector2, n, n2 - n4 + (int)Math.round(d) - (int)Math.round(glyphVector2.getVisualBounds().getY()) - 1);
        }
        graphics2D.drawGlyphVector(glyphVector, n, n2 - n4 + (int)Math.round(d) - (int)Math.round(d + glyphVector.getVisualBounds().getY()));
        graphics2D.drawGlyphVector(glyphVector3, n, n2 + n3 - n4 - (int)Math.round(d3 + glyphVector3.getVisualBounds().getY()));
    }

    private void paintCurlyDelimiter(Graphics graphics, int n, int n2, char c, char c2, char c3, char c4) {
        int n3 = this.getExprHeight();
        int n4 = n2 - this.getMiddleShift();
        graphics.setColor(Color.black);
        graphics.setFont(this.getFont());
        int n5 = this.getFontMetrics().getAscent();
        int n6 = n3 / n5 + 1;
        int n7 = n6 / 2;
        if (n6 % 2 == 0) {
            ++n6;
        }
        for (int i = 1; i < n7; ++i) {
            graphics.drawString("" + c3, n, n2 - (n5 - 1) * i);
            graphics.drawString("" + c3, n, n2 + (n5 - 1) * i);
        }
        graphics.drawString("" + c2, n, n2);
        graphics.drawString("" + c, n, n2 - (n5 - 1) * n7);
        graphics.drawString("" + c4, n, n2 + (n5 - 1) * n7);
    }

    private void paintCurlyDelimiterHorizontal(Graphics graphics, int n, int n2, char c, char c2, char c3, char c4) {
        int n3 = this.getParent().getWidth(true);
        int n4 = n2 - this.getMiddleShift();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getFont());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        affineTransform.rotate(1.5707963267948966);
        affineTransform.translate(-n, -n4);
        graphics2D.setTransform(affineTransform);
        int n5 = this.getFontMetrics().getAscent();
        int n6 = n3 / n5 + 1;
        int n7 = n6 / 2;
        if (n6 % 2 == 0) {
            ++n6;
        }
        for (int i = 1; i < n7; ++i) {
            graphics2D.drawString("" + c3, n, n2 - (n5 - 1) * i);
            graphics2D.drawString("" + c3, n, n2 + (n5 - 1) * i);
        }
        graphics2D.drawString("" + c2, n, n2);
        graphics2D.drawString("" + c, n, n2 - (n5 - 1) * n7);
        graphics2D.drawString("" + c4, n, n2 + (n5 - 1) * n7);
        graphics2D.setTransform(new AffineTransform());
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3;
        if (this.lspace != 0.0) {
            n3 = this.getFontMetrics().charWidth('A');
            n += (int)Math.round(this.lspace * (double)n3);
        }
        if (this.getText().length() == 1 && "[{(|)}]\u222b".indexOf(this.getText().charAt(0)) >= 0 && this.stretchy) {
            n3 = this.getParent().getAscentHeight(false);
            int n4 = this.getParent().getDescentHeight(false);
            int n5 = n3 + n4;
            if (this.getText().equals("(")) {
                if (n5 <= this.getFontMetrics().getHeight()) {
                    graphics.setFont(this.getFont());
                    graphics.drawString(this.getText(), n, n2);
                } else {
                    this.paintDelimiter(graphics, n, n2, '\u239b', '\u239c', '\u239d');
                }
            } else if (this.getText().equals(")")) {
                if (n5 <= this.getFontMetrics().getHeight()) {
                    graphics.setFont(this.getFont());
                    graphics.drawString(this.getText(), n, n2);
                } else {
                    this.paintDelimiter(graphics, n, n2, '\u239e', '\u239f', '\u23a0');
                }
            } else if (this.getText().equals("[")) {
                if (n5 <= this.getFontMetrics().getHeight()) {
                    graphics.setFont(this.getFont());
                    graphics.drawString(this.getText(), n, n2);
                } else {
                    this.paintDelimiter(graphics, n, n2, '\u23a1', '\u23a2', '\u23a3');
                }
            } else if (this.getText().equals("]")) {
                if (n5 <= this.getFontMetrics().getHeight()) {
                    graphics.setFont(this.getFont());
                    graphics.drawString(this.getText(), n, n2);
                } else {
                    this.paintDelimiter(graphics, n, n2, '\u23a4', '\u23a5', '\u23a6');
                }
            } else if (this.getText().equals("{")) {
                if (n5 <= this.getFontMetrics().getHeight()) {
                    graphics.setFont(this.getFont());
                    graphics.drawString(this.getText(), n, n2);
                } else {
                    this.paintCurlyDelimiter(graphics, n, n2, '\u23a7', '\u23a8', '\u23aa', '\u23a9');
                }
            } else if (this.getText().equals("}")) {
                if (n5 <= this.getFontMetrics().getHeight()) {
                    graphics.setFont(this.getFont());
                    graphics.drawString(this.getText(), n, n2);
                } else {
                    this.paintCurlyDelimiter(graphics, n, n2, '\u23ab', '\u23ac', '\u23aa', '\u23ad');
                }
            } else if (this.getText().equals("|")) {
                graphics.drawLine(n + 2, n2 - n3, n + 2, n2 + n4);
            } else if (this.getText().equals("\u222b")) {
                this.paintDelimiter(graphics, n, n2, '\u2320', '\u23ae', '\u2321');
            }
        } else if (this.getText().length() == 1 && "\ufe37\ufe38".indexOf(this.getText().charAt(0)) >= 0) {
            if (this.getText().equals("\ufe37")) {
                this.paintCurlyDelimiterHorizontal(graphics, n, n2, '\u23a7', '\u23a8', '\u23aa', '\u23a9');
            } else if (this.getText().equals("\ufe38")) {
                this.paintCurlyDelimiterHorizontal(graphics, n, n2, '\u23ab', '\u23ac', '\u23aa', '\u23ad');
            }
        } else if (this.getText().length() == 1 && "\u2211\u220f".indexOf(this.getText().charAt(0)) >= 0 && this.stretchy) {
            graphics.setColor(Color.black);
            if (this.getExprHeight() > this.getFontMetrics().getHeight()) {
                Font font = this.getMathBase().getFont(this.getFontSize() * 2);
                graphics.setFont(font);
            } else {
                graphics.setFont(this.getFont());
            }
            if ("\u2211".indexOf(this.getText().charAt(0)) >= 0) {
                graphics.drawString("\u2211", n, n2);
            } else {
                graphics.drawString("\u220f", n, n2);
            }
            graphics.setFont(this.getFont());
        } else if (this.getText().equals("\u00af") && this.stretchy) {
            n3 = this.getParent().getWidth(false) - 2;
            graphics.drawLine(n, n2, n + n3, n2);
        } else if (this.getText().equals("^") && this.stretchy) {
            n3 = this.getParent().getWidth(false) - 3;
            graphics.drawLine(n, n2, n + n3 / 2, n2 - 3);
            graphics.drawLine(n + n3 / 2, n2 - 3, n + n3, n2);
        } else if (".".equals(this.getText()) || "..".equals(this.getText()) || "...".equals(this.getText())) {
            graphics.setFont(this.getFont());
            graphics.drawString(this.getText(), n + 1, n2);
        } else {
            graphics.setFont(this.getFont());
            graphics.drawString(this.getText(), n, n2);
        }
    }

    private MathElement getExpr() {
        if (this.getText().equals("\u222b") || "\u2211\u220f".contains(this.getText())) {
            MathRow mathRow = this.getParent() instanceof MathRow ? (MathRow)this.getParent() : (MathRow)this.getParent().getParent();
            MathElement mathElement = mathRow.getMathElement(1);
            if (!(mathElement instanceof MathRow) || mathElement.getMathElementCount() <= 0) {
                return mathElement;
            }
            MathElement mathElement2 = mathElement.getMathElement(0);
            if (!(mathElement2 instanceof MathRow) || mathElement2.getMathElementCount() <= 0) {
                return mathElement;
            }
            MathElement mathElement3 = mathElement2.getMathElement(0);
            if (!(mathElement3 instanceof MathUnderOver || mathElement3 instanceof MathUnder || mathElement3 instanceof MathOver || mathElement3 instanceof MathOperator)) {
                return mathElement;
            }
            MathElement mathElement4 = mathElement3 instanceof MathUnderOver || mathElement3 instanceof MathUnder || mathElement3 instanceof MathOver ? mathElement3.getMathElement(0) : mathElement3;
            if (!"\u222b".equals(mathElement4.getText()) && !"\u2211\u220f".contains(mathElement4.getText())) {
                return mathElement;
            }
            return mathElement2.getMathElement(1);
        }
        return this.getParent();
    }

    private int getExprHeight() {
        return this.getExpr().getHeight(false);
    }

    private int getExprAscentHeight() {
        return this.getExpr().getAscentHeight(false);
    }

    private int getExprDescentHeight() {
        return this.getExpr().getDescentHeight(false);
    }

    public int getWidth(boolean bl) {
        int n;
        int n2 = 0;
        if (this.lspace != 0.0 || this.rspace != 0.0) {
            n = this.getFontMetrics().charWidth('A');
            int n3 = (int)Math.round(this.lspace * (double)n);
            int n4 = (int)Math.round(this.rspace * (double)n);
            n2 = n3 + n4;
        }
        if (this.getText().length() == 1) {
            n = this.getText().charAt(0);
            if ("|".indexOf(n) >= 0) {
                return 5 + n2;
            }
            if ("\ufe37\ufe38".indexOf(n) >= 0) {
                return 1 + n2;
            }
            if ("\u222b".indexOf(n) >= 0) {
                return this.getMathBase().getFontMetrics(this.getFontSize() * 2).stringWidth(this.getText()) + n2;
            }
            if ("\u2211\u220f".indexOf(n) >= 0) {
                if (this.getExprHeight() > this.getFontMetrics().getHeight()) {
                    return this.getMathBase().getFontMetrics(this.getFontSize() * 2).stringWidth(this.getText()) + n2;
                }
                return this.getFontMetrics().stringWidth(this.getText()) + n2;
            }
            if ("^\u00af".indexOf(n) >= 0 && this.stretchy && bl) {
                return this.getParent().getWidth(false) - 2;
            }
        }
        return this.getFontMetrics().stringWidth(this.getText()) + n2;
    }

    public int getHeight(boolean bl) {
        return this.getAscentHeight(bl) + this.getDescentHeight(bl);
    }

    public int getAscentHeight(boolean bl) {
        if (this.getText().length() == 1 && "[()]\u222b".indexOf(this.getText().charAt(0)) >= 0) {
            if (!bl || !this.stretchy) {
                return this.getFontMetrics().getAscent();
            }
            return this.getExprAscentHeight() + 1;
        }
        if (this.getText().length() == 1 && "{}".indexOf(this.getText().charAt(0)) >= 0) {
            if (!bl || !this.stretchy) {
                return this.getFontMetrics().getAscent();
            }
            int n = this.getFontMetrics().getAscent();
            int n2 = this.getExprHeight() / n + 1;
            if ("{}".indexOf(this.getText().charAt(0)) >= 0 && n2 % 2 == 0) {
                return (int)((double)((n2 + 1) * n) * 0.5 + (double)this.getMiddleShift());
            }
            return (int)((double)(n2 * n) * 0.5 + (double)this.getMiddleShift());
        }
        if (this.getText().length() == 1 && "\u2211\u220f".indexOf(this.getText().charAt(0)) >= 0 && this.stretchy) {
            if (this.getExprHeight() > this.getFontMetrics().getHeight()) {
                return this.getMathBase().getFontMetrics(this.getFontSize() * 2).getAscent();
            }
            return this.getFontMetrics().getAscent();
        }
        if (this.getText().length() == 1 && "\ufe37\ufe38".indexOf(this.getText().charAt(0)) >= 0) {
            return 0;
        }
        if ("\u00af".equals(this.getText()) && this.stretchy) {
            return 3;
        }
        if ("\u223c".equals(this.getText()) && this.stretchy) {
            return this.getFontMetrics().getAscent() / 2;
        }
        if (".".equals(this.getText()) || "..".equals(this.getText()) || "...".equals(this.getText())) {
            return this.getFontMetrics().getAscent() / 2;
        }
        return this.getFontMetrics().getAscent();
    }

    public int getDescentHeight(boolean bl) {
        if (this.getText().length() == 1 && "[()]\u222b".indexOf(this.getText().charAt(0)) >= 0) {
            if (!bl || !this.stretchy) {
                return this.getFontMetrics().getDescent();
            }
            return this.getExprDescentHeight() + 1;
        }
        if (this.getText().length() == 1 && "{}".indexOf(this.getText().charAt(0)) >= 0) {
            if (!bl || !this.stretchy) {
                return this.getFontMetrics().getDescent();
            }
            int n = this.getFontMetrics().getAscent();
            int n2 = this.getExprHeight() / n + 1;
            if ("{}".indexOf(this.getText().charAt(0)) >= 0 && n2 % 2 == 0) {
                return (int)((double)((n2 + 1) * n) * 0.5 - (double)this.getMiddleShift());
            }
            return (int)((double)(n2 * n) * 0.5 - (double)this.getMiddleShift());
        }
        if (this.getText().length() == 1 && "\u2211\u220f".indexOf(this.getText().charAt(0)) >= 0 && this.stretchy) {
            if (this.getExprHeight() > this.getFontMetrics().getHeight()) {
                return this.getMathBase().getFontMetrics(this.getFontSize() * 2).getDescent();
            }
            return this.getFontMetrics().getDescent();
        }
        if (this.getText().length() == 1 && "\ufe37\ufe38".indexOf(this.getText().charAt(0)) >= 0) {
            return this.getFontMetrics().stringWidth("}");
        }
        return this.getFontMetrics().getDescent();
    }
}

