/*
 * Decompiled with CFR 0.152.
 */
package jaxe.wxs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jaxe.JaxeException;
import jaxe.wxs.JaxeWXS;
import jaxe.wxs.ToutElement;
import jaxe.wxs.WXSAnnotated;
import jaxe.wxs.WXSAttribute;
import jaxe.wxs.WXSAttributeGroup;
import jaxe.wxs.WXSComplexType;
import jaxe.wxs.WXSElement;
import jaxe.wxs.WXSGroup;
import jaxe.wxs.WXSImport;
import jaxe.wxs.WXSInclude;
import jaxe.wxs.WXSRedefine;
import jaxe.wxs.WXSSimpleType;
import jaxe.wxs.WXSThing;
import jaxe.wxs.WXSType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WXSSchema
implements WXSThing {
    protected ArrayList<WXSInclude> includes;
    protected ArrayList<WXSImport> imports;
    protected ArrayList<WXSRedefine> redefines;
    protected LinkedHashMap<String, WXSSimpleType> simpleTypes;
    protected LinkedHashMap<String, WXSComplexType> complexTypes;
    protected LinkedHashMap<String, WXSGroup> groups;
    protected LinkedHashMap<String, WXSAttributeGroup> attributeGroups;
    protected LinkedHashMap<String, WXSElement> elements;
    protected LinkedHashMap<String, WXSAttribute> attributes;
    protected String targetNamespace = null;
    protected String attributeFormDefault = null;
    protected String elementFormDefault = null;
    protected URL url;
    protected JaxeWXS jwxs;
    protected ArrayList<WXSSchema> schemasInclu;
    protected WXSSchema schemaParent;
    protected HashMap<String, String> espaceVersPrefixe;

    public WXSSchema(Element element, URL uRL, JaxeWXS jaxeWXS, WXSSchema wXSSchema) {
        Object object;
        Object object2;
        this.url = uRL;
        this.jwxs = jaxeWXS;
        this.schemaParent = wXSSchema;
        this.includes = new ArrayList();
        this.imports = new ArrayList();
        this.redefines = new ArrayList();
        this.simpleTypes = new LinkedHashMap();
        this.complexTypes = new LinkedHashMap();
        this.groups = new LinkedHashMap();
        this.attributeGroups = new LinkedHashMap();
        this.elements = new LinkedHashMap();
        this.attributes = new LinkedHashMap();
        this.schemasInclu = new ArrayList();
        for (object2 = element.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            WXSThing wXSThing;
            if (!(object2 instanceof Element)) continue;
            if ("include".equals(object2.getLocalName())) {
                this.includes.add(new WXSInclude((Element)object2, this));
                continue;
            }
            if ("import".equals(object2.getLocalName())) {
                this.imports.add(new WXSImport((Element)object2, this));
                continue;
            }
            if ("redefine".equals(object2.getLocalName())) {
                wXSThing = new WXSRedefine((Element)object2, this);
                this.redefines.add((WXSRedefine)wXSThing);
                for (WXSThing object3 : ((WXSRedefine)wXSThing).getRedefinables()) {
                    if (object3 instanceof WXSSimpleType) {
                        object = (WXSSimpleType)object3;
                        this.simpleTypes.put(((WXSSimpleType)object).getName(), (WXSSimpleType)object);
                        continue;
                    }
                    if (object3 instanceof WXSComplexType) {
                        object = (WXSComplexType)object3;
                        this.complexTypes.put(((WXSComplexType)object).getName(), (WXSComplexType)object);
                        continue;
                    }
                    if (object3 instanceof WXSGroup) {
                        object = (WXSGroup)object3;
                        this.groups.put(((WXSGroup)object).getName(), (WXSGroup)object);
                        continue;
                    }
                    if (!(object3 instanceof WXSAttributeGroup)) continue;
                    object = (WXSAttributeGroup)object3;
                    this.attributeGroups.put(((WXSAttributeGroup)object).getName(), (WXSAttributeGroup)object);
                }
                continue;
            }
            if ("simpleType".equals(object2.getLocalName())) {
                wXSThing = new WXSSimpleType((Element)object2, null, this);
                this.simpleTypes.put(((WXSSimpleType)wXSThing).getName(), (WXSSimpleType)wXSThing);
                continue;
            }
            if ("complexType".equals(object2.getLocalName())) {
                wXSThing = new WXSComplexType((Element)object2, null, this);
                this.complexTypes.put(((WXSComplexType)wXSThing).getName(), (WXSComplexType)wXSThing);
                continue;
            }
            if ("group".equals(object2.getLocalName())) {
                wXSThing = new WXSGroup((Element)object2, null, this);
                this.groups.put(((WXSGroup)wXSThing).getName(), (WXSGroup)wXSThing);
                continue;
            }
            if ("attributeGroup".equals(object2.getLocalName())) {
                wXSThing = new WXSAttributeGroup((Element)object2, null, this);
                this.attributeGroups.put(((WXSAttributeGroup)wXSThing).getName(), (WXSAttributeGroup)wXSThing);
                continue;
            }
            if ("element".equals(object2.getLocalName())) {
                wXSThing = new WXSElement((Element)object2, null, this);
                this.elements.put(((WXSElement)wXSThing).getName(), (WXSElement)wXSThing);
                continue;
            }
            if (!"attribute".equals(object2.getLocalName())) continue;
            wXSThing = new WXSAttribute((Element)object2, null, this);
            this.attributes.put(((WXSAttribute)wXSThing).getName(), (WXSAttribute)wXSThing);
        }
        if (element.getAttributeNode("targetNamespace") != null) {
            this.targetNamespace = element.getAttribute("targetNamespace");
            if ("".equals(this.targetNamespace)) {
                this.targetNamespace = null;
            }
        }
        if (element.getAttributeNode("attributeFormDefault") != null) {
            this.attributeFormDefault = element.getAttribute("attributeFormDefault");
        }
        if (element.getAttributeNode("elementFormDefault") != null) {
            this.elementFormDefault = element.getAttribute("elementFormDefault");
        }
        this.espaceVersPrefixe = new HashMap();
        object2 = element.getAttributes();
        for (int i = 0; i < object2.getLength(); ++i) {
            Node node = object2.item(i);
            String string = node.getNodeName();
            object = node.getNodeValue();
            if (!string.startsWith("xmlns:")) continue;
            String string2 = string.substring(6);
            this.espaceVersPrefixe.put((String)object, string2);
        }
    }

    protected void inclusions() throws JaxeException {
        for (WXSInclude wXSThing : this.includes) {
            wXSThing.inclusions(this);
        }
        for (WXSImport wXSImport : this.imports) {
            wXSImport.inclusions(this);
        }
        for (WXSRedefine wXSRedefine : this.redefines) {
            wXSRedefine.inclusions(this);
        }
    }

    public Collection<WXSElement> getTopElements() {
        return this.elements.values();
    }

    public Collection<WXSAttribute> getTopAttributes() {
        return this.attributes.values();
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public URL getURL() {
        return this.url;
    }

    protected WXSSchema nouveauSchemaInclu(String string, String string2, WXSSchema wXSSchema) throws JaxeException {
        WXSSchema wXSSchema2 = this.jwxs.nouveauSchemaInclu(this.url, string, string2, wXSSchema);
        if (wXSSchema2 != null && !this.schemasInclu.contains(wXSSchema2)) {
            this.schemasInclu.add(wXSSchema2);
        }
        return wXSSchema2;
    }

    public void resoudreReferences() {
        for (WXSSimpleType wXSAnnotated2 : this.simpleTypes.values()) {
            wXSAnnotated2.resoudreReferences(this, wXSAnnotated2.getParent() instanceof WXSRedefine ? wXSAnnotated2 : null);
        }
        Iterator<WXSAnnotated> iterator = this.complexTypes.values().iterator();
        while (iterator.hasNext()) {
            WXSComplexType wXSComplexType;
            wXSComplexType.resoudreReferences(this, (wXSComplexType = (WXSComplexType)iterator.next()).getParent() instanceof WXSRedefine ? wXSComplexType : null);
        }
        iterator = this.groups.values().iterator();
        while (iterator.hasNext()) {
            WXSGroup wXSGroup;
            wXSGroup.resoudreReferences(this, (wXSGroup = (WXSGroup)iterator.next()).getParent() instanceof WXSRedefine ? wXSGroup : null);
        }
        iterator = this.attributeGroups.values().iterator();
        while (iterator.hasNext()) {
            WXSAttributeGroup wXSAttributeGroup;
            wXSAttributeGroup.resoudreReferences(this, (wXSAttributeGroup = (WXSAttributeGroup)iterator.next()).getParent() instanceof WXSRedefine ? wXSAttributeGroup : null);
        }
        for (WXSElement wXSElement : this.elements.values()) {
            wXSElement.resoudreReferences(this, null);
        }
        for (WXSAttribute wXSAttribute : this.attributes.values()) {
            wXSAttribute.resoudreReferences(this);
        }
    }

    public String prefixeEspace(String string) {
        return this.espaceVersPrefixe.get(string);
    }

    public String espacePrefixe(String string) {
        if (string == null) {
            return null;
        }
        Set<Map.Entry<String, String>> set = this.espaceVersPrefixe.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (!string.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<WXSElement> listeTousElements() {
        LinkedHashSet<WXSElement> linkedHashSet = new LinkedHashSet<WXSElement>();
        for (WXSComplexType wXSAnnotated : this.complexTypes.values()) {
            linkedHashSet.addAll(wXSAnnotated.listeTousElements());
        }
        for (WXSGroup wXSGroup : this.groups.values()) {
            linkedHashSet.addAll(wXSGroup.listeTousElements());
        }
        for (WXSElement wXSElement : this.elements.values()) {
            linkedHashSet.addAll(wXSElement.listeTousElements());
        }
        return linkedHashSet;
    }

    public Set<ToutElement> listeAny(String string) {
        return this.jwxs.listeAny(string, this.targetNamespace);
    }

    public WXSElement resoudreReferenceElement(String string, String string2) {
        return (WXSElement)this.resoudreReference(string, string2, null, null, WXSElement.class);
    }

    public WXSType resoudreReferenceType(String string, String string2, WXSThing wXSThing) {
        return (WXSType)((Object)this.resoudreReference(string, string2, null, wXSThing, WXSType.class));
    }

    public WXSGroup resoudreReferenceGroupe(String string, String string2, WXSThing wXSThing) {
        return (WXSGroup)this.resoudreReference(string, string2, null, wXSThing, WXSGroup.class);
    }

    public WXSAttributeGroup resoudreReferenceGroupeAttributs(String string, String string2, WXSThing wXSThing) {
        return (WXSAttributeGroup)this.resoudreReference(string, string2, null, wXSThing, WXSAttributeGroup.class);
    }

    public WXSAttribute resoudreReferenceAttribut(String string, String string2) {
        return (WXSAttribute)this.resoudreReference(string, string2, null, null, WXSAttribute.class);
    }

    protected WXSThing resoudreReference(String string, String string2, HashSet<WXSSchema> hashSet, WXSThing wXSThing, Class clazz) {
        Object object;
        if (string == null) {
            return null;
        }
        HashSet<WXSSchema> hashSet2 = null;
        if (!(this.schemaParent == null || hashSet != null && hashSet.contains(this.schemaParent))) {
            if (hashSet2 == null) {
                hashSet2 = hashSet == null ? new HashSet() : hashSet;
                hashSet2.add(this);
            }
            if ((object = this.schemaParent.resoudreReference(string, string2, hashSet2, wXSThing, clazz)) != null) {
                return object;
            }
        }
        if (string2 == null && this.targetNamespace == null || string2 != null && string2.equals(this.targetNamespace)) {
            if (clazz == WXSElement.class) {
                object = this.elements.get(string);
            } else if (clazz == WXSType.class) {
                object = this.complexTypes.get(string);
                if (object != null && object != wXSThing) {
                    return object;
                }
                object = this.simpleTypes.get(string);
            } else {
                object = clazz == WXSGroup.class ? (WXSThing)this.groups.get(string) : (clazz == WXSAttributeGroup.class ? (WXSThing)this.attributeGroups.get(string) : (clazz == WXSAttribute.class ? (WXSThing)this.attributes.get(string) : null));
            }
            if (object != null && object != wXSThing) {
                return object;
            }
        }
        for (WXSSchema wXSSchema : this.schemasInclu) {
            WXSThing wXSThing2;
            if (hashSet != null && hashSet.contains(wXSSchema)) continue;
            if (hashSet2 == null) {
                hashSet2 = hashSet == null ? new HashSet() : hashSet;
                hashSet2.add(this);
            }
            if ((wXSThing2 = wXSSchema.resoudreReference(string, string2, hashSet2, wXSThing, clazz)) == null) continue;
            return wXSThing2;
        }
        return null;
    }

    public String titreElement(Element element) {
        return this.jwxs.titreElement(element);
    }
}

