/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.CodingMode;
import com.fluendo.jheora.Playback;
import com.fluendo.jheora.Recon;
import com.fluendo.jheora.iDCT;
import com.fluendo.utils.MemUtils;

public class DCTDecode {
    private static final int PUR = 8;
    private static final int PU = 4;
    private static final int PUL = 2;
    private static final int PL = 1;
    private static final int[] ModeUsesMC = new int[]{0, 0, 1, 1, 1, 0, 1, 1};
    private static final short[][] pc = new short[][]{{0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 1, 1}, {0, 1, 0, 0, 0, 0}, {29, -26, 29, 0, 5, 31}, {1, 0, 0, 0, 0, 0}, {75, 53, 0, 0, 7, 127}, {1, 1, 0, 0, 1, 1}, {75, 0, 53, 0, 7, 127}, {1, 0, 0, 0, 0, 0}, {75, 0, 53, 0, 7, 127}, {3, 10, 3, 0, 4, 15}, {29, -26, 29, 0, 5, 31}};
    private static final int[] bc_mask = new int[]{15, 12, 1, 0, 7, 4, 1, 0};
    private static final short[] Mode2Frame = new short[]{1, 0, 1, 1, 1, 2, 2, 1};
    private short[] ReconDataBuffer = new short[64];
    private int[] v = new int[4];
    private int[] fn = new int[4];
    private short[] Last = new short[3];
    private iDCT idct = new iDCT();

    private void ExpandKFBlock(Playback playback, int n) {
        short[] sArray;
        int n2;
        byte by = playback.FragQs[n];
        if (n < playback.YPlaneFragments) {
            n2 = playback.YStride;
            sArray = playback.info.dequant_tables[0][0][playback.frameQIS[by]];
        } else if (n < playback.YPlaneFragments + playback.UVPlaneFragments) {
            n2 = playback.UVStride;
            sArray = playback.info.dequant_tables[0][1][playback.frameQIS[by]];
        } else {
            n2 = playback.UVStride;
            sArray = playback.info.dequant_tables[0][2][playback.frameQIS[by]];
        }
        short[] sArray2 = playback.QFragData[n];
        switch (playback.FragCoefEOB[n]) {
            case 0: 
            case 1: {
                this.idct.IDct1(sArray2, sArray, this.ReconDataBuffer);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.idct.IDct10(sArray2, sArray, this.ReconDataBuffer);
                break;
            }
            default: {
                this.idct.IDctSlow(sArray2, sArray, this.ReconDataBuffer);
            }
        }
        int n3 = playback.recon_pixel_index_table[n];
        Recon.ReconIntra(playback.ThisFrameRecon, n3, this.ReconDataBuffer, n2);
    }

    private void ExpandBlock(Playback playback, int n) {
        short[] sArray;
        int n2;
        int n3;
        int n4;
        byte by = playback.FragQs[n];
        CodingMode codingMode = playback.getFrameType() == 0 ? CodingMode.CODE_INTRA : playback.FragCodingMethod[n];
        if (n < playback.YPlaneFragments) {
            n4 = playback.YStride;
            n3 = 1;
            n2 = 1;
            sArray = codingMode == CodingMode.CODE_INTRA ? playback.info.dequant_tables[0][0][playback.frameQIS[by]] : playback.info.dequant_tables[1][0][playback.frameQIS[by]];
        } else {
            n4 = playback.UVStride;
            n3 = 2;
            n2 = 3;
            sArray = n < playback.YPlaneFragments + playback.UVPlaneFragments ? (codingMode == CodingMode.CODE_INTRA ? playback.info.dequant_tables[0][1][playback.frameQIS[by]] : playback.info.dequant_tables[1][1][playback.frameQIS[by]]) : (codingMode == CodingMode.CODE_INTRA ? playback.info.dequant_tables[0][2][playback.frameQIS[by]] : playback.info.dequant_tables[1][2][playback.frameQIS[by]]);
        }
        short[] sArray2 = playback.QFragData[n];
        switch (playback.FragCoefEOB[n]) {
            case 0: 
            case 1: {
                this.idct.IDct1(sArray2, sArray, this.ReconDataBuffer);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.idct.IDct10(sArray2, sArray, this.ReconDataBuffer);
                break;
            }
            default: {
                this.idct.IDctSlow(sArray2, sArray, this.ReconDataBuffer);
            }
        }
        int n5 = playback.recon_pixel_index_table[n];
        if (codingMode == CodingMode.CODE_INTER_NO_MV) {
            Recon.ReconInter(playback.ThisFrameRecon, n5, playback.LastFrameRecon, n5, this.ReconDataBuffer, n4);
        } else if (ModeUsesMC[codingMode.getValue()] != 0) {
            int n6 = 0;
            int n7 = 0;
            int n8 = playback.FragMVect[n].x;
            if (n8 > 0) {
                n7 = n8 >> n3;
                if ((n8 & n2) != 0) {
                    n6 = 1;
                }
            } else if (n8 < 0) {
                n7 = -(-n8 >> n3);
                if ((-n8 & n2) != 0) {
                    n6 = -1;
                }
            }
            if ((n8 = playback.FragMVect[n].y) > 0) {
                n7 += (n8 >> n3) * n4;
                if ((n8 & n2) != 0) {
                    n6 += n4;
                }
            } else if (n8 < 0) {
                n7 -= (-n8 >> n3) * n4;
                if ((-n8 & n2) != 0) {
                    n6 -= n4;
                }
            }
            int n9 = n5 + n7;
            short[] sArray3 = codingMode == CodingMode.CODE_GOLDEN_MV ? playback.GoldenFrame : playback.LastFrameRecon;
            if (n6 == 0) {
                Recon.ReconInter(playback.ThisFrameRecon, n5, sArray3, n9, this.ReconDataBuffer, n4);
            } else {
                Recon.ReconInterHalfPixel2(playback.ThisFrameRecon, n5, sArray3, n9, sArray3, n9 + n6, this.ReconDataBuffer, n4);
            }
        } else if (codingMode == CodingMode.CODE_USING_GOLDEN) {
            Recon.ReconInter(playback.ThisFrameRecon, n5, playback.GoldenFrame, n5, this.ReconDataBuffer, n4);
        } else {
            Recon.ReconIntra(playback.ThisFrameRecon, n5, this.ReconDataBuffer, n4);
        }
    }

    private void UpdateUMV_HBorders(Playback playback, short[] sArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (n == 0) {
            n6 = playback.YStride * 7;
            n5 = playback.YStride;
            n4 = 16;
            n3 = playback.YPlaneFragments;
            n2 = playback.HFragments;
        } else {
            n6 = playback.UVStride * 7;
            n5 = playback.UVStride;
            n4 = 8;
            n3 = playback.UVPlaneFragments;
            n2 = playback.HFragments / 2;
        }
        int n7 = playback.recon_pixel_index_table[n];
        short[] sArray2 = sArray;
        int n8 = n7 - n4;
        short[] sArray3 = sArray2;
        int n9 = n8 - n4 * n5;
        n7 = playback.recon_pixel_index_table[n + n3 - n2] + n6;
        short[] sArray4 = sArray;
        int n10 = n7 - n4;
        short[] sArray5 = sArray4;
        int n11 = n10 + n5;
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(sArray2, n8, sArray3, n9, n5);
            System.arraycopy(sArray4, n10, sArray5, n11, n5);
            n9 += n5;
            n11 += n5;
        }
    }

    private void UpdateUMV_VBorders(Playback playback, short[] sArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (n == 0) {
            n5 = playback.YStride;
            n4 = 16;
            n3 = playback.HFragments;
            n2 = playback.info.height;
        } else {
            n5 = playback.UVStride;
            n4 = 8;
            n3 = playback.HFragments / 2;
            n2 = playback.info.height / 2;
        }
        int n6 = playback.recon_pixel_index_table[n];
        short[] sArray2 = sArray;
        int n7 = n6;
        short[] sArray3 = sArray;
        int n8 = n6 - n4;
        n6 = playback.recon_pixel_index_table[n + n3 - 1] + 7;
        short[] sArray4 = sArray;
        int n9 = n6;
        short[] sArray5 = sArray;
        int n10 = n6 + 1;
        for (int i = 0; i < n2; ++i) {
            MemUtils.set(sArray3, n8, (int)sArray2[n7], n4);
            MemUtils.set(sArray5, n10, (int)sArray4[n9], n4);
            n8 += n5;
            n10 += n5;
            n7 += n5;
            n9 += n5;
        }
    }

    private void UpdateUMVBorder(Playback playback, short[] sArray) {
        int n = 0;
        this.UpdateUMV_VBorders(playback, sArray, n);
        this.UpdateUMV_HBorders(playback, sArray, n);
        n = playback.YPlaneFragments;
        this.UpdateUMV_VBorders(playback, sArray, n);
        this.UpdateUMV_HBorders(playback, sArray, n);
        n = playback.YPlaneFragments + playback.UVPlaneFragments;
        this.UpdateUMV_VBorders(playback, sArray, n);
        this.UpdateUMV_HBorders(playback, sArray, n);
    }

    private void CopyRecon(Playback playback, short[] sArray, short[] sArray2) {
        int n;
        int n2;
        int n3 = playback.YStride;
        for (n2 = 0; n2 < playback.YPlaneFragments; ++n2) {
            if (playback.display_fragments[n2] == 0) continue;
            n = playback.recon_pixel_index_table[n2];
            Recon.CopyBlock(sArray2, sArray, n, n3);
        }
        n3 = playback.UVStride;
        for (n2 = playback.YPlaneFragments; n2 < playback.UnitFragments; ++n2) {
            if (playback.display_fragments[n2] == 0) continue;
            n = playback.recon_pixel_index_table[n2];
            Recon.CopyBlock(sArray2, sArray, n, n3);
        }
    }

    private void CopyNotRecon(Playback playback, short[] sArray, short[] sArray2) {
        int n;
        int n2;
        int n3 = playback.YStride;
        for (n2 = 0; n2 < playback.YPlaneFragments; ++n2) {
            if (playback.display_fragments[n2] != 0) continue;
            n = playback.recon_pixel_index_table[n2];
            Recon.CopyBlock(sArray2, sArray, n, n3);
        }
        n3 = playback.UVStride;
        for (n2 = playback.YPlaneFragments; n2 < playback.UnitFragments; ++n2) {
            if (playback.display_fragments[n2] != 0) continue;
            n = playback.recon_pixel_index_table[n2];
            Recon.CopyBlock(sArray2, sArray, n, n3);
        }
    }

    public void ExpandToken(short[] sArray, byte[] byArray, int n, int n2, int n3) {
        if (n2 >= 23) {
            if (n2 < 30) {
                if (n2 < 28) {
                    int n4 = n;
                    byArray[n4] = (byte)(byArray[n4] + (byte)(n2 - 23 + 1));
                    sArray[byArray[n]] = (short)(-(((n3 & 1) << 1) - 1));
                } else if (n2 == 28) {
                    int n5 = n;
                    byArray[n5] = (byte)(byArray[n5] + (6 + (n3 & 3)));
                    sArray[byArray[n]] = (short)(-(((n3 & 4) >> 1) - 1));
                } else {
                    int n6 = n;
                    byArray[n6] = (byte)(byArray[n6] + (10 + (n3 & 7)));
                    sArray[byArray[n]] = (short)(-(((n3 & 8) >> 2) - 1));
                }
            } else if (n2 == 30) {
                int n7 = n;
                byArray[n7] = (byte)(byArray[n7] + 1);
                sArray[byArray[n]] = (short)((2 + (n3 & 1)) * -((n3 & 2) - 1));
            } else {
                int n8 = n;
                byArray[n8] = (byte)(byArray[n8] + (2 + (n3 & 1)));
                sArray[byArray[n]] = (short)((2 + ((n3 & 2) >> 1)) * -(((n3 & 4) >> 1) - 1));
            }
            int n9 = n;
            byArray[n9] = (byte)(byArray[n9] + 1);
        } else if (n2 == 7) {
            int n10 = n;
            byArray[n10] = (byte)(byArray[n10] + (n3 + 1));
        } else if (n2 == 8) {
            int n11 = n;
            byArray[n11] = (byte)(byArray[n11] + (n3 + 1));
        } else if (n2 < 13) {
            switch (n2) {
                case 9: {
                    sArray[byArray[n]] = 1;
                    break;
                }
                case 10: {
                    sArray[byArray[n]] = -1;
                    break;
                }
                case 11: {
                    sArray[byArray[n]] = 2;
                    break;
                }
                case 12: {
                    sArray[byArray[n]] = -2;
                }
            }
            int n12 = n;
            byArray[n12] = (byte)(byArray[n12] + 1);
        } else {
            if (n2 < 17) {
                sArray[byArray[n]] = (short)(((n2 -= 13) + 3) * -((n3 << 1) - 1));
            } else if (n2 == 17) {
                sArray[byArray[n]] = (short)((7 + (n3 & 1)) * -((n3 & 2) - 1));
            } else if (n2 == 18) {
                sArray[byArray[n]] = (short)((9 + (n3 & 3)) * -(((n3 & 4) >> 1) - 1));
            } else if (n2 == 19) {
                sArray[byArray[n]] = (short)((13 + (n3 & 7)) * -(((n3 & 8) >> 2) - 1));
            } else if (n2 == 20) {
                sArray[byArray[n]] = (short)((21 + (n3 & 0xF)) * -(((n3 & 0x10) >> 3) - 1));
            } else if (n2 == 21) {
                sArray[byArray[n]] = (short)((37 + (n3 & 0x1F)) * -(((n3 & 0x20) >> 4) - 1));
            } else if (n2 == 22) {
                sArray[byArray[n]] = (short)((69 + (n3 & 0x1FF)) * -(((n3 & 0x200) >> 8) - 1));
            }
            int n13 = n;
            byArray[n13] = (byte)(byArray[n13] + 1);
        }
    }

    public void ClearDownQFragData(Playback playback) {
        for (int i = 0; i < playback.CodedBlockIndex; ++i) {
            short[] sArray = playback.QFragData[playback.CodedBlockList[i]];
            for (int j = 0; j < 64; ++j) {
                sArray[j] = 0;
            }
        }
    }

    public void ReconRefFrames(Playback playback) {
        int n = playback.HFragments;
        int n2 = playback.VFragments;
        boolean bl = playback.getFrameType() == 0;
        playback.filter.SetupLoopFilter(playback.FrameQIndex);
        for (int i = 0; i < 3; ++i) {
            int n3;
            int n4;
            switch (i) {
                case 0: {
                    n4 = 0;
                    n = playback.HFragments;
                    n2 = playback.VFragments;
                    break;
                }
                case 1: {
                    n4 = playback.YPlaneFragments;
                    n = playback.HFragments >> 1;
                    n2 = playback.VFragments >> 1;
                    break;
                }
                default: {
                    n4 = playback.YPlaneFragments + playback.UVPlaneFragments;
                    n = playback.HFragments >> 1;
                    n2 = playback.VFragments >> 1;
                }
            }
            for (n3 = 0; n3 < 3; ++n3) {
                this.Last[n3] = 0;
            }
            int n5 = n4;
            for (int j = 0; j < n2; ++j) {
                int n6 = 0;
                while (n6 < n) {
                    if (playback.display_fragments[n5] != 0 || playback.getFrameType() == 0) {
                        short s = Mode2Frame[playback.FragCodingMethod[n5].getValue()];
                        int n7 = (n6 == 0 ? 1 : 0) + ((j == 0 ? 1 : 0) << 1) + ((n6 + 1 == n ? 1 : 0) << 2);
                        this.fn[0] = n5 - 1;
                        this.fn[1] = n5 - n - 1;
                        this.fn[2] = n5 - n;
                        this.fn[3] = n5 - n + 1;
                        int n8 = 0;
                        int n9 = 0;
                        for (n3 = 0; n3 < 4; ++n3) {
                            int n10 = 1 << n3;
                            if ((bc_mask[n7] & n10) == 0 || playback.display_fragments[this.fn[n3]] == 0 || Mode2Frame[playback.FragCodingMethod[this.fn[n3]].getValue()] != s) continue;
                            this.v[n9] = playback.QFragData[this.fn[n3]][0];
                            n8 = (short)(n8 | n10);
                            ++n9;
                        }
                        if (n8 == 0) {
                            short[] sArray = playback.QFragData[n5];
                            sArray[0] = (short)(sArray[0] + this.Last[s]);
                        } else {
                            short s2 = (short)(pc[n8][0] * this.v[0]);
                            for (n3 = 1; n3 < n9; ++n3) {
                                s2 = (short)(s2 + pc[n8][n3] * this.v[n3]);
                            }
                            if (pc[n8][4] != 0) {
                                if (s2 < 0) {
                                    s2 = (short)(s2 + pc[n8][5]);
                                }
                                s2 = (short)(s2 >> pc[n8][4]);
                            }
                            if ((n8 & 7) == 7) {
                                if (Math.abs(s2 - this.v[2]) > 128) {
                                    s2 = (short)this.v[2];
                                } else if (Math.abs(s2 - this.v[0]) > 128) {
                                    s2 = (short)this.v[0];
                                } else if (Math.abs(s2 - this.v[1]) > 128) {
                                    s2 = (short)this.v[1];
                                }
                            }
                            short[] sArray = playback.QFragData[n5];
                            sArray[0] = (short)(sArray[0] + s2);
                        }
                        this.Last[s] = playback.QFragData[n5][0];
                        if (bl) {
                            this.ExpandKFBlock(playback, n5);
                        } else {
                            this.ExpandBlock(playback, n5);
                        }
                    }
                    ++n6;
                    ++n5;
                }
            }
        }
        if (playback.CodedBlockIndex > playback.UnitFragments >> 1) {
            short[] sArray = playback.ThisFrameRecon;
            playback.ThisFrameRecon = playback.LastFrameRecon;
            playback.LastFrameRecon = sArray;
            this.CopyNotRecon(playback, playback.LastFrameRecon, playback.ThisFrameRecon);
        } else {
            this.CopyRecon(playback, playback.LastFrameRecon, playback.ThisFrameRecon);
        }
        playback.filter.LoopFilter(playback);
        this.UpdateUMVBorder(playback, playback.LastFrameRecon);
        if (bl) {
            this.CopyRecon(playback, playback.GoldenFrame, playback.LastFrameRecon);
            this.UpdateUMVBorder(playback, playback.GoldenFrame);
        }
    }
}

