/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.utils.Base64Converter;
import com.fluendo.utils.Debug;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;

public class DurationScanner {
    static final int NOTDETECTED = -1;
    static final int UNKNOWN = 0;
    static final int VORBIS = 1;
    static final int THEORA = 2;
    private long contentLength = -1L;
    private long responseOffset;
    private Hashtable streaminfo = new Hashtable();
    private SyncState oy = new SyncState();
    private Page og = new Page();
    private Packet op = new Packet();

    public DurationScanner() {
        this.oy.init();
    }

    private InputStream openWithConnection(URL uRL, String string, String string2, long l) throws IOException {
        Object object;
        String string3;
        InputStream inputStream = null;
        String string4 = "Cortado";
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Connection", "Keep-Alive");
        String string5 = l != 0L && this.contentLength != -1L ? "bytes=" + l + "-" + (this.contentLength - 1L) : (l != 0L ? "bytes=" + l + "-" : null);
        if (string5 != null) {
            Debug.info("doing range: " + string5);
            uRLConnection.setRequestProperty("Range", string5);
        }
        uRLConnection.setRequestProperty("User-Agent", string4);
        if (string != null && string2 != null) {
            string3 = string + ":" + string2;
            object = Base64Converter.encode(string3.getBytes());
            uRLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
        }
        uRLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        inputStream = uRLConnection.getInputStream();
        string3 = uRLConnection.getHeaderField("Content-Range");
        if (string3 == null) {
            Debug.info("Response contained no Content-Range field, assuming offset=0");
            this.responseOffset = 0L;
        } else {
            try {
                object = new MessageFormat("bytes {0,number}-{1,number}", Locale.US);
                Object[] objectArray = ((MessageFormat)object).parse(string3);
                this.responseOffset = ((Number)objectArray[0]).longValue();
                if (this.responseOffset < 0L) {
                    this.responseOffset = 0L;
                }
                Debug.debug("Stream successfully with offset " + this.responseOffset);
            }
            catch (Exception exception) {
                Debug.info("Error parsing Content-Range header");
                this.responseOffset = 0L;
            }
        }
        this.contentLength = (long)uRLConnection.getHeaderFieldInt("Content-Length", -1) + this.responseOffset;
        return inputStream;
    }

    private void determineType(Packet packet, StreamInfo streamInfo) {
        com.fluendo.jheora.Comment comment = new com.fluendo.jheora.Comment();
        com.fluendo.jheora.Info info = new com.fluendo.jheora.Info();
        comment.clear();
        info.clear();
        int n = info.decodeHeader(comment, packet);
        if (n == 0) {
            streamInfo.decoder = info;
            streamInfo.type = 2;
            ++streamInfo.decodedHeaders;
            return;
        }
        Comment comment2 = new Comment();
        Info info2 = new Info();
        comment2.init();
        info2.init();
        n = info2.synthesis_headerin(comment2, packet);
        if (n == 0) {
            streamInfo.decoder = info2;
            streamInfo.type = 1;
            ++streamInfo.decodedHeaders;
            return;
        }
        streamInfo.type = 0;
    }

    public float getDurationForBuffer(byte[] byArray, int n) {
        float f = -1.0f;
        int n2 = this.oy.buffer(n);
        System.arraycopy(byArray, 0, this.oy.data, n2, n);
        this.oy.wrote(n);
        while (this.oy.pageout(this.og) == 1) {
            Integer n3 = new Integer(this.og.serialno());
            StreamInfo streamInfo = (StreamInfo)this.streaminfo.get(n3);
            if (streamInfo == null) {
                streamInfo = new StreamInfo();
                streamInfo.streamstate = new StreamState();
                streamInfo.streamstate.init(this.og.serialno());
                this.streaminfo.put(n3, streamInfo);
                Debug.info("DurationScanner: created StreamState for stream no. " + n3);
            }
            streamInfo.streamstate.pagein(this.og);
            block5: while (streamInfo.streamstate.packetout(this.op) == 1) {
                int n4 = streamInfo.type;
                if (n4 == -1) {
                    this.determineType(this.op, streamInfo);
                    streamInfo.startgranule = this.og.granulepos();
                }
                switch (n4) {
                    case 1: {
                        Object object = (Info)streamInfo.decoder;
                        float f2 = (float)(this.og.granulepos() - streamInfo.startgranule) / (float)((Info)object).rate;
                        if (!(f2 > f)) continue block5;
                        f = f2;
                        break;
                    }
                    case 2: {
                        Object object = (com.fluendo.jheora.Info)streamInfo.decoder;
                    }
                }
            }
        }
        return f;
    }

    public float getDurationForURL(URL uRL, String string, String string2) {
        try {
            float f;
            long l;
            int n = 24576;
            int n2 = 131072;
            float f2 = 0.0f;
            byte[] byArray = new byte[1024];
            InputStream inputStream = this.openWithConnection(uRL, string, string2, 0L);
            int n3 = 0;
            n3 = inputStream.read(byArray);
            for (l = 0L; l < (long)n && n3 > 0; l += (long)n3) {
                f = this.getDurationForBuffer(byArray, n3);
                f2 = f > f2 ? f : f2;
                n3 = inputStream.read(byArray);
            }
            inputStream.close();
            inputStream = this.openWithConnection(uRL, string, string2, this.contentLength - (long)n2);
            if (this.responseOffset == 0L) {
                Debug.warning("DurationScanner: Couldn't complete duration scan due to failing range requests!");
                return -1.0f;
            }
            n3 = inputStream.read(byArray);
            while (n3 > 0 && l < (long)((n + n2) * 2)) {
                l += (long)n3;
                f = this.getDurationForBuffer(byArray, n3);
                f2 = f > f2 ? f : f2;
                n3 = inputStream.read(byArray);
            }
            return f2;
        }
        catch (IOException iOException) {
            Debug.error(iOException.toString());
            return -1.0f;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        URL uRL = new URL(stringArray[0]);
        System.out.println(new DurationScanner().getDurationForURL(uRL, null, null));
    }

    private class StreamInfo {
        public Object decoder;
        public int decodedHeaders = 0;
        public int type = -1;
        public long startgranule;
        public StreamState streamstate;
        public boolean ready = false;

        private StreamInfo() {
        }
    }
}

