/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.fluendo.jkate.Bitmap;
import com.fluendo.jkate.Bitwise;
import com.fluendo.jkate.Color;
import com.fluendo.jkate.Comment;
import com.fluendo.jkate.Curve;
import com.fluendo.jkate.FontMapping;
import com.fluendo.jkate.FontRange;
import com.fluendo.jkate.KateBadPacketException;
import com.fluendo.jkate.KateBitmapType;
import com.fluendo.jkate.KateCurveType;
import com.fluendo.jkate.KateException;
import com.fluendo.jkate.KateMarkupType;
import com.fluendo.jkate.KateMotionMapping;
import com.fluendo.jkate.KateMotionSemantics;
import com.fluendo.jkate.KateSpaceMetric;
import com.fluendo.jkate.KateTextDirectionality;
import com.fluendo.jkate.KateTextEncoding;
import com.fluendo.jkate.KateWrapMode;
import com.fluendo.jkate.Motion;
import com.fluendo.jkate.Palette;
import com.fluendo.jkate.RLE;
import com.fluendo.jkate.Region;
import com.fluendo.jkate.Style;
import com.fluendo.utils.Debug;
import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;

public class Info {
    public int bitstream_version_major = -1;
    public int bitstream_version_minor = -1;
    public KateTextEncoding text_encoding;
    public KateTextDirectionality text_directionality;
    public int num_headers = 0;
    public int granule_shift;
    public int gps_numerator;
    public int gps_denominator;
    public byte[] language;
    public byte[] category;
    public Region[] regions;
    public Style[] styles;
    public Curve[] curves;
    public Motion[] motions;
    public Palette[] palettes;
    public Bitmap[] bitmaps;
    public FontRange[] font_ranges;
    public FontMapping[] font_mappings;
    public KateMarkupType markup_type;
    public int original_canvas_width;
    public int original_canvas_height;
    private int probe = 0;

    private static int read_canvas_size(Buffer buffer) {
        int n = buffer.read(8) | buffer.read(8) << 8;
        int n2 = n >> 4;
        int n3 = n & 0xF;
        return n2 << n3;
    }

    private int unpackInfo(Buffer buffer) {
        this.bitstream_version_major = (byte)buffer.read(8);
        this.bitstream_version_minor = (byte)buffer.read(8);
        Debug.info("Kate bitstream v" + this.bitstream_version_major + "." + this.bitstream_version_minor);
        if (this.bitstream_version_major > 0) {
            return -9;
        }
        this.num_headers = buffer.read(8);
        if (this.num_headers < 1) {
            return -6;
        }
        int n = buffer.read(8);
        if (n != 0) {
            return -6;
        }
        try {
            this.text_encoding = KateTextEncoding.CreateTextEncoding(n);
            this.text_directionality = KateTextDirectionality.CreateTextDirectionality(buffer.read(8));
        }
        catch (KateException kateException) {
            return -6;
        }
        int n2 = buffer.read(8);
        if (this.bitstream_version_major == 0 && this.bitstream_version_minor < 3 && n2 != 0) {
            return -6;
        }
        this.granule_shift = buffer.read(8);
        this.original_canvas_width = Info.read_canvas_size(buffer);
        this.original_canvas_height = Info.read_canvas_size(buffer);
        n2 = Bitwise.read32(buffer);
        if (this.bitstream_version_major == 0 && this.bitstream_version_minor < 3 && n2 != 0) {
            return -6;
        }
        this.gps_numerator = Bitwise.read32(buffer);
        this.gps_denominator = Bitwise.read32(buffer);
        if (this.granule_shift >= 64) {
            return -6;
        }
        if (this.gps_numerator == 0 || this.gps_denominator == 0) {
            return -6;
        }
        this.language = new byte[16];
        Bitwise.readbuf(buffer, this.language, 16);
        if (this.language[15] != 0) {
            return -6;
        }
        this.category = new byte[16];
        Bitwise.readbuf(buffer, this.category, 16);
        if (this.category[15] != 0) {
            return -6;
        }
        if (buffer.read(1) != -1) {
            return -6;
        }
        return 0;
    }

    static int checkEOP(Buffer buffer) {
        int n = 7 & 8 - (buffer.bits() & 7);
        if (n > 0 && buffer.read(n) != 0) {
            return -6;
        }
        if (buffer.look1() != -1) {
            return -6;
        }
        return 0;
    }

    private int unpackComment(Comment comment, Buffer buffer) {
        int n = Bitwise.read32(buffer);
        if (n < 0) {
            return -6;
        }
        byte[] byArray = new byte[n];
        Bitwise.readbuf(buffer, byArray, n);
        comment.vendor = new String(byArray);
        int n2 = Bitwise.read32(buffer);
        if (n2 < 0) {
            comment.clear();
            return -6;
        }
        comment.user_comments = new String[n2];
        for (int i = 0; i < n2; ++i) {
            n = Bitwise.read32(buffer);
            if (n < 0) {
                comment.clear();
                return -6;
            }
            byArray = new byte[n];
            Bitwise.readbuf(buffer, byArray, n);
            comment.user_comments[i] = new String(byArray);
        }
        return 0;
    }

    public Region unpackRegion(Buffer buffer) throws KateException {
        Region region = new Region();
        region.metric = KateSpaceMetric.CreateSpaceMetric(buffer.read(8));
        region.x = Bitwise.read32v(buffer);
        region.y = Bitwise.read32v(buffer);
        region.w = Bitwise.read32v(buffer);
        region.h = Bitwise.read32v(buffer);
        region.style = Bitwise.read32v(buffer);
        if ((this.bitstream_version_major << 8 | this.bitstream_version_minor) >= 2) {
            Bitwise.read32v(buffer);
            region.clip = buffer.read1() != 0;
        } else {
            region.clip = false;
        }
        Bitwise.skipWarp(buffer);
        return region;
    }

    private int unpackRegions(Buffer buffer) {
        int n = Bitwise.read32v(buffer);
        if (n < 0) {
            return -6;
        }
        this.regions = new Region[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.regions[i] = this.unpackRegion(buffer);
                continue;
            }
            catch (KateException kateException) {
                this.regions = null;
                return -6;
            }
        }
        Bitwise.skipWarp(buffer);
        return Info.checkEOP(buffer);
    }

    private Color unpackColor(Buffer buffer) {
        Color color = new Color();
        color.r = (byte)buffer.read(8);
        color.g = (byte)buffer.read(8);
        color.b = (byte)buffer.read(8);
        color.a = (byte)buffer.read(8);
        return color;
    }

    public Style unpackStyle(Buffer buffer) throws KateException {
        Style style = new Style();
        double[][] dArray = Bitwise.readFloats(buffer, 8, 1);
        int n = 0;
        style.halign = dArray[0][n++];
        style.valign = dArray[0][n++];
        style.font_width = dArray[0][n++];
        style.font_height = dArray[0][n++];
        style.left_margin = dArray[0][n++];
        style.top_margin = dArray[0][n++];
        style.right_margin = dArray[0][n++];
        style.bottom_margin = dArray[0][n++];
        style.text_color = this.unpackColor(buffer);
        style.background_color = this.unpackColor(buffer);
        style.draw_color = this.unpackColor(buffer);
        style.font_metric = KateSpaceMetric.CreateSpaceMetric(buffer.read(8));
        style.margin_metric = KateSpaceMetric.CreateSpaceMetric(buffer.read(8));
        style.bold = buffer.read1() != 0;
        style.italics = buffer.read1() != 0;
        style.underline = buffer.read1() != 0;
        boolean bl = style.strike = buffer.read1() != 0;
        if ((this.bitstream_version_major << 8 | this.bitstream_version_minor) >= 2) {
            Bitwise.read32v(buffer);
            style.justify = buffer.read1() != 0;
            int n2 = Bitwise.read32v(buffer);
            if (n2 < 0) {
                throw new KateBadPacketException();
            }
            byte[] byArray = new byte[n2];
            Bitwise.readbuf(buffer, byArray, n2);
            style.font = new String(byArray);
        } else {
            style.justify = false;
            style.font = null;
        }
        if ((this.bitstream_version_major << 8 | this.bitstream_version_minor) >= 4) {
            Bitwise.read32v(buffer);
            style.wrap_mode = KateWrapMode.CreateWrapMode(Bitwise.read32v(buffer));
        } else {
            style.wrap_mode = KateWrapMode.kate_wrap_word;
        }
        Bitwise.skipWarp(buffer);
        return style;
    }

    private int unpackStyles(Buffer buffer) {
        int n = Bitwise.read32v(buffer);
        if (n < 0) {
            return -6;
        }
        this.styles = new Style[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.styles[i] = this.unpackStyle(buffer);
                continue;
            }
            catch (KateException kateException) {
                this.styles = null;
                return -6;
            }
        }
        Bitwise.skipWarp(buffer);
        return Info.checkEOP(buffer);
    }

    private Curve unpackCurve(Buffer buffer) throws KateException {
        Curve curve = new Curve();
        curve.type = KateCurveType.CreateCurveType(buffer.read(8));
        curve.npts = Bitwise.read32v(buffer);
        if (curve.npts < 0) {
            throw new KateBadPacketException();
        }
        Bitwise.skipWarp(buffer);
        curve.pts = Bitwise.readFloats(buffer, curve.npts, 2);
        return curve;
    }

    private int unpackCurves(Buffer buffer) {
        int n = Bitwise.read32v(buffer);
        if (n < 0) {
            return -6;
        }
        this.curves = new Curve[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.curves[i] = this.unpackCurve(buffer);
                continue;
            }
            catch (KateException kateException) {
                this.curves = null;
                return -6;
            }
        }
        Bitwise.skipWarp(buffer);
        return Info.checkEOP(buffer);
    }

    public Motion unpackMotion(Buffer buffer) throws KateException {
        int n;
        Motion motion = new Motion();
        int n2 = Bitwise.read32v(buffer);
        if (n2 < 0) {
            throw new KateBadPacketException();
        }
        motion.curves = new Curve[n2];
        for (int i = 0; i < n2; ++i) {
            if (buffer.read1() != 0) {
                n = Bitwise.read32v(buffer);
                if (n < 0 || n >= this.curves.length) {
                    throw new KateBadPacketException();
                }
                motion.curves[i] = this.curves[n];
                continue;
            }
            motion.curves[i] = this.unpackCurve(buffer);
        }
        double[][] dArray = Bitwise.readFloats(buffer, n2, 1);
        motion.durations = new double[n2];
        for (n = 0; n < n2; ++n) {
            motion.durations[n] = dArray[0][n];
        }
        motion.x_mapping = KateMotionMapping.CreateMotionMapping(buffer.read(8));
        motion.y_mapping = KateMotionMapping.CreateMotionMapping(buffer.read(8));
        motion.semantics = KateMotionSemantics.CreateMotionSemantics(buffer.read(8));
        motion.periodic = buffer.read1() != 0;
        Bitwise.skipWarp(buffer);
        return motion;
    }

    private int unpackMotions(Buffer buffer) {
        int n = Bitwise.read32v(buffer);
        if (n < 0) {
            return -6;
        }
        this.motions = new Motion[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.motions[i] = this.unpackMotion(buffer);
                continue;
            }
            catch (KateException kateException) {
                this.motions = null;
                return -6;
            }
        }
        Bitwise.skipWarp(buffer);
        return Info.checkEOP(buffer);
    }

    public Palette unpackPalette(Buffer buffer) throws KateException {
        Palette palette = new Palette();
        int n = buffer.read(8) + 1;
        palette.colors = new Color[n];
        for (int i = 0; i < n; ++i) {
            palette.colors[i] = this.unpackColor(buffer);
        }
        Bitwise.skipWarp(buffer);
        return palette;
    }

    private int unpackPalettes(Buffer buffer) {
        int n = Bitwise.read32v(buffer);
        if (n < 0) {
            return -6;
        }
        this.palettes = new Palette[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.palettes[i] = this.unpackPalette(buffer);
                continue;
            }
            catch (KateException kateException) {
                this.palettes = null;
                return -6;
            }
        }
        Bitwise.skipWarp(buffer);
        return Info.checkEOP(buffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Bitmap unpackBitmap(Buffer buffer) throws KateException {
        Bitmap bitmap = new Bitmap();
        bitmap.width = Bitwise.read32v(buffer);
        bitmap.height = Bitwise.read32v(buffer);
        bitmap.bpp = buffer.read(8);
        if (bitmap.width < 0 || bitmap.height < 0 || bitmap.bpp < 0 || bitmap.bpp > 8) {
            throw new KateBadPacketException();
        }
        if (bitmap.bpp == 0) {
            bitmap.type = KateBitmapType.CreateBitmapType(buffer.read(8));
            bitmap.palette = -1;
            if (bitmap.type == KateBitmapType.kate_bitmap_type_paletted) {
                int n = buffer.read(8);
                switch (n) {
                    case 1: {
                        bitmap.bpp = Bitwise.read32v(buffer);
                        bitmap.palette = Bitwise.read32v(buffer);
                        bitmap.pixels = RLE.decodeRLE(buffer, bitmap.width, bitmap.height, bitmap.bpp);
                        break;
                    }
                    default: {
                        Debug.warning("Unsupported bitmap type");
                        throw new KateBadPacketException();
                    }
                }
            } else {
                if (bitmap.type != KateBitmapType.kate_bitmap_type_png) {
                    Debug.warning("Unsupported bitmap type");
                    throw new KateBadPacketException();
                }
                bitmap.size = Bitwise.read32(buffer);
                bitmap.pixels = new byte[bitmap.size];
                Bitwise.readbuf(buffer, bitmap.pixels, bitmap.size);
            }
        } else {
            bitmap.type = KateBitmapType.kate_bitmap_type_paletted;
            bitmap.palette = Bitwise.read32v(buffer);
            int n = bitmap.width * bitmap.height;
            bitmap.pixels = new byte[n];
            for (int i = 0; i < n; ++i) {
                bitmap.pixels[i] = (byte)buffer.read(bitmap.bpp);
            }
        }
        if ((this.bitstream_version_major << 8 | this.bitstream_version_minor) >= 4) {
            Bitwise.read32v(buffer);
            bitmap.x_offset = Bitwise.read32v(buffer);
            bitmap.y_offset = Bitwise.read32v(buffer);
        } else {
            bitmap.x_offset = 0;
            bitmap.y_offset = 0;
        }
        Bitwise.skipWarp(buffer);
        return bitmap;
    }

    private int unpackBitmaps(Buffer buffer) {
        int n = Bitwise.read32v(buffer);
        if (n < 0) {
            return -6;
        }
        this.bitmaps = new Bitmap[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.bitmaps[i] = this.unpackBitmap(buffer);
                continue;
            }
            catch (KateException kateException) {
                this.bitmaps = null;
                return -6;
            }
        }
        Bitwise.skipWarp(buffer);
        return Info.checkEOP(buffer);
    }

    private FontRange unpackFontRange(Buffer buffer) {
        FontRange fontRange = new FontRange();
        fontRange.first_code_point = Bitwise.read32v(buffer);
        fontRange.last_code_point = Bitwise.read32v(buffer);
        fontRange.first_bitmap = Bitwise.read32v(buffer);
        Bitwise.skipWarp(buffer);
        return fontRange;
    }

    private int unpackFontMappings(Buffer buffer) {
        int n;
        int n2 = Bitwise.read32v(buffer);
        if (n2 < 0) {
            return -6;
        }
        if (n2 > 0) {
            this.font_ranges = new FontRange[n2];
            for (n = 0; n < n2; ++n) {
                this.font_ranges[n] = this.unpackFontRange(buffer);
            }
        }
        if ((n = Bitwise.read32v(buffer)) < 0) {
            return -6;
        }
        if (n > 0) {
            this.font_mappings = new FontMapping[n];
            for (int i = 0; i < n; ++i) {
                n2 = Bitwise.read32v(buffer);
                if (n2 < 0) {
                    return -6;
                }
                if (n2 > 0) {
                    FontRange[] fontRangeArray = new FontRange[n2];
                    for (int j = 0; j < n2; ++j) {
                        if (buffer.read1() != 0) {
                            int n3 = Bitwise.read32v(buffer);
                            if (n3 < 0 || n3 >= this.font_ranges.length) {
                                return -6;
                            }
                            fontRangeArray[j] = this.font_ranges[n3];
                            continue;
                        }
                        fontRangeArray[j] = this.unpackFontRange(buffer);
                    }
                    this.font_mappings[i].ranges = fontRangeArray;
                    continue;
                }
                this.font_mappings[i] = null;
            }
        }
        Bitwise.skipWarp(buffer);
        return Info.checkEOP(buffer);
    }

    public void clear() {
        this.num_headers = 0;
        this.regions = null;
        this.styles = null;
        this.curves = null;
        this.motions = null;
        this.probe = 0;
    }

    public int decodeHeader(Comment comment, Packet packet) {
        long l;
        Buffer buffer = new Buffer();
        buffer.readinit(packet.packet_base, packet.packet, packet.bytes);
        byte[] byArray = new byte[7];
        int n = buffer.read(8);
        if ((n & 0x80) == 0) {
            return -6;
        }
        Bitwise.readbuf(buffer, byArray, 7);
        if (!"kate\u0000\u0000\u0000".equals(new String(byArray))) {
            return -10;
        }
        if (packet.packetno < (long)this.num_headers && (long)this.probe != packet.packetno) {
            return -6;
        }
        if (buffer.read(8) != 0) {
            return -6;
        }
        Debug.debug("decodeHeader: packet type " + n + ", probe " + this.probe);
        switch (this.probe) {
            case 0: {
                if (packet.b_o_s == 0) {
                    return -6;
                }
                l = this.unpackInfo(buffer);
                break;
            }
            case 1: {
                l = this.unpackComment(comment, buffer);
                break;
            }
            case 2: {
                l = this.unpackRegions(buffer);
                break;
            }
            case 3: {
                l = this.unpackStyles(buffer);
                break;
            }
            case 4: {
                l = this.unpackCurves(buffer);
                break;
            }
            case 5: {
                l = this.unpackMotions(buffer);
                break;
            }
            case 6: {
                l = this.unpackPalettes(buffer);
                break;
            }
            case 7: {
                l = this.unpackBitmaps(buffer);
                break;
            }
            case 8: {
                l = this.unpackFontMappings(buffer);
                if (l != 0L) break;
                Debug.debug("Found last known header, returning 1");
                l = 1L;
                break;
            }
            default: {
                l = 0L;
            }
        }
        if (l >= 0L) {
            ++this.probe;
        }
        return (int)l;
    }
}

