/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jkate.Bitmap;
import com.fluendo.jkate.Palette;
import com.fluendo.utils.Debug;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public class TigerBitmap {
    private Image image;
    private Image scaled_image;

    public TigerBitmap(Bitmap bitmap, Palette palette) {
        this.image = bitmap == null ? null : (bitmap.bpp == 0 ? this.createPNGBitmap(bitmap, palette) : (palette == null ? null : this.createPalettedBitmap(bitmap, palette)));
    }

    public Image getScaled(int n, int n2) {
        if (this.scaled_image == null || n != this.scaled_image.getWidth(null) || n2 != this.scaled_image.getHeight(null)) {
            this.scaled_image = this.image.getScaledInstance(n, n2, 4);
        }
        return this.scaled_image;
    }

    private Image createPNGBitmap(Bitmap bitmap, Palette palette) {
        Debug.warning("PNG bitmaps not supported yet");
        return null;
    }

    private Image createPalettedBitmap(Bitmap bitmap, Palette palette) {
        byte[] byArray = new byte[4 * palette.colors.length];
        for (int i = 0; i < palette.colors.length; ++i) {
            byArray[i * 4 + 0] = palette.colors[i].r;
            byArray[i * 4 + 1] = palette.colors[i].g;
            byArray[i * 4 + 2] = palette.colors[i].b;
            byArray[i * 4 + 3] = palette.colors[i].a;
        }
        IndexColorModel indexColorModel = new IndexColorModel(bitmap.bpp, palette.colors.length, byArray, 0, true);
        BufferedImage bufferedImage = new BufferedImage(bitmap.width, bitmap.height, 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        writableRaster.setDataElements(0, 0, bitmap.width, bitmap.height, bitmap.pixels);
        return bufferedImage;
    }
}

