/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class Queue
extends Element {
    private static final int DEFAULT_MAX_BUFFERS = 100;
    private static final int DEFAULT_MAX_SIZE = -1;
    private static final boolean DEFAULT_IS_BUFFER = false;
    private static final int DEFAULT_LOW_PERCENT = 10;
    private static final int DEFAULT_HIGH_PERCENT = 70;
    private Vector queue = new Vector();
    private int srcResult = -2;
    private int size;
    private boolean isBuffering;
    private boolean isEOS;
    private int maxBuffers = 100;
    private int maxSize = -1;
    private boolean isBuffer = false;
    private int lowPercent = 10;
    private int highPercent = 70;
    private Pad srcpad = new Pad(1, "src"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void taskFunc() {
            int n;
            Object e;
            Object object = Queue.this.queue;
            synchronized (object) {
                if (Queue.this.srcResult != 0) {
                    return;
                }
                while (Queue.this.isEmpty()) {
                    try {
                        Queue.this.queue.wait();
                        if (Queue.this.srcResult == 0) continue;
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                e = Queue.this.queue.elementAt(Queue.this.queue.size() - 1);
                Queue.this.queue.removeElement(e);
                Queue.this.queue.notifyAll();
            }
            if (e instanceof Event) {
                object = (Event)e;
                this.pushEvent((Event)object);
                n = 0;
                if (((Event)object).getType() == 3) {
                    Queue.this.postMessage(Message.newStreamStatus(this, false, 0, "flow stopped, EOS"));
                    this.pauseTask();
                }
            } else {
                object = (Buffer)e;
                Queue.this.size -= ((Buffer)object).length;
                Debug.log(4, this.parent.getName() + " >>> " + object);
                n = this.push((Buffer)object);
                if (Queue.this.maxSize == -1) {
                    Debug.log(4, this.parent.getName() + " count = " + Queue.this.queue.size() + "/" + Queue.this.maxBuffers);
                } else {
                    Debug.log(4, this.parent.getName() + " size = " + Queue.this.size + "/" + Queue.this.maxSize);
                }
            }
            object = Queue.this.queue;
            synchronized (object) {
                if (n != 0) {
                    Queue.this.srcResult = n;
                    if (Pad.isFlowFatal(n)) {
                        this.pushEvent(Event.newEOS());
                    }
                    Queue.this.postMessage(Message.newStreamStatus(this, false, n, "flow stopped"));
                    this.pauseTask();
                }
                Queue.this.updateBuffering();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean activateFunc(int n) {
            boolean bl = true;
            switch (n) {
                case 0: {
                    Vector vector = Queue.this.queue;
                    synchronized (vector) {
                        Queue.this.clearQueue();
                        Queue.this.srcResult = -2;
                        Queue.this.queue.notifyAll();
                    }
                    if (Queue.this.isBuffer && Queue.this.isBuffering) {
                        Queue.this.isBuffering = false;
                        Queue.this.postMessage(Message.newBuffering(this, false, 0));
                    }
                    Queue.this.postMessage(Message.newStreamStatus(this, false, -2, "stopping"));
                    bl = this.stopTask();
                    break;
                }
                case 1: {
                    Queue.this.isEOS = false;
                    Vector vector = Queue.this.queue;
                    synchronized (vector) {
                        Queue.this.srcResult = 0;
                        if (!Queue.this.isBuffer) {
                            Queue.this.isBuffering = false;
                        } else {
                            Queue.this.isBuffering = true;
                            Queue.this.postMessage(Message.newBuffering(this, true, 0));
                        }
                        Queue.this.postMessage(Message.newStreamStatus(this, true, 0, "activating"));
                        bl = this.startTask("cortado-Queue-Stream-" + Debug.genId());
                        break;
                    }
                }
                default: {
                    Vector vector = Queue.this.queue;
                    synchronized (vector) {
                        Queue.this.srcResult = -2;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    };
    private Pad sinkpad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            Object object;
            int n = event.getType();
            boolean bl = true;
            switch (n) {
                case 1: {
                    Queue.this.srcpad.pushEvent(event);
                    object = Queue.this.queue;
                    synchronized (object) {
                        Queue.this.srcResult = -2;
                        Queue.this.queue.notifyAll();
                    }
                    object = this.streamLock;
                    synchronized (object) {
                        Debug.log(4, this + " synced");
                    }
                    Queue.this.postMessage(Message.newStreamStatus(Queue.this.srcpad, false, -2, "flush start"));
                    Queue.this.srcpad.pauseTask();
                    bl = false;
                    break;
                }
                case 2: {
                    Queue.this.srcpad.pushEvent(event);
                    Queue.this.isEOS = false;
                    object = Queue.this.queue;
                    synchronized (object) {
                        Queue.this.clearQueue();
                        Queue.this.srcResult = 0;
                        Queue.this.queue.notifyAll();
                    }
                    if (Queue.this.isBuffer) {
                        Queue.this.isBuffering = true;
                        Queue.this.postMessage(Message.newBuffering(this, true, 0));
                    }
                    Queue.this.postMessage(Message.newStreamStatus(Queue.this.srcpad, true, 0, "restart after flush"));
                    Queue.this.srcpad.startTask("cortado-Queue-Stream-" + Debug.genId());
                    bl = false;
                    break;
                }
                case 3: {
                    Queue.this.isEOS = true;
                    Debug.log(3, "got EOS: " + this);
                    if (!Queue.this.isBuffer || !Queue.this.isBuffering) break;
                    Queue.this.isBuffering = false;
                    Queue.this.postMessage(Message.newBuffering(this, Queue.this.isBuffering, 100));
                    break;
                }
            }
            if (bl) {
                object = Queue.this.queue;
                synchronized (object) {
                    Queue.this.queue.insertElementAt(event, 0);
                    Queue.this.queue.notifyAll();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int chainFunc(Buffer buffer) {
            Vector vector = Queue.this.queue;
            synchronized (vector) {
                if (Queue.this.srcResult != 0) {
                    buffer.free();
                    return Queue.this.srcResult;
                }
                while (Queue.this.isFilled()) {
                    try {
                        Debug.debug(this.parent.getName() + " full, waiting...");
                        Queue.this.queue.wait();
                        if (Queue.this.srcResult == 0) continue;
                        buffer.free();
                        return Queue.this.srcResult;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        buffer.free();
                        return -2;
                    }
                }
                Queue.this.size += buffer.length;
                Queue.this.updateBuffering();
                Debug.log(4, this.parent.getName() + " <<< " + buffer);
                Queue.this.queue.insertElementAt(buffer, 0);
                if (Queue.this.maxSize == -1) {
                    Debug.log(4, this.parent.getName() + " count = " + Queue.this.queue.size() + "/" + Queue.this.maxBuffers);
                } else {
                    Debug.log(4, this.parent.getName() + " size = " + Queue.this.size + "/" + Queue.this.maxSize);
                }
                Queue.this.queue.notifyAll();
            }
            return 0;
        }
    };

    private boolean isFilled() {
        if (this.maxSize != -1) {
            return this.size >= this.maxSize;
        }
        return this.queue.size() >= this.maxBuffers;
    }

    private boolean isEmpty() {
        return this.queue.size() == 0;
    }

    private void clearQueue() {
        Enumeration enumeration = this.queue.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Buffer)) continue;
            ((Buffer)e).free();
        }
        this.queue.setSize(0);
        this.size = 0;
        this.isBuffering = true;
    }

    private void updateBuffering() {
        if (!this.isBuffer || this.srcResult != 0) {
            return;
        }
        if (this.isEOS) {
            if (this.isBuffering) {
                this.isBuffering = false;
                this.postMessage(Message.newBuffering(this, false, 0));
            }
            return;
        }
        int n = this.size * 100 / this.maxSize;
        if (n > 100) {
            n = 100;
        }
        if (this.isBuffering) {
            if (n >= this.highPercent) {
                this.isBuffering = false;
            }
            this.postMessage(Message.newBuffering(this, this.isBuffering, n));
        } else if (n < this.lowPercent) {
            this.isBuffering = true;
        }
    }

    public Queue() {
        this.addPad(this.srcpad);
        this.addPad(this.sinkpad);
    }

    public String getFactoryName() {
        return "queue";
    }

    public boolean setProperty(String string, Object object) {
        if (string.equals("maxBuffers")) {
            this.maxBuffers = Integer.valueOf(object.toString());
        } else if (string.equals("maxSize")) {
            this.maxSize = Integer.valueOf(object.toString());
        } else if (string.equals("isBuffer")) {
            this.isBuffer = String.valueOf(object).equalsIgnoreCase("true");
        } else if (string.equals("lowPercent")) {
            this.lowPercent = Integer.valueOf(object.toString());
        } else if (string.equals("highPercent")) {
            this.highPercent = Integer.valueOf(object.toString());
        } else {
            return false;
        }
        return true;
    }

    public Object getProperty(String string) {
        if (string.equals("maxBuffers")) {
            return new Integer(this.maxBuffers);
        }
        if (string.equals("maxSize")) {
            return new Integer(this.maxSize);
        }
        if (string.equals("isBuffer")) {
            return this.isBuffer ? "true" : "false";
        }
        if (string.equals("lowPercent")) {
            return new Integer(this.lowPercent);
        }
        if (string.equals("highPercent")) {
            return new Integer(this.highPercent);
        }
        return null;
    }
}

