/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Sink;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageProducer;

public class VideoSink
extends Sink {
    private Component component;
    private boolean keepAspect = true;
    private boolean ignoreAspect;
    private boolean scale = true;
    private Frame frame;
    private int width;
    private int height;
    private int aspectX;
    private int aspectY;
    private Rectangle bounds = null;

    protected boolean setCapsFunc(Caps caps) {
        String string = caps.getMime();
        if (!string.equals("video/raw")) {
            return false;
        }
        this.width = caps.getFieldInt("width", -1);
        this.height = caps.getFieldInt("height", -1);
        if (this.width == -1 || this.height == -1) {
            return false;
        }
        this.aspectX = caps.getFieldInt("aspect_x", 1);
        this.aspectY = caps.getFieldInt("aspect_y", 1);
        if (!this.ignoreAspect) {
            Debug.log(4, this + " dimension: " + this.width + "x" + this.height + ", aspect: " + this.aspectX + "/" + this.aspectY);
            if (this.aspectY > this.aspectX) {
                this.height = this.height * this.aspectY / this.aspectX;
            } else {
                this.width = this.width * this.aspectX / this.aspectY;
            }
            Debug.log(4, this + " scaled source: " + this.width + "x" + this.height);
        }
        this.component.setVisible(true);
        return true;
    }

    protected int preroll(Buffer buffer) {
        return this.render(buffer);
    }

    protected int render(Buffer buffer) {
        int n;
        int n2;
        int n3;
        int n4;
        Image image;
        Debug.log(4, this.getName() + " starting buffer " + buffer);
        if (buffer.object instanceof ImageProducer) {
            image = this.component.createImage((ImageProducer)buffer.object);
        } else if (buffer.object instanceof Image) {
            image = (Image)buffer.object;
        } else {
            System.out.println(this + ": unknown buffer received " + buffer);
            return -5;
        }
        if (!this.component.isVisible()) {
            return -4;
        }
        Graphics graphics = this.component.getGraphics();
        if (this.keepAspect) {
            double d;
            double d2;
            if (this.bounds == null) {
                this.bounds = new Rectangle(this.component.getSize());
            }
            if ((d2 = (double)this.width / (double)this.height) > (d = (double)this.bounds.width / (double)this.bounds.height)) {
                n4 = this.bounds.width;
                n3 = (int)((double)this.bounds.width / d2);
                n2 = this.bounds.x;
                n = this.bounds.y + (this.bounds.height - n3) / 2;
            } else if (d2 < d) {
                n4 = (int)((double)this.bounds.height * d2);
                n3 = this.bounds.height;
                n2 = this.bounds.x + (this.bounds.width - n4) / 2;
                n = this.bounds.y;
            } else {
                n2 = this.bounds.x;
                n = this.bounds.y;
                n4 = this.bounds.width;
                n3 = this.bounds.height;
            }
        } else if (!this.scale) {
            n4 = Math.min(this.width, this.bounds.width);
            n3 = Math.min(this.height, this.bounds.height);
            n2 = this.bounds.x + (this.bounds.width - n4) / 2;
            n = this.bounds.y + (this.bounds.height - n3) / 2;
        } else {
            n4 = this.bounds.width;
            n3 = this.bounds.height;
            n2 = 0;
            n = 0;
        }
        graphics.drawImage(image, n2, n, n4, n3, null);
        Debug.log(4, this.getName() + " done with buffer " + buffer);
        return 0;
    }

    public String getFactoryName() {
        return "videosink";
    }

    public boolean setProperty(String string, Object object) {
        if (string.equals("component")) {
            this.component = (Component)object;
        } else if (string.equals("keep-aspect")) {
            this.keepAspect = String.valueOf(object).equals("true");
        } else if (string.equals("ignore-aspect")) {
            this.ignoreAspect = object.toString().equals("true");
        } else if (string.equals("scale")) {
            this.scale = String.valueOf(object).equals("true");
        } else if (string.equals("bounds")) {
            this.bounds = (Rectangle)object;
            Debug.info("Video bounding rectangle: x=" + this.bounds.x + ", y=" + this.bounds.y + ", w=" + this.bounds.width + ", h=" + this.bounds.height);
        } else {
            return super.setProperty(string, object);
        }
        return true;
    }

    public Object getProperty(String string) {
        if (string.equals("component")) {
            return this.component;
        }
        if (string.equals("keep-aspect")) {
            return this.keepAspect ? "true" : "false";
        }
        if (string.equals("bounds")) {
            return this.bounds;
        }
        return super.getProperty(string);
    }

    protected int changeState(int n) {
        if (this.currentState == 1 && this.pendingState == 2 && this.component == null) {
            this.frame = new Frame();
            this.component = this.frame;
        }
        return super.changeState(n);
    }
}

