/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.CachedFontInfo;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.fonts.autodetect.FontInfoFinder;
import org.apache.fop.render.AbstractRendererConfigurator;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererConfigurator;
import org.apache.fop.util.LogUtil;
import org.apache.xmlgraphics.util.ClasspathResource;

public class PrintRendererConfigurator
extends AbstractRendererConfigurator
implements RendererConfigurator {
    protected static Log log = LogFactory.getLog((Class)PrintRendererConfigurator.class);

    public PrintRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = this.getRendererConfig(renderer);
        if (cfg == null) {
            return;
        }
        PrintRenderer printRenderer = (PrintRenderer)renderer;
        FontResolver fontResolver = printRenderer.getFontResolver();
        if (fontResolver == null) {
            fontResolver = FontSetup.createMinimalFontResolver();
        }
        FopFactory factory = this.userAgent.getFactory();
        boolean strict = factory.validateUserConfigStrictly();
        FontCache fontCache = factory.getFontCache();
        List fontInfoList = PrintRendererConfigurator.buildFontListFromConfiguration(cfg, this.userAgent.getFontBaseURL(), fontResolver, strict, fontCache);
        if (fontCache != null && fontCache.hasChanged()) {
            fontCache.save();
        }
        printRenderer.addFontList(fontInfoList);
    }

    public static List buildFontListFromConfiguration(Configuration cfg, String fontBaseURL, FontResolver fontResolver, boolean strict, FontCache fontCache) throws FOPException {
        ArrayList<EmbedFontInfo> fontInfoList = new ArrayList<EmbedFontInfo>();
        Configuration fonts = cfg.getChild("fonts", false);
        if (fonts != null) {
            boolean autodetectFonts;
            long start = 0L;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting font configuration...");
                start = System.currentTimeMillis();
            }
            boolean bl = autodetectFonts = fonts.getChild("auto-detect", false) != null;
            if (autodetectFonts) {
                FontFileFinder fontFileFinder = new FontFileFinder();
                if (fontBaseURL != null) {
                    try {
                        File fontBase = FileUtils.toFile((URL)new URL(fontBaseURL));
                        if (fontBase != null) {
                            PrintRendererConfigurator.addFontInfoListFromFileList(fontFileFinder.find(fontBase.getAbsolutePath()), fontInfoList, fontResolver, fontCache);
                        }
                    }
                    catch (IOException e) {
                        LogUtil.handleException(log, e, strict);
                    }
                }
                try {
                    PrintRendererConfigurator.addFontInfoListFromFileList(fontFileFinder.find(), fontInfoList, fontResolver, fontCache);
                }
                catch (IOException e) {
                    LogUtil.handleException(log, e, strict);
                }
                PrintRendererConfigurator.addFontInfoListFromFileList(ClasspathResource.getInstance().listResourcesOfMimeType("application/x-font"), fontInfoList, fontResolver, fontCache);
                PrintRendererConfigurator.addFontInfoListFromFileList(ClasspathResource.getInstance().listResourcesOfMimeType("application/x-font-truetype"), fontInfoList, fontResolver, fontCache);
            }
            Configuration[] directories = fonts.getChildren("directory");
            for (int i = 0; i < directories.length; ++i) {
                boolean recursive = directories[i].getAttributeAsBoolean("recursive", false);
                String directory = null;
                try {
                    directory = directories[i].getValue();
                }
                catch (ConfigurationException e) {
                    LogUtil.handleException(log, e, strict);
                    continue;
                }
                if (directory == null) {
                    LogUtil.handleException(log, new FOPException("directory defined without value"), strict);
                    continue;
                }
                FontFileFinder fontFileFinder = new FontFileFinder(recursive ? -1 : 1);
                try {
                    PrintRendererConfigurator.addFontInfoListFromFileList(fontFileFinder.find(directory), fontInfoList, fontResolver, fontCache);
                    continue;
                }
                catch (IOException e) {
                    LogUtil.handleException(log, e, strict);
                }
            }
            Configuration[] font = fonts.getChildren("font");
            for (int i = 0; i < font.length; ++i) {
                EmbedFontInfo fontInfo = PrintRendererConfigurator.getFontInfoFromConfiguration(font[i], fontResolver, strict, fontCache);
                if (fontInfo == null) continue;
                fontInfoList.add(fontInfo);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished font configuration in " + (System.currentTimeMillis() - start) + "ms"));
            }
        }
        return fontInfoList;
    }

    private static void addFontInfoListFromFileList(List fontFileList, List fontInfoList, FontResolver resolver, FontCache fontCache) {
        Iterator iter = fontFileList.iterator();
        while (iter.hasNext()) {
            FontInfoFinder finder = new FontInfoFinder();
            URL fontUrl = (URL)iter.next();
            EmbedFontInfo fontInfo = finder.find(fontUrl, resolver, fontCache);
            if (fontInfo == null) continue;
            fontInfoList.add(fontInfo);
        }
    }

    private static void closeSource(Source src) {
        if (src instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)src;
            IOUtils.closeQuietly((InputStream)streamSource.getInputStream());
            IOUtils.closeQuietly((Reader)streamSource.getReader());
        }
    }

    public static EmbedFontInfo getFontInfoFromConfiguration(Configuration fontCfg, FontResolver fontResolver, boolean strict, FontCache fontCache) throws FOPException {
        int j;
        String metricsUrl = fontCfg.getAttribute("metrics-url", null);
        String embedUrl = fontCfg.getAttribute("embed-url", null);
        if (metricsUrl == null && embedUrl == null) {
            LogUtil.handleError(log, "Font configuration without metric-url or embed-url", strict);
            return null;
        }
        if (strict) {
            Source source;
            if (embedUrl != null) {
                source = fontResolver.resolve(embedUrl);
                PrintRendererConfigurator.closeSource(source);
                if (source == null) {
                    LogUtil.handleError(log, "Failed to resolve font with embed-url '" + embedUrl + "'", strict);
                    return null;
                }
            }
            if (metricsUrl != null) {
                source = fontResolver.resolve(metricsUrl);
                PrintRendererConfigurator.closeSource(source);
                if (source == null) {
                    LogUtil.handleError(log, "Failed to resolve font with metric-url '" + metricsUrl + "'", strict);
                    return null;
                }
            }
        }
        boolean useKerning = fontCfg.getAttributeAsBoolean("kerning", true);
        EmbedFontInfo fontInfo = null;
        Configuration[] tripletCfg = fontCfg.getChildren("font-triplet");
        if (tripletCfg.length == 0) {
            URL fontUrl;
            LogUtil.handleError(log, "font without font-triplet", strict);
            File fontFile = CachedFontInfo.getFileFromUrls(new String[]{embedUrl, metricsUrl});
            try {
                fontUrl = fontFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.debug((Object)("Malformed Url: " + e.getMessage()));
                return null;
            }
            if (fontFile != null) {
                FontInfoFinder finder = new FontInfoFinder();
                return finder.find(fontUrl, fontResolver, fontCache);
            }
            return null;
        }
        ArrayList<FontTriplet> tripleList = new ArrayList<FontTriplet>();
        for (j = 0; j < tripletCfg.length; ++j) {
            try {
                String name = tripletCfg[j].getAttribute("name");
                if (name == null) {
                    LogUtil.handleError(log, "font-triplet without name", strict);
                    continue;
                }
                String weightStr = tripletCfg[j].getAttribute("weight");
                if (weightStr == null) {
                    LogUtil.handleError(log, "font-triplet without weight", strict);
                    continue;
                }
                int weight = FontUtil.parseCSS2FontWeight(weightStr);
                String style = tripletCfg[j].getAttribute("style");
                if (style == null) {
                    LogUtil.handleError(log, "font-triplet without style", strict);
                    continue;
                }
                tripleList.add(FontInfo.createFontKey(name, style, weight));
                continue;
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(log, e, strict);
            }
        }
        fontInfo = new EmbedFontInfo(metricsUrl, useKerning, tripleList, embedUrl);
        if (fontCache != null && !fontCache.containsFont(fontInfo)) {
            fontCache.addFont(fontInfo);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding font " + fontInfo.getEmbedFile() + ", metric file " + fontInfo.getMetricsFile()));
            for (j = 0; j < tripleList.size(); ++j) {
                FontTriplet triplet = (FontTriplet)tripleList.get(j);
                log.debug((Object)("  Font triplet " + triplet.getName() + ", " + triplet.getStyle() + ", " + triplet.getWeight()));
            }
        }
        return fontInfo;
    }
}

