/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.ChunkMapReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.PropertiesWriter;
import org.dita.dost.writer.TopicRefWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkModule
implements AbstractPipelineModule {
    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        String baseDir = ((PipelineHashIO)input).getAttribute("basedir");
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        String ditaext = ((PipelineHashIO)input).getAttribute("ditaext");
        String transtype = ((PipelineHashIO)input).getAttribute("transtype");
        File ditalist = null;
        File xmlDitalist = null;
        Properties prop = new Properties();
        StringTokenizer st = null;
        ChunkMapReader mapReader = new ChunkMapReader();
        DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(baseDir, tempDir).getAbsolutePath();
        }
        ditalist = new File(tempDir, "dita.list");
        xmlDitalist = new File(tempDir, "dita.xml.properties");
        mapReader.setup(ditaext, transtype);
        try {
            if (xmlDitalist.exists()) {
                prop.loadFromXML(new FileInputStream(xmlDitalist));
            } else {
                prop.load(new FileInputStream(ditalist));
            }
        }
        catch (IOException ioe) {
            throw new DITAOTException(ioe);
        }
        String mapFile = new File(tempDir, prop.getProperty("user.input.file")).getAbsolutePath();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(mapFile);
            Element root = doc.getDocumentElement();
            if (root.getAttribute("class").contains(" eclipsemap/plugin ") && transtype.equals("eclipsehelp")) {
                st = new StringTokenizer(prop.getProperty("fullditamaplist"), ",");
                while (st.hasMoreTokens()) {
                    mapFile = new File(tempDir, st.nextToken()).getAbsolutePath();
                    mapReader.read(mapFile);
                }
            } else {
                mapReader.read(mapFile);
            }
        }
        catch (Exception e) {
            javaLogger.logException(e);
        }
        Content content = mapReader.getContent();
        if (content.getValue() != null) {
            this.updateList((LinkedHashMap)content.getValue(), mapReader.getConflicTable(), input);
            this.updateRefOfDita(content, mapReader.getConflicTable(), input);
        }
        return null;
    }

    private void updateRefOfDita(Content changeTable, Hashtable<String, String> conflictTable, AbstractPipelineInput input) {
        Properties prop = new Properties();
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        String baseDir = ((PipelineHashIO)input).getAttribute("basedir");
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        File xmlDitalist = null;
        File ditalist = null;
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(baseDir, tempDir).getAbsolutePath();
        }
        ditalist = new File(tempDir, "dita.list");
        xmlDitalist = new File(tempDir, "dita.xml.properties");
        try {
            if (xmlDitalist.exists()) {
                prop.loadFromXML(new FileInputStream(xmlDitalist));
            } else {
                prop.load(new FileInputStream(ditalist));
            }
        }
        catch (IOException io) {
            logger.logError(io.getMessage());
        }
        TopicRefWriter topicRefWriter = new TopicRefWriter();
        topicRefWriter.setContent(changeTable);
        topicRefWriter.setup(conflictTable);
        StringTokenizer fullTopicList = new StringTokenizer(prop.getProperty("fullditamapandtopiclist"), ",");
        try {
            while (fullTopicList.hasMoreTokens()) {
                topicRefWriter.write(new File(tempDir, fullTopicList.nextToken()).getAbsolutePath());
            }
        }
        catch (DITAOTException ex) {
            logger.logException(ex);
        }
    }

    private void updateList(LinkedHashMap<String, String> changeTable, Hashtable<String, String> conflictTable, AbstractPipelineInput input) {
        Properties prop = new Properties();
        LinkedHashSet<String> chunkedTopicSet = new LinkedHashSet<String>(128);
        LinkedHashSet<String> chunkedDitamapSet = new LinkedHashSet<String>(128);
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        PropertiesWriter writer = new PropertiesWriter();
        ContentImpl content = new ContentImpl();
        String baseDir = ((PipelineHashIO)input).getAttribute("basedir");
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        String ditaext = ((PipelineHashIO)input).getAttribute("ditaext");
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(baseDir, tempDir).getAbsolutePath();
        }
        File ditalist = null;
        File xmlDitalist = null;
        ditalist = new File(tempDir, "dita.list");
        xmlDitalist = new File(tempDir, "dita.xml.properties");
        try {
            if (xmlDitalist.exists()) {
                prop.loadFromXML(new FileInputStream(xmlDitalist));
            } else {
                prop.load(new FileInputStream(ditalist));
            }
        }
        catch (IOException ex) {
            logger.logException(ex);
        }
        LinkedHashSet<String> topicList = new LinkedHashSet<String>(128);
        Set<String> oldTopicList = null;
        Set<String> ditamapList = null;
        Set<String> hrefTopics = null;
        Set<String> chunkTopics = null;
        oldTopicList = StringUtils.restoreSet(prop.getProperty("fullditatopiclist"));
        ditamapList = StringUtils.restoreSet(prop.getProperty("fullditamaplist"));
        hrefTopics = StringUtils.restoreSet(prop.getProperty("canditopicslist"));
        chunkTopics = StringUtils.restoreSet(prop.getProperty("skipchunklist"));
        Set<String> resourceOnlySet = StringUtils.restoreSet(prop.getProperty("resourceonlylist"));
        if (hrefTopics != null && chunkTopics != null) {
            for (String s : chunkTopics) {
                if (!StringUtils.isEmptyString(s) && !s.contains("#")) {
                    Iterator<String> hrefit = hrefTopics.iterator();
                    while (hrefit.hasNext()) {
                        String ent = hrefit.next();
                        if (!FileUtils.resolveFile(tempDir, ent).equalsIgnoreCase(FileUtils.resolveFile(tempDir, s))) continue;
                        hrefit.remove();
                    }
                    continue;
                }
                if (StringUtils.isEmptyString(s) || !hrefTopics.contains(s)) continue;
                hrefTopics.remove(s);
            }
        }
        if (hrefTopics != null && hrefTopics.size() > 0) {
            for (String t : hrefTopics) {
                if (t.lastIndexOf("#") != -1) {
                    t = t.substring(0, t.lastIndexOf("#"));
                }
                if (t.lastIndexOf(".ditamap") == -1) {
                    t = this.changeExtName(t, ditaext, ditaext);
                }
                t = FileUtils.getRelativePathFromMap(xmlDitalist.getAbsolutePath(), FileUtils.resolveFile(tempDir, t));
                topicList.add(t);
                if (!oldTopicList.contains(t)) continue;
                oldTopicList.remove(t);
            }
        }
        if (topicList != null) {
            String newChunkedFile = null;
            Iterator<Map.Entry<String, String>> it = changeTable.entrySet().iterator();
            File topic_list = new File(tempDir, "fullditatopiclist".substring(0, "fullditatopiclist".lastIndexOf("list")) + ".list");
            File map_list = new File(tempDir, "fullditamaplist".substring(0, "fullditamaplist".lastIndexOf("list")) + ".list");
            File all_list = new File(tempDir, "fullditamapandtopiclist".substring(0, "fullditamapandtopiclist".lastIndexOf("list")) + ".list");
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String oldFile = entry.getKey();
                if (!entry.getValue().toString().equals(oldFile)) continue;
                newChunkedFile = entry.getValue().toString();
                newChunkedFile = FileUtils.getRelativePathFromMap(xmlDitalist.getAbsolutePath(), newChunkedFile);
                String extName = this.getExtName(newChunkedFile);
                if (extName != null && !extName.equalsIgnoreCase("DITAMAP")) {
                    chunkedTopicSet.add(newChunkedFile);
                    if (topicList.contains(newChunkedFile)) continue;
                    topicList.add(newChunkedFile);
                    if (!oldTopicList.contains(newChunkedFile)) continue;
                    oldTopicList.remove(newChunkedFile);
                    continue;
                }
                if (!ditamapList.contains(newChunkedFile)) {
                    ditamapList.add(newChunkedFile);
                    if (oldTopicList.contains(newChunkedFile)) {
                        oldTopicList.remove(newChunkedFile);
                    }
                }
                chunkedDitamapSet.add(newChunkedFile);
            }
            for (String s : oldTopicList) {
                File f;
                if (StringUtils.isEmptyString(s) || !(f = new File(tempDir, s)).exists()) continue;
                f.delete();
            }
            for (Map.Entry<String, String> entry : changeTable.entrySet()) {
                String targetPath;
                String oldFile = entry.getKey();
                if (!entry.getValue().toString().equals(oldFile) || (targetPath = conflictTable.get(entry.getKey())) == null) continue;
                File target = new File(targetPath);
                if (!FileUtils.fileExists(target.getAbsolutePath())) {
                    File from = new File(entry.getValue().toString());
                    String relativePath = FileUtils.getRelativePathFromMap(xmlDitalist.getAbsolutePath(), from.getAbsolutePath());
                    target.delete();
                    from.renameTo(target);
                    if (topicList.contains(relativePath)) {
                        topicList.remove(relativePath);
                    }
                    if (chunkedTopicSet.contains(relativePath)) {
                        chunkedTopicSet.remove(relativePath);
                    }
                    relativePath = FileUtils.getRelativePathFromMap(xmlDitalist.getAbsolutePath(), target.getAbsolutePath());
                    topicList.add(relativePath);
                    chunkedTopicSet.add(relativePath);
                    continue;
                }
                conflictTable.remove(entry.getKey());
            }
            resourceOnlySet.removeAll(chunkedTopicSet);
            resourceOnlySet.removeAll(chunkedDitamapSet);
            prop.setProperty("resourceonlylist", StringUtils.assembleString(resourceOnlySet, ","));
            prop.setProperty("fullditatopiclist", StringUtils.assembleString(topicList, ","));
            prop.setProperty("fullditamaplist", StringUtils.assembleString(ditamapList, ","));
            topicList.addAll(ditamapList);
            prop.setProperty("fullditamapandtopiclist", StringUtils.assembleString(topicList, ","));
            String[] topics = prop.getProperty("fullditatopiclist").split(",");
            String[] maps = prop.getProperty("fullditamaplist").split(",");
            String[] all = prop.getProperty("fullditamapandtopiclist").split(",");
            try {
                int i;
                BufferedWriter topicWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(topic_list)));
                BufferedWriter mapWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(map_list)));
                BufferedWriter allWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(all_list)));
                for (i = 0; i < topics.length; ++i) {
                    topicWriter.write(topics[i]);
                    if (i < topics.length - 1) {
                        topicWriter.write("\n");
                    }
                    topicWriter.flush();
                }
                for (i = 0; i < maps.length; ++i) {
                    mapWriter.write(maps[i]);
                    if (i < maps.length - 1) {
                        mapWriter.write("\n");
                    }
                    mapWriter.flush();
                }
                for (i = 0; i < all.length; ++i) {
                    allWriter.write(all[i]);
                    if (i < all.length - 1) {
                        allWriter.write("\n");
                    }
                    allWriter.flush();
                }
            }
            catch (FileNotFoundException e) {
                logger.logException(e);
            }
            catch (IOException e) {
                logger.logException(e);
            }
        }
        String[] keys = new String[]{"chunkedditamaplist", "chunkedtopiclist", "resourceonlylist"};
        Set[] sets = new Set[]{chunkedDitamapSet, chunkedTopicSet, resourceOnlySet};
        for (int i = 0; i < keys.length; ++i) {
            String fileKey = keys[i].substring(0, keys[i].lastIndexOf("list")) + "file";
            prop.put(fileKey, keys[i].substring(0, keys[i].lastIndexOf("list")) + ".list");
            File list = new File(tempDir, prop.getProperty(fileKey));
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(list)));
                Iterator it = sets[i].iterator();
                while (it.hasNext()) {
                    bufferedWriter.write((String)it.next());
                    if (!it.hasNext()) continue;
                    bufferedWriter.write("\n");
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.addSetToProperties(prop, "chunkedditamaplist", chunkedDitamapSet);
        this.addSetToProperties(prop, "chunkedtopiclist", chunkedTopicSet);
        content.setValue(prop);
        writer.setContent(content);
        try {
            writer.write(ditalist.getAbsolutePath());
            writer.writeToXML(xmlDitalist.getAbsolutePath());
        }
        catch (DITAOTException ex) {
            logger.logException(ex);
        }
    }

    private String getExtName(String file) {
        int index = file.indexOf("#");
        if (file.startsWith("#")) {
            return null;
        }
        if (index != -1) {
            String fileName = file.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(fileExtIndex + 1, fileName.length()) : null;
        }
        int fileExtIndex = file.lastIndexOf(".");
        return fileExtIndex != -1 ? file.substring(fileExtIndex + 1, file.length()) : null;
    }

    private String changeExtName(String filename, String from, String to) {
        if (StringUtils.isEmptyString(filename)) {
            return null;
        }
        if (filename.indexOf(to) != -1) {
            return filename;
        }
        if (from == null) {
            from = "";
        }
        if (to == null) {
            to = "";
        }
        if (filename.lastIndexOf(from) != -1) {
            return filename.substring(0, filename.lastIndexOf(from)) + to;
        }
        return filename + to;
    }

    private void addSetToProperties(Properties prop, String key, Set<String> set) {
        String value = null;
        value = StringUtils.assembleString(set, ",");
        prop.put(key, value);
        set.clear();
    }
}

