/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.ConrefPushReader;
import org.dita.dost.util.ListUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.ConrefPushParser;

public class ConrefPushModule
implements AbstractPipelineModule {
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        String basedir = ((PipelineHashIO)input).getAttribute("basedir");
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(basedir, tempDir).getAbsolutePath();
        }
        Properties properties = null;
        try {
            properties = ListUtils.getDitaList();
        }
        catch (IOException e) {
            DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
            javaLogger.logException(e);
        }
        Set<String> conrefpushlist = StringUtils.restoreSet(properties.getProperty("conrefpushlist"));
        ConrefPushReader reader = new ConrefPushReader();
        for (String fileName : conrefpushlist) {
            reader.read(new File(tempDir, fileName).getAbsolutePath());
        }
        Set pushSet = (Set)reader.getContent().getCollection();
        for (Map.Entry entry : pushSet) {
            ConrefPushParser parser = new ConrefPushParser();
            ContentImpl content = new ContentImpl();
            content.setValue(entry.getValue());
            parser.setContent(content);
            parser.setTempDir(tempDir);
            parser.write((String)entry.getKey());
        }
        return null;
    }
}

