/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.MapIndexReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.ListUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.DitaIndexWriter;

public class MoveIndexModule
implements AbstractPipelineModule {
    private ContentImpl content = new ContentImpl();
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();

    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        MapIndexReader indexReader = new MapIndexReader();
        DitaIndexWriter indexInserter = new DitaIndexWriter();
        String baseDir = ((PipelineHashIO)input).getAttribute("basedir");
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(baseDir, tempDir).getAbsolutePath();
        }
        indexReader.setMatch(new StringBuffer("topicref").append("/").append("topicmeta").append("/").append("keywords").toString());
        Properties properties = null;
        try {
            properties = ListUtils.getDitaList();
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        Set<String> fullditamaplist = StringUtils.restoreSet(properties.getProperty("fullditamaplist"));
        for (String fileName : fullditamaplist) {
            indexReader.read(new File(tempDir, fileName).getAbsolutePath());
        }
        Set mapSet = (Set)indexReader.getContent().getCollection();
        for (Map.Entry entry : mapSet) {
            String targetFileName = (String)entry.getKey();
            String string = targetFileName = targetFileName.indexOf("#") != -1 ? targetFileName.substring(0, targetFileName.indexOf("#")) : targetFileName;
            if (!targetFileName.endsWith(".dita") && !targetFileName.endsWith(".xml")) continue;
            this.content.setValue(entry.getValue());
            indexInserter.setContent(this.content);
            if (FileUtils.fileExists((String)entry.getKey())) {
                indexInserter.write((String)entry.getKey());
                continue;
            }
            this.logger.logError(" ERROR FILE DOES NOT EXIST " + (String)entry.getKey());
        }
        return null;
    }
}

