/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.dita.dost.platform.PluginRequirement;
import org.dita.dost.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Features {
    private String location = null;
    private Hashtable<String, String> featureTable;
    private List<PluginRequirement> requireList;
    private Hashtable<String, String> metaTable;
    private List<String> templateList;

    public Features() {
        this.featureTable = new Hashtable(16);
        this.requireList = new ArrayList<PluginRequirement>(8);
        this.metaTable = new Hashtable(16);
        this.templateList = new ArrayList<String>(8);
    }

    public Features(String location) {
        this.location = location;
        this.featureTable = new Hashtable(16);
        this.requireList = new ArrayList<PluginRequirement>(8);
        this.metaTable = new Hashtable(16);
        this.templateList = new ArrayList<String>(8);
    }

    public String getLocation() {
        return this.location;
    }

    public String getFeature(String id) {
        return this.featureTable.get(id);
    }

    public Set<Map.Entry<String, String>> getAllFeatures() {
        return this.featureTable.entrySet();
    }

    public void addFeature(String id, String value, String type) {
        StringTokenizer valueTokenizer = new StringTokenizer(value, ",");
        StringBuffer valueBuffer = new StringBuffer();
        while (valueTokenizer.hasMoreElements()) {
            String valueElement = (String)valueTokenizer.nextElement();
            if (valueElement == null || valueElement.trim().length() == 0) continue;
            if ("file".equals(type) && !FileUtils.isAbsolutePath(valueElement)) {
                valueBuffer.append(this.location).append(File.separatorChar);
            }
            valueBuffer.append(valueElement.trim());
            if (!valueTokenizer.hasMoreElements()) continue;
            valueBuffer.append(",");
        }
        this.featureTable.put(id, valueBuffer.toString());
    }

    public void addRequire(String id) {
        PluginRequirement requirement = new PluginRequirement();
        requirement.addPlugins(id);
        this.requireList.add(requirement);
    }

    public void addRequire(String id, String importance) {
        PluginRequirement requirement = new PluginRequirement();
        requirement.addPlugins(id);
        if (importance != null) {
            requirement.setRequired(importance.equals("required"));
        }
        this.requireList.add(requirement);
    }

    public Iterator<PluginRequirement> getRequireListIter() {
        return this.requireList.iterator();
    }

    public void addMeta(String type, String value) {
        this.metaTable.put(type, value);
    }

    public String getMeta(String type) {
        return this.metaTable.get(type);
    }

    public void addTemplate(String file) {
        this.templateList.add(file);
    }

    public List<String> getAllTemplates() {
        return this.templateList;
    }
}

