/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.ChunkTopicParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkMapReader
implements AbstractReader {
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
    private boolean chunkByTopic = false;
    private String filePath = null;
    private LinkedHashMap<String, String> changeTable = new LinkedHashMap(128);
    private Hashtable<String, String> conflictTable = null;
    private HashSet<String> refFileSet = new HashSet(128);
    private String ditaext = null;
    private String transtype = null;
    private ProcessingInstruction workdir = null;
    private ProcessingInstruction path2proj = null;
    private String processingRole = "normal";

    public ChunkMapReader() {
        this.conflictTable = new Hashtable(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(String filename) {
        File inputFile = new File(filename);
        this.filePath = inputFile.getParent();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(filename);
            NodeList docNodes = doc.getChildNodes();
            for (int i = 0; i < docNodes.getLength(); ++i) {
                Node node = docNodes.item(i);
                if (node.getNodeType() != 7) continue;
                ProcessingInstruction pi = (ProcessingInstruction)node;
                if (pi.getNodeName() == "workdir") {
                    this.workdir = pi;
                    continue;
                }
                if (pi.getNodeName() != "path2project") continue;
                this.path2proj = pi;
            }
            Element root = doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            String rootChunkValue = root.getAttribute("chunk");
            this.chunkByTopic = rootChunkValue != null && rootChunkValue.contains("by-topic");
            if (root.getAttribute("chunk") != null && root.getAttribute("chunk").indexOf("to-content") != -1) {
                Random random = new Random();
                String newFilename = inputFile.getName().substring(0, inputFile.getName().indexOf(".ditamap")) + this.ditaext;
                File newFile = new File(inputFile.getParentFile().getAbsolutePath(), newFilename);
                if (newFile.exists()) {
                    newFilename = "Chunk" + new Integer(Math.abs(random.nextInt())).toString() + this.ditaext;
                    String oldpath = newFile.getAbsolutePath();
                    newFile = new File(FileUtils.resolveFile(inputFile.getParentFile().getAbsolutePath(), newFilename));
                    this.conflictTable.put(newFile.getAbsolutePath(), FileUtils.removeRedundantNames(oldpath));
                }
                String originClassValue = root.getAttribute("class");
                root.setAttribute("class", originClassValue + " map/topicref ");
                root.setAttribute("href", newFilename);
                OutputStreamWriter newFileWriter = null;
                try {
                    newFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF-8");
                    newFileWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    newFileWriter.write("<?workdir /" + newFile.getParentFile().getAbsolutePath() + "?>");
                    newFileWriter.write("<dita></dita>");
                    newFileWriter.flush();
                    newFileWriter.close();
                }
                catch (Exception e) {
                    this.javaLogger.logException(e);
                }
                finally {
                    try {
                        if (newFileWriter != null) {
                            newFileWriter.close();
                        }
                    }
                    catch (Exception e) {
                        this.javaLogger.logException(e);
                    }
                }
                this.processTopicref(root);
                this.changeTable.put(newFile.getAbsolutePath(), newFile.getAbsolutePath());
                if (originClassValue != null) {
                    root.setAttribute("class", originClassValue);
                }
                root.removeAttribute("href");
            } else {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    Node classAttr = null;
                    String classValue = null;
                    if (node.getNodeType() != 1) continue;
                    classAttr = node.getAttributes().getNamedItem("class");
                    if (classAttr != null) {
                        classValue = classAttr.getNodeValue();
                    }
                    if (classValue != null && classValue.indexOf(" map/reltable ") != -1) {
                        this.updateReltable((Element)node);
                    }
                    if (classValue == null || classValue.indexOf(" map/topicref ") == -1 || classValue.contains(" mapgroup-d/topicgroup ")) continue;
                    this.processTopicref(node);
                }
            }
            this.outputMapFile(inputFile.getAbsolutePath() + ".chunk", root);
            if (!inputFile.delete()) {
                Properties prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", inputFile.getAbsolutePath() + ".chunk");
                this.javaLogger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
            if (!new File(inputFile.getAbsolutePath() + ".chunk").renameTo(inputFile)) {
                Properties prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", inputFile.getAbsolutePath() + ".chunk");
                this.javaLogger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputMapFile(String file, Element root) {
        OutputStreamWriter output = null;
        try {
            output = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            if (this.workdir != null) {
                this.output(this.workdir, (Writer)output);
            }
            if (this.path2proj != null) {
                this.output(this.path2proj, (Writer)output);
            }
            this.output(root, (Writer)output);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {
                this.javaLogger.logException(e);
            }
        }
    }

    private void output(ProcessingInstruction instruction, Writer outputWriter) throws IOException {
        outputWriter.write("<?" + instruction.getTarget() + " " + instruction.getData() + "?>");
    }

    private void output(Text text, Writer outputWriter) throws IOException {
        outputWriter.write(StringUtils.escapeXML(text.getData()));
    }

    private void output(Element elem, Writer outputWriter) throws IOException {
        outputWriter.write("<" + elem.getNodeName());
        NamedNodeMap attrMap = elem.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            outputWriter.write(" " + attrMap.item(i).getNodeName() + "=\"" + StringUtils.escapeXML(attrMap.item(i).getNodeValue()) + "\"");
        }
        outputWriter.write(">");
        NodeList children = elem.getChildNodes();
        block6: for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            switch (child.getNodeType()) {
                case 3: {
                    this.output((Text)child, outputWriter);
                    continue block6;
                }
                case 7: {
                    this.output((ProcessingInstruction)child, outputWriter);
                    continue block6;
                }
                case 1: {
                    this.output((Element)child, outputWriter);
                }
            }
        }
        outputWriter.write("</" + elem.getNodeName() + ">");
    }

    private void processTopicref(Node node) {
        NamedNodeMap attr = null;
        Node hrefAttr = null;
        Node chunkAttr = null;
        Node copytoAttr = null;
        Node scopeAttr = null;
        Node classAttr = null;
        Node xtrfAttr = null;
        Node processAttr = null;
        String hrefValue = null;
        String chunkValue = null;
        String copytoValue = null;
        String scopeValue = null;
        String classValue = null;
        String xtrfValue = null;
        String processValue = null;
        String tempRole = this.processingRole;
        boolean prevChunkByTopic = false;
        attr = node.getAttributes();
        hrefAttr = attr.getNamedItem("href");
        chunkAttr = attr.getNamedItem("chunk");
        copytoAttr = attr.getNamedItem("copy-to");
        scopeAttr = attr.getNamedItem("scope");
        classAttr = attr.getNamedItem("class");
        xtrfAttr = attr.getNamedItem("xtrf");
        processAttr = attr.getNamedItem("processing-role");
        if (hrefAttr != null) {
            hrefValue = hrefAttr.getNodeValue();
        }
        if (chunkAttr != null) {
            chunkValue = chunkAttr.getNodeValue();
        }
        if (copytoAttr != null) {
            copytoValue = copytoAttr.getNodeValue();
        }
        if (scopeAttr != null) {
            scopeValue = scopeAttr.getNodeValue();
        }
        if (classAttr != null) {
            classValue = classAttr.getNodeValue();
        }
        if (xtrfAttr != null) {
            xtrfValue = xtrfAttr.getNodeValue();
        }
        if (processAttr != null) {
            this.processingRole = processValue = processAttr.getNodeValue();
        }
        if (xtrfValue != null && xtrfValue.contains("generated_by_chunk")) {
            return;
        }
        if (chunkValue != null && (chunkValue.contains("by-topic") || chunkValue.contains("by-document"))) {
            prevChunkByTopic = this.chunkByTopic;
            this.chunkByTopic = chunkValue.contains("by-topic");
        }
        if ("external".equalsIgnoreCase(scopeValue) || hrefValue != null && !FileUtils.fileExists(FileUtils.resolveFile(this.filePath, hrefValue)) || classValue.contains(" mapgroup-d/topichead ") || classValue.contains(" map/topicref ") && chunkValue == null && hrefValue == null) {
            if (chunkValue != null && (chunkValue.contains("by-topic") || chunkValue.contains("by-document"))) {
                this.chunkByTopic = prevChunkByTopic;
            }
            this.processChildTopicref(node);
        } else if (chunkValue != null && chunkValue.indexOf("to-content") != -1) {
            this.processChunk((Element)node, false, this.chunkByTopic);
        } else if (chunkValue != null && chunkValue.indexOf("to-navigation") != -1 && "eclipsehelp".equals(this.transtype)) {
            if (chunkValue != null && (chunkValue.contains("by-topic") || chunkValue.contains("by-document"))) {
                this.chunkByTopic = prevChunkByTopic;
            }
            this.processChildTopicref(node);
            Node root = node.getOwnerDocument().getDocumentElement().cloneNode(false);
            Element navref = node.getOwnerDocument().createElement("navref");
            Random random = new Random();
            String newMapFile = "MAPCHUNK" + Math.abs(random.nextInt()) + ".ditamap";
            navref.setAttribute("mapref", newMapFile);
            node.getParentNode().replaceChild(navref, node);
            root.appendChild(node);
            String navmap = FileUtils.resolveFile(this.filePath, newMapFile);
            this.changeTable.put(navmap, navmap);
            this.outputMapFile(navmap, (Element)root);
        } else if (this.chunkByTopic) {
            this.processChunk((Element)node, true, this.chunkByTopic);
            if (chunkValue != null && (chunkValue.contains("by-topic") || chunkValue.contains("by-document"))) {
                this.chunkByTopic = prevChunkByTopic;
            }
            this.processChildTopicref(node);
        } else {
            String currentPath = null;
            if (copytoValue != null) {
                currentPath = FileUtils.resolveFile(this.filePath, copytoValue);
            } else if (hrefValue != null) {
                currentPath = FileUtils.resolveFile(this.filePath, hrefValue);
            }
            if (currentPath != null) {
                if (this.changeTable.containsKey(currentPath)) {
                    this.changeTable.remove(currentPath);
                }
                if (!this.refFileSet.contains(currentPath)) {
                    this.refFileSet.add(currentPath);
                }
            }
            if (!(chunkValue == null && this.chunkByTopic || currentPath == null || "resource-only".equals(this.processingRole))) {
                this.changeTable.put(currentPath, currentPath);
            }
            if (chunkValue != null && (chunkValue.contains("by-topic") || chunkValue.contains("by-document"))) {
                this.chunkByTopic = prevChunkByTopic;
            }
            this.processChildTopicref(node);
        }
        if (chunkValue != null && (chunkValue.contains("by-topic") || chunkValue.contains("by-document"))) {
            this.chunkByTopic = prevChunkByTopic;
        }
        this.processingRole = tempRole;
    }

    private void processChildTopicref(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (current.getNodeType() != 1) continue;
            String classValue = ((Element)current).getAttribute("class");
            String hrefValue = ((Element)current).getAttribute("href");
            String xtrfValue = ((Element)current).getAttribute("xtrf");
            if (classValue.indexOf(" map/topicref ") == -1) continue;
            if (!hrefValue.equals("") && !"generated_by_chunk".equals(xtrfValue) && !FileUtils.resolveFile(this.filePath, hrefValue).equals(this.changeTable.get(FileUtils.resolveFile(this.filePath, hrefValue))) || classValue.contains(" mapgroup-d/topichead ")) {
                this.processTopicref(current);
                continue;
            }
            if (!hrefValue.equals("")) continue;
            this.processTopicref(current);
        }
    }

    private void processChunk(Element elem, boolean separate, boolean chunkByTopic) {
        try {
            ChunkTopicParser chunkParser = new ChunkTopicParser();
            chunkParser.setup(this.changeTable, this.conflictTable, this.refFileSet, elem, separate, chunkByTopic, this.ditaext);
            chunkParser.write(this.filePath);
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
    }

    private void updateReltable(Element elem) {
        String hrefValue = elem.getAttribute("href");
        String resulthrefValue = null;
        if (!hrefValue.equals("") && this.changeTable.containsKey(FileUtils.resolveFile(this.filePath, hrefValue))) {
            resulthrefValue = hrefValue.indexOf("#") != -1 ? FileUtils.getRelativePathFromMap(this.filePath + "/" + "stub.ditamap", FileUtils.resolveFile(this.filePath, hrefValue)) + hrefValue.substring(hrefValue.indexOf("#") + 1) : FileUtils.getRelativePathFromMap(this.filePath + "/" + "stub.ditamap", FileUtils.resolveFile(this.filePath, hrefValue));
            elem.setAttribute("href", resulthrefValue);
        }
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String classValue;
            Node current = children.item(i);
            if (current.getNodeType() == 1 && (classValue = ((Element)current).getAttribute("class")).indexOf(" map/topicref ") == -1) continue;
        }
    }

    @Override
    public Content getContent() {
        ContentImpl content = new ContentImpl();
        content.setValue(this.changeTable);
        return content;
    }

    public Hashtable<String, String> getConflicTable() {
        return this.conflictTable;
    }

    public void setup(String ditaext, String transtype) {
        this.ditaext = ditaext;
        this.transtype = transtype;
    }
}

