/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermCollection;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.index.TopicrefElement;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DitamapIndexTermReader
extends AbstractXMLReader {
    private Stack elementStack = new Stack();
    private List indexTermSpecList = new ArrayList(16);
    private List topicrefSpecList = new ArrayList(16);
    private List indexSeeSpecList = new ArrayList(16);
    private List indexSeeAlsoSpecList = new ArrayList(16);
    private String mapPath = null;
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();

    public void characters(char[] ch, int start, int length) throws SAXException {
        String temp = new String(ch, start, length);
        IndexTerm indexTerm = null;
        if (ch[start] == '\n' || temp.startsWith(Constants.LINE_SEPARATOR)) {
            temp = " " + temp.substring(1);
        }
        char[] chars = temp.toCharArray();
        int flag = 10;
        StringBuffer sb = new StringBuffer();
        for (int n : chars) {
            if (n == 32) {
                if (flag == 32) continue;
                sb.append((char)n);
                flag = n;
                continue;
            }
            sb.append((char)n);
            flag = n;
        }
        temp = sb.toString();
        if (this.elementStack.empty() || !(this.elementStack.peek() instanceof IndexTerm)) {
            return;
        }
        indexTerm = (IndexTerm)this.elementStack.peek();
        indexTerm.setTermName(StringUtils.setOrAppend(indexTerm.getTermName(), temp, false));
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.topicrefSpecList.contains(localName)) {
            this.elementStack.pop();
            return;
        }
        if (this.indexTermSpecList.contains(localName) && this.needPushTerm()) {
            IndexTerm indexTerm = (IndexTerm)this.elementStack.pop();
            Object obj = null;
            if (indexTerm.getTermName() == null || indexTerm.getTermName().trim().equals("")) {
                if (indexTerm.getEndAttribute() != null && !indexTerm.hasSubTerms()) {
                    return;
                }
                indexTerm.setTermName("***");
                this.javaLogger.logWarn(MessageUtils.getMessage("DOTJ014W").toString());
            }
            if (indexTerm.getTermKey() == null) {
                indexTerm.setTermKey(indexTerm.getTermName());
            }
            if ((obj = this.elementStack.peek()) instanceof TopicrefElement) {
                if (((TopicrefElement)obj).getHref() != null) {
                    this.genTargets(indexTerm, obj);
                    IndexTermCollection.getInstantce().addTerm(indexTerm);
                }
            } else {
                IndexTerm parentTerm = obj;
                parentTerm.addSubTerm(indexTerm);
            }
        }
        if (this.indexSeeSpecList.contains(localName) || this.indexSeeAlsoSpecList.contains(localName)) {
            IndexTerm term = (IndexTerm)this.elementStack.pop();
            if (term.getTermKey() == null) {
                term.setTermKey(term.getTermFullName());
            }
            if (this.elementStack.peek() instanceof IndexTerm) {
                IndexTerm parentTerm = (IndexTerm)this.elementStack.peek();
                parentTerm.addSubTerm(term);
            }
        }
    }

    private void genTargets(IndexTerm indexTerm, TopicrefElement obj) {
        TopicrefElement topicref = obj;
        IndexTermTarget target = new IndexTermTarget();
        String targetURI = null;
        String href = topicref.getHref();
        StringBuffer buffer = new StringBuffer();
        if (!href.contains("://") && !FileUtils.isAbsolutePath(href)) {
            if (this.mapPath != null && !"".equals(this.mapPath)) {
                buffer.append(this.mapPath);
                buffer.append("/");
            }
            buffer.append(href);
            targetURI = FileUtils.removeRedundantNames(buffer.toString());
        } else {
            targetURI = href;
        }
        if (topicref.getNavTitle() != null) {
            target.setTargetName(topicref.getNavTitle());
        } else {
            target.setTargetName(href);
        }
        target.setTargetURI(targetURI);
        this.assignTarget(indexTerm, target);
    }

    private void assignTarget(IndexTerm indexTerm, IndexTermTarget target) {
        if (indexTerm.isLeaf()) {
            indexTerm.addTarget(target);
        }
        if (indexTerm.hasSubTerms()) {
            for (Object subTerm : indexTerm.getSubTerms()) {
                this.assignTarget((IndexTerm)subTerm, target);
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String classAttr = attributes.getValue("class");
        if (classAttr != null && classAttr.contains(" topic/indexterm ") && !this.indexTermSpecList.contains(localName)) {
            this.indexTermSpecList.add(localName);
        }
        if (classAttr != null && classAttr.contains(" map/topicref ") && !this.topicrefSpecList.contains(localName)) {
            this.topicrefSpecList.add(localName);
        }
        if (classAttr != null && classAttr.contains(" indexing-d/index-see ") && !this.indexSeeSpecList.contains(localName)) {
            this.indexSeeSpecList.add(localName);
        }
        if (classAttr != null && classAttr.contains(" indexing-d/index-see-also ") && !this.indexSeeAlsoSpecList.contains(localName)) {
            this.indexSeeAlsoSpecList.add(localName);
        }
        if (this.topicrefSpecList.contains(localName)) {
            String href = attributes.getValue("href");
            String format = attributes.getValue("format");
            String navtitle = attributes.getValue("navtitle");
            TopicrefElement topicref = new TopicrefElement();
            topicref.setHref(href);
            topicref.setFormat(format);
            topicref.setNavTitle(navtitle);
            this.elementStack.push(topicref);
            return;
        }
        this.parseIndexTerm(localName, attributes);
        this.parseIndexSee(localName);
        this.parseIndexSeeAlso(localName);
    }

    private void parseIndexSeeAlso(String localName) {
        if (this.indexSeeAlsoSpecList.contains(localName) && this.needPushTerm()) {
            IndexTerm indexTerm = new IndexTerm();
            IndexTerm parentTerm = null;
            if (!this.elementStack.isEmpty() && this.elementStack.peek() instanceof IndexTerm && (parentTerm = (IndexTerm)this.elementStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
            }
            indexTerm.setTermPrefix("See also");
            this.elementStack.push(indexTerm);
        }
    }

    private void parseIndexSee(String localName) {
        if (this.indexSeeSpecList.contains(localName) && this.needPushTerm()) {
            IndexTerm indexTerm = new IndexTerm();
            IndexTerm parentTerm = null;
            indexTerm.setTermPrefix("See");
            if (!this.elementStack.isEmpty() && this.elementStack.peek() instanceof IndexTerm && (parentTerm = (IndexTerm)this.elementStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
                indexTerm.setTermPrefix("See also");
            }
            this.elementStack.push(indexTerm);
        }
    }

    private void parseIndexTerm(String localName, Attributes attributes) {
        if (this.indexTermSpecList.contains(localName) && this.needPushTerm()) {
            IndexTerm indexTerm = new IndexTerm();
            indexTerm.setStartAttribute(attributes.getValue("end"));
            indexTerm.setEndAttribute(attributes.getValue("end"));
            IndexTerm parentTerm = null;
            if (!this.elementStack.isEmpty() && this.elementStack.peek() instanceof IndexTerm && (parentTerm = (IndexTerm)this.elementStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
            }
            this.elementStack.push(indexTerm);
        }
    }

    private boolean needPushTerm() {
        if (this.elementStack.empty()) {
            return false;
        }
        return !(this.elementStack.peek() instanceof TopicrefElement) || !FileUtils.isDITAFile(((TopicrefElement)this.elementStack.peek()).getHref());
    }

    public void setMapPath(String mappath) {
        this.mapPath = mappath;
    }
}

