/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Stack;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.resolver.DitaURIResolverFactory;
import org.dita.dost.resolver.URIResolverAdapter;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyrefReader
extends AbstractXMLReader {
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
    private XMLReader reader;
    private Hashtable<String, String> keyDefTable = new Hashtable();
    private Stack<KeyDef> keyDefs;
    private Set<String> keys = new HashSet<String>();
    private String tempDir;

    public KeyrefReader() {
        try {
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXException ex) {
            this.javaLogger.logException(ex);
        }
        this.reader.setContentHandler(this);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isStart()) {
            this.keyDefAppend(StringUtils.escapeXML(ch, start, length));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.isStart()) {
            this.decKeyDefLevel();
            this.keyDefAppend("<");
            this.keyDefAppend("/");
            this.keyDefAppend(name);
            this.keyDefAppend(">");
        }
        if (this.isStart() && this.getKeyDefLevel() == 0) {
            KeyDef keyDef = this.popKeyDef();
            for (String keyName : keyDef.key.split(" ")) {
                if (keyName.equals("")) continue;
                this.keyDefTable.put(keyName, keyDef.keyDefContent.toString());
            }
        }
    }

    @Override
    public Content getContent() {
        ContentImpl content = new ContentImpl();
        content.setValue(this.keyDefTable);
        return content;
    }

    @Override
    public void read(String filename) {
        this.keyDefs = new Stack();
        try {
            InputSource source = URIResolverAdapter.convertToInputSource(DitaURIResolverFactory.getURIResolver().resolve(filename, null));
            this.reader.parse(source);
        }
        catch (Exception ex) {
            this.javaLogger.logException(ex);
        }
    }

    public void setKeys(Set<String> set) {
        this.keys = set;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String classValue = atts.getValue("class");
        String keyName = atts.getValue("keys");
        if (keyName != null && classValue.contains(" map/topicref ")) {
            boolean flag = false;
            String[] keyNames = keyName.split(" ");
            int index = 0;
            while (index < keyNames.length) {
                if (!this.keys.contains(keyNames[index++])) continue;
                flag = true;
                break;
            }
            if (keyName != null && flag) {
                this.pushKeyDef(keyName);
                this.incKeyDefLevel();
                this.putElement(name, atts);
            }
        } else if (this.isStart()) {
            this.incKeyDefLevel();
            this.putElement(name, atts);
        }
    }

    private void putElement(String elemName, Attributes atts) {
        int index = 0;
        this.keyDefAppend("<");
        this.keyDefAppend(elemName);
        for (index = 0; index < atts.getLength(); ++index) {
            this.keyDefAppend(" ");
            this.keyDefAppend(atts.getQName(index));
            this.keyDefAppend("=");
            this.keyDefAppend("\"");
            String value = atts.getValue(index);
            value = StringUtils.escapeXML(value);
            this.keyDefAppend(value);
            this.keyDefAppend("\"");
        }
        this.keyDefAppend(">");
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    private void pushKeyDef(String keyName) {
        this.keyDefs.push(new KeyDef(keyName));
    }

    private KeyDef popKeyDef() {
        return this.keyDefs.pop();
    }

    private void keyDefAppend(String content) {
        for (KeyDef keyDef : this.keyDefs) {
            keyDef.keyDefContent.append(content);
        }
    }

    private boolean isStart() {
        return this.keyDefs.size() > 0;
    }

    private void incKeyDefLevel() {
        this.addKeyDefLevel(1);
    }

    private void decKeyDefLevel() {
        this.addKeyDefLevel(-1);
    }

    private void addKeyDefLevel(int dif) {
        this.keyDefs.peek().keyDefLevel += dif;
    }

    private int getKeyDefLevel() {
        return this.keyDefs.peek().keyDefLevel;
    }

    protected static class KeyDef {
        protected String key;
        protected StringBuffer keyDefContent;
        protected int keyDefLevel = 0;

        public KeyDef(String key) {
            this.key = key;
            this.keyDefContent = new StringBuffer();
        }
    }
}

