/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.ListUtils;
import org.dita.dost.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListReader
implements AbstractReader {
    private LinkedList<String> refList;
    private ContentImpl content;
    private Map<String, String> copytoMap = new HashMap<String, String>();
    private Set<String> schemeSet = new HashSet<String>();
    private String inputMap;

    public ListReader() {
        this.refList = new LinkedList();
        this.content = new ContentImpl();
        this.content.setCollection(this.refList);
    }

    @Override
    public void read(String filename) {
        Properties propterties = null;
        try {
            propterties = ListUtils.getDitaList();
        }
        catch (Exception e) {
            DITAOTJavaLogger logger = new DITAOTJavaLogger();
            logger.logException(e);
        }
        this.setList(propterties);
        this.schemeSet.addAll(StringUtils.restoreSet(propterties.getProperty("subjectschemelist", "")));
        this.inputMap = propterties.getProperty("user.input.file");
    }

    private void setList(Properties property) {
        this.content.setValue(property.getProperty("user.input.dir"));
        String copytoMapEntries = property.getProperty("copytotarget2sourcemaplist");
        this.copytoMap = StringUtils.restoreMap(copytoMapEntries);
        String liststr = property.getProperty("fullditamapandtopiclist") + "," + property.getProperty("conreftargetslist") + "," + property.getProperty("copytosourcelist");
        StringTokenizer tokenizer = new StringTokenizer(liststr, ",");
        while (tokenizer.hasMoreTokens()) {
            this.refList.addFirst(tokenizer.nextToken());
        }
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    public Map<String, String> getCopytoMap() {
        return this.copytoMap;
    }

    public Set<String> getSchemeSet() {
        return this.schemeSet;
    }

    public String getInputMap() {
        return this.inputMap;
    }
}

