/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.resolver.DitaURIResolverFactory;
import org.dita.dost.resolver.URIResolverAdapter;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MapIndexReader
extends AbstractXMLReader {
    private static final String INTERNET_LINK_MARK = "://";
    private List ancestorList;
    private String filePath = null;
    private String filePathName = null;
    private String firstMatchElement = null;
    private StringBuffer indexEntries;
    private File inputFile = null;
    private String lastMatchElement = null;
    private int level = 0;
    private DITAOTJavaLogger logger;
    private HashMap map = new HashMap();
    private boolean match = false;
    private List matchList;
    private boolean needResolveEntity = false;
    private XMLReader reader;
    private String topicPath = null;
    private boolean validHref = true;

    private static boolean verifyIndexEntries(StringBuffer str) {
        int end;
        if (str.length() == 0) {
            return false;
        }
        int start = str.indexOf(">");
        String temp = str.substring(start + 1, end = str.lastIndexOf("<"));
        return temp.trim().length() != 0;
    }

    public MapIndexReader() {
        this.ancestorList = new ArrayList(16);
        this.matchList = new ArrayList(16);
        this.indexEntries = new StringBuffer(1024);
        this.logger = new DITAOTJavaLogger();
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.match && this.needResolveEntity && this.validHref) {
            String temp = new String(ch, start, length);
            this.indexEntries.append(StringUtils.escapeXML(temp));
        }
    }

    private boolean checkMatch() {
        int matchSize = this.matchList.size();
        int ancestorSize = this.ancestorList.size();
        ListIterator matchIterator = this.matchList.listIterator();
        ListIterator ancestorIterator = this.ancestorList.listIterator(ancestorSize - matchSize);
        while (matchIterator.hasNext()) {
            String ancestor;
            String currentMatchString = (String)matchIterator.next();
            if (currentMatchString.equals(ancestor = (String)ancestorIterator.next())) continue;
            return false;
        }
        return true;
    }

    public void endCDATA() throws SAXException {
        if (this.match && this.validHref) {
            this.indexEntries.append("]]>");
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.match) {
            if (this.validHref) {
                this.indexEntries.append("<");
                this.indexEntries.append("/");
                this.indexEntries.append(qName);
                this.indexEntries.append(">");
            }
            --this.level;
        }
        if (qName.equals(this.lastMatchElement) && this.level == 0 && this.match) {
            this.match = false;
        }
        if (!this.match) {
            this.ancestorList.remove(this.ancestorList.size() - 1);
        }
        if (qName.equals(this.firstMatchElement) && MapIndexReader.verifyIndexEntries(this.indexEntries) && this.topicPath != null) {
            String origin = (String)this.map.get(this.topicPath);
            if (origin != null) {
                this.map.put(this.topicPath, origin + this.indexEntries.toString());
            } else {
                this.map.put(this.topicPath, this.indexEntries.toString());
            }
            this.indexEntries = new StringBuffer(1024);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    public Content getContent() {
        ContentImpl result = new ContentImpl();
        result.setCollection(this.map.entrySet());
        return result;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.match && this.validHref) {
            String temp = new String(ch, start, length);
            this.indexEntries.append(temp);
        }
    }

    public void read(String filename) {
        if (this.matchList.isEmpty()) {
            this.logger.logError(MessageUtils.getMessage("DOTJ008E").toString());
        } else {
            this.match = false;
            this.needResolveEntity = true;
            this.inputFile = new File(filename);
            this.filePath = this.inputFile.getParent();
            this.filePathName = this.inputFile.getPath();
            if (this.indexEntries.length() != 0) {
                this.indexEntries = new StringBuffer(1024);
            }
            try {
                this.reader.setErrorHandler(new DITAOTXMLErrorHandler(filename));
                InputSource source = URIResolverAdapter.convertToInputSource(DitaURIResolverFactory.getURIResolver().resolve(filename, null));
                this.reader.parse(source);
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    public void setMatch(String matchPattern) {
        int index = 0;
        String string = this.firstMatchElement = matchPattern.indexOf("/") != -1 ? matchPattern.substring(0, matchPattern.indexOf("/")) : matchPattern;
        while (index != -1) {
            int end = matchPattern.indexOf("/", index);
            if (end == -1) {
                this.matchList.add(matchPattern.substring(index));
                this.lastMatchElement = matchPattern.substring(index);
                index = end;
                continue;
            }
            this.matchList.add(matchPattern.substring(index, end));
            index = end + 1;
        }
    }

    public void startCDATA() throws SAXException {
        if (this.match && this.validHref) {
            this.indexEntries.append("<![CDATA[");
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int attsLen = atts.getLength();
        String attrScope = atts.getValue("scope");
        String attrFormat = atts.getValue("format");
        if (qName.equals(this.firstMatchElement)) {
            String hrefValue = atts.getValue("href");
            if (MapIndexReader.verifyIndexEntries(this.indexEntries) && this.topicPath != null) {
                String origin = (String)this.map.get(this.topicPath);
                this.map.put(this.topicPath, StringUtils.setOrAppend(origin, this.indexEntries.toString(), false));
                this.indexEntries = new StringBuffer(1024);
            }
            this.topicPath = null;
            if (hrefValue != null && hrefValue.indexOf(INTERNET_LINK_MARK) == -1 && (attrScope == null || "local".equalsIgnoreCase(attrScope)) && (attrFormat == null || "dita".equalsIgnoreCase(attrFormat))) {
                this.topicPath = FileUtils.resolveTopic(this.filePath, hrefValue);
                this.validHref = true;
            } else {
                this.topicPath = null;
                this.validHref = false;
            }
        }
        if (!this.match) {
            this.ancestorList.add(qName);
            if (qName.equals(this.lastMatchElement) && this.checkMatch()) {
                this.match = true;
                this.level = 0;
            }
        }
        if (this.match) {
            if (this.validHref) {
                this.indexEntries.append("<" + qName + " ");
                for (int i = 0; i < attsLen; ++i) {
                    this.indexEntries.append(atts.getQName(i));
                    this.indexEntries.append("=");
                    this.indexEntries.append("\"");
                    this.indexEntries.append(StringUtils.escapeXML(atts.getValue(i)));
                    this.indexEntries.append("\"");
                    this.indexEntries.append(" ");
                }
                this.indexEntries.append(">");
            }
            ++this.level;
        }
    }

    public void startEntity(String name) throws SAXException {
        this.needResolveEntity = StringUtils.checkEntity(name);
        if (this.match && !this.needResolveEntity && this.validHref) {
            this.indexEntries.append(StringUtils.getEntity(name));
        }
    }
}

