/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.reader.MergeTopicParser;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.MergeUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MergeMapParser
extends AbstractXMLReader {
    private XMLReader reader = null;
    private StringBuffer mapInfo = null;
    private MergeTopicParser topicParser = null;
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();
    private MergeUtils util;
    private ContentImpl content;
    private String dirPath = null;
    private String tempdir = null;
    private Stack<String> processStack;
    private int processLevel = 0;

    public MergeMapParser() {
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            if (this.reader == null) {
                this.reader = XMLReaderFactory.createXMLReader();
                this.reader.setContentHandler(this);
                this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            if (this.mapInfo == null) {
                this.mapInfo = new StringBuffer(1024);
            }
            this.processStack = new Stack();
            this.processLevel = 0;
            this.topicParser = new MergeTopicParser();
            this.topicParser.reset();
            this.content = new ContentImpl();
            this.util = MergeUtils.getInstance();
            this.util.reset();
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public Content getContent() {
        this.content.setValue(this.mapInfo.append((StringBuffer)this.topicParser.getContent().getValue()));
        return this.content;
    }

    public void read(String ditaInput) {
        try {
            String filename;
            if (ditaInput.contains("|")) {
                filename = ditaInput.substring(0, ditaInput.indexOf("|"));
                this.tempdir = ditaInput.substring(ditaInput.indexOf("|") + 1);
            } else {
                filename = ditaInput;
                this.tempdir = new File(filename).getParent();
            }
            File input = new File(filename);
            this.dirPath = input.getParent();
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(filename));
            this.reader.parse(filename);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.processLevel > 0) {
            String value = this.processStack.peek();
            if (this.processLevel == this.processStack.size()) {
                value = this.processStack.pop();
            }
            --this.processLevel;
            if ("resource-only".equalsIgnoreCase(value)) {
                return;
            }
        }
        this.mapInfo.append("<").append("/").append(qName).append(">");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.processStack.empty() || !"resource-only".equalsIgnoreCase(this.processStack.peek())) {
            this.mapInfo.append(StringUtils.escapeXML(ch, start, length));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String scopeValue = null;
        String formatValue = null;
        String classValue = null;
        String fileId = null;
        int attsLen = atts.getLength();
        String attrValue = atts.getValue("processing-role");
        if (attrValue != null) {
            this.processStack.push(attrValue);
            ++this.processLevel;
            if ("resource-only".equalsIgnoreCase(attrValue)) {
                return;
            }
        } else if (this.processLevel > 0) {
            ++this.processLevel;
            if ("resource-only".equalsIgnoreCase(this.processStack.peek())) {
                return;
            }
        }
        this.mapInfo.append("<").append(qName);
        classValue = atts.getValue("class");
        for (int i = 0; i < attsLen; ++i) {
            String attQName = atts.getQName(i);
            String attValue = atts.getValue(i);
            if ("href".equals(attQName) && !StringUtils.isEmptyString(attValue) && classValue != null && classValue.indexOf(" map/topicref ") != -1) {
                scopeValue = atts.getValue("scope");
                formatValue = atts.getValue("format");
                if ((scopeValue == null || "local".equalsIgnoreCase(scopeValue)) && (formatValue == null || "dita".equalsIgnoreCase(formatValue))) {
                    String ohref = attValue;
                    String copyToValue = atts.getValue("copy-to");
                    if (!StringUtils.isEmptyString(copyToValue)) {
                        attValue = copyToValue;
                    }
                    if (this.util.isVisited(attValue)) {
                        this.mapInfo.append(" ").append("ohref").append("=").append("\"").append(StringUtils.escapeXML(ohref)).append("\"");
                        attValue = new StringBuffer("#").append(this.util.getIdValue(attValue)).toString();
                    } else {
                        this.mapInfo.append(" ").append("ohref").append("=").append("\"").append(StringUtils.escapeXML(ohref)).append("\"");
                        fileId = this.topicParser.parse(attValue, this.dirPath);
                        this.util.visit(attValue);
                        attValue = new StringBuffer("#").append(fileId).toString();
                    }
                }
            }
            this.mapInfo.append(" ").append(attQName).append("=").append("\"").append(StringUtils.escapeXML(attValue)).append("\"");
        }
        this.mapInfo.append(">");
    }

    public void processingInstruction(String target, String data) throws SAXException {
        String pi = data != null ? target + " " + data : target;
        this.mapInfo.append("<?" + pi + "?" + ">");
    }

    public void endDocument() throws SAXException {
        Properties property = new Properties();
        File ditalist = new File(this.tempdir, "dita.list");
        File xmlDitalist = new File(this.tempdir, "dita.xml.properties");
        try {
            if (xmlDitalist.exists()) {
                property.loadFromXML(new FileInputStream(xmlDitalist));
            } else {
                property.loadFromXML(new FileInputStream(ditalist));
            }
            String hrefTargetList = property.getProperty("hreftargetslist");
            String resourceOnlySet = property.getProperty("resourceonlylist");
            resourceOnlySet = resourceOnlySet == null ? "" : resourceOnlySet;
            String skipTopicSet = property.getProperty("skipchunklist");
            skipTopicSet = skipTopicSet == null ? "" : skipTopicSet;
            String chunkedTopicSet = property.getProperty("chunkedtopiclist");
            chunkedTopicSet = chunkedTopicSet == null ? "" : chunkedTopicSet;
            StringTokenizer tokenizer = new StringTokenizer(hrefTargetList, ",");
            String element = null;
            while (tokenizer.hasMoreElements()) {
                element = (String)tokenizer.nextElement();
                if (!new File(this.dirPath).equals(new File(this.tempdir))) {
                    element = FileUtils.getRelativePathFromMap(new File(this.dirPath, "a.ditamap").getAbsolutePath(), new File(this.tempdir, element).getAbsolutePath());
                }
                if (this.util.isVisited(element)) continue;
                this.util.visit(element);
                if (resourceOnlySet.contains(element) || !chunkedTopicSet.contains(element) && skipTopicSet.contains(element)) continue;
                this.topicParser.parse(element, this.dirPath);
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }
}

